/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

public class SnippetBuilder {
    private static final String PARAM_PREFIX = "$";
    private static final String PARAM = "$param";
    private String _template;

    public SnippetBuilder(String snippetTemplate) {
        this._template = snippetTemplate;
    }

    public String build(String cellValue) {
        if (this._template == null) {
            throw new RuntimeException("Script template is null - check for missing script definition.");
        }
        if (this._template.indexOf("$1") >= 0) {
            return this.buildMulti(cellValue);
        }
        return this.buildSingle(cellValue);
    }

    private String buildMulti(String cellValue) {
        String[] cellVals = cellValue.split(",");
        String result = this._template;
        for (int paramNumber = 0; paramNumber < cellVals.length; ++paramNumber) {
            String replace = PARAM_PREFIX + (paramNumber + 1);
            result = this.replace(result, replace, cellVals[paramNumber].trim(), 256);
        }
        return result;
    }

    private String buildSingle(String cellValue) {
        return this.replace(this._template, PARAM, cellValue, 256);
    }

    private String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || repl.equals("") || with == null || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }
}

