/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.parser.ArrayColumn;
import org.drools.decisiontable.parser.Column;

public class ColumnFactory {
    private static final Pattern PATTERN = Pattern.compile("([a-zA-Z0-9_]*)(\\[\\])?(:\\s*([a-zA-Z]*)(\\[\\])?)?");

    public Column getColumn(String value) {
        boolean array;
        Matcher m = PATTERN.matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException("value " + value + " is not a valid column definition");
        }
        String name = m.group(1);
        String type = m.group(4);
        type = type == null ? "String" : type;
        boolean bl = array = m.group(2) != null || m.group(5) != null;
        if (array) {
            return new ArrayColumn(name, this.createColumn(name, type));
        }
        return this.createColumn(name, type);
    }

    private Column createColumn(String name, String type) {
        try {
            Class<?> klass = Class.forName(this.getClass().getPackage().getName() + "." + type + "Column");
            Constructor<?> constructor = klass.getConstructor(String.class);
            return (Column)constructor.newInstance(name);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

