/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.event.ActivationLogEvent;
import org.drools.audit.event.ILogEventFilter;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.ObjectLogEvent;
import org.drools.audit.event.RuleBaseLogEvent;
import org.drools.audit.event.RuleFlowGroupLogEvent;
import org.drools.audit.event.RuleFlowLogEvent;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AfterFunctionRemovedEvent;
import org.drools.event.AfterPackageAddedEvent;
import org.drools.event.AfterPackageRemovedEvent;
import org.drools.event.AfterRuleAddedEvent;
import org.drools.event.AfterRuleBaseLockedEvent;
import org.drools.event.AfterRuleBaseUnlockedEvent;
import org.drools.event.AfterRuleRemovedEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.BeforeFunctionRemovedEvent;
import org.drools.event.BeforePackageAddedEvent;
import org.drools.event.BeforePackageRemovedEvent;
import org.drools.event.BeforeRuleAddedEvent;
import org.drools.event.BeforeRuleBaseLockedEvent;
import org.drools.event.BeforeRuleBaseUnlockedEvent;
import org.drools.event.BeforeRuleRemovedEvent;
import org.drools.event.ObjectInsertedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.event.ObjectUpdatedEvent;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.RuleFlowCompletedEvent;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.RuleFlowStartedEvent;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.Tuple;

public abstract class WorkingMemoryLogger
implements WorkingMemoryEventListener,
AgendaEventListener,
RuleFlowEventListener,
RuleBaseEventListener {
    private final List filters = new ArrayList();
    private WorkingMemoryEventManager workingMemoryEventManager;

    public WorkingMemoryLogger(WorkingMemoryEventManager workingMemoryEventManager) {
        this.workingMemoryEventManager = workingMemoryEventManager;
        this.workingMemoryEventManager.addEventListener(this);
        this.workingMemoryEventManager.addEventListener(this);
        this.workingMemoryEventManager.addEventListener(this);
        this.workingMemoryEventManager.addEventListener(this);
    }

    public abstract void logEventCreated(LogEvent var1);

    private void filterLogEvent(LogEvent logEvent) {
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            ILogEventFilter filter = (ILogEventFilter)iterator.next();
            if (filter.acceptEvent(logEvent)) continue;
            return;
        }
        this.logEventCreated(logEvent);
    }

    public void addFilter(ILogEventFilter filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filters.add(filter);
    }

    public void removeFilter(ILogEventFilter filter) {
        this.filters.remove(filter);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void objectInserted(ObjectInsertedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(1, ((InternalFactHandle)event.getFactHandle()).getId(), event.getObject().toString()));
    }

    public void objectUpdated(ObjectUpdatedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(2, ((InternalFactHandle)event.getFactHandle()).getId(), event.getObject().toString()));
    }

    public void objectRetracted(ObjectRetractedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(3, ((InternalFactHandle)event.getFactHandle()).getId(), event.getOldObject().toString()));
    }

    public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(4, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation(), workingMemory), event.getActivation().getRule().getRuleFlowGroup()));
    }

    public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(5, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation(), workingMemory), event.getActivation().getRule().getRuleFlowGroup()));
    }

    public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(6, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation(), workingMemory), event.getActivation().getRule().getRuleFlowGroup()));
    }

    public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(7, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation(), workingMemory), event.getActivation().getRule().getRuleFlowGroup()));
    }

    private String extractDeclarations(Activation activation, WorkingMemory workingMemory) {
        StringBuffer result = new StringBuffer();
        Tuple tuple = activation.getTuple();
        Map declarations = activation.getSubRule().getOuterDeclarations();
        Iterator it = declarations.values().iterator();
        while (it.hasNext()) {
            Declaration declaration = (Declaration)it.next();
            InternalFactHandle handle = tuple.get(declaration);
            if (handle instanceof InternalFactHandle) {
                InternalFactHandle handleImpl = handle;
                if (handleImpl.getId() == -1L) continue;
                Object value = declaration.getValue((InternalWorkingMemory)workingMemory, workingMemory.getObject(handle));
                result.append(declaration.getIdentifier());
                result.append("=");
                if (value == null) {
                    result.append("null");
                } else {
                    result.append(value);
                    result.append("(");
                    result.append(handleImpl.getId());
                    result.append(")");
                }
            }
            if (!it.hasNext()) continue;
            result.append("; ");
        }
        return result.toString();
    }

    private static String getActivationId(Activation activation) {
        StringBuffer result = new StringBuffer(activation.getRule().getName());
        result.append(" [");
        Tuple tuple = activation.getTuple();
        InternalFactHandle[] handles = tuple.getFactHandles();
        for (int i = 0; i < handles.length; ++i) {
            result.append(handles[i].getId());
            if (i >= handles.length - 1) continue;
            result.append(", ");
        }
        return result.append("]").toString();
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
    }

    public void ruleFlowStarted(RuleFlowStartedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new RuleFlowLogEvent(8, event.getRuleFlowProcessInstance().getProcess().getId(), event.getRuleFlowProcessInstance().getProcess().getName()));
    }

    public void ruleFlowCompleted(RuleFlowCompletedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new RuleFlowLogEvent(9, event.getRuleFlowProcessInstance().getProcess().getId(), event.getRuleFlowProcessInstance().getProcess().getName()));
    }

    public void ruleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new RuleFlowGroupLogEvent(10, event.getRuleFlowGroup().getName(), event.getRuleFlowGroup().size()));
    }

    public void ruleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new RuleFlowGroupLogEvent(11, event.getRuleFlowGroup().getName(), event.getRuleFlowGroup().size()));
    }

    public void afterPackageAdded(AfterPackageAddedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(13, event.getPackage().getName(), null));
    }

    public void afterPackageRemoved(AfterPackageRemovedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(15, event.getPackage().getName(), null));
    }

    public void afterRuleAdded(AfterRuleAddedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(17, event.getPackage().getName(), event.getRule().getName()));
    }

    public void afterRuleRemoved(AfterRuleRemovedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(19, event.getPackage().getName(), event.getRule().getName()));
    }

    public void beforePackageAdded(BeforePackageAddedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(12, event.getPackage().getName(), null));
    }

    public void beforePackageRemoved(BeforePackageRemovedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(14, event.getPackage().getName(), null));
    }

    public void beforeRuleAdded(BeforeRuleAddedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(16, event.getPackage().getName(), event.getRule().getName()));
    }

    public void beforeRuleRemoved(BeforeRuleRemovedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(18, event.getPackage().getName(), event.getRule().getName()));
    }

    public void afterFunctionRemoved(AfterFunctionRemovedEvent event) {
    }

    public void afterRuleBaseLocked(AfterRuleBaseLockedEvent event) {
    }

    public void afterRuleBaseUnlocked(AfterRuleBaseUnlockedEvent event) {
    }

    public void beforeFunctionRemoved(BeforeFunctionRemovedEvent event) {
    }

    public void beforeRuleBaseLocked(BeforeRuleBaseLockedEvent event) {
    }

    public void beforeRuleBaseUnlocked(BeforeRuleBaseUnlockedEvent event) {
    }
}

