/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.beans.ChartData;
import app.astrosoft.consts.Rasi;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.util.Utils;
import java.util.EnumSet;
import java.util.Set;

public abstract class AbstractChartData
implements ChartData {
    protected String chartName;
    protected DefaultColumnMetaData colMetaData = this.getHouseTableColMetaData();
    protected Rasi ascendant;

    public AbstractChartData(String string) {
        this();
        this.chartName = string;
    }

    public AbstractChartData() {
        this.colMetaData.localizeColumns();
    }

    @Override
    public String getChartName() {
        return this.chartName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        for (Rasi rasi : Rasi.values()) {
            stringBuilder.append((Object)((Object)rasi) + " : \n");
            stringBuilder.append(Utils.printTableData(this.getChartHouseTable(rasi)));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<Rasi> getHouses() {
        return EnumSet.allOf(Rasi.class);
    }

    @Override
    public Rasi getAscendant() {
        return this.ascendant;
    }

    public abstract DefaultColumnMetaData getHouseTableColMetaData();
}

