/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.beans.AbstractChartData;
import app.astrosoft.consts.AshtavargaName;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Rasi;
import app.astrosoft.core.Ashtavarga;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import java.util.EnumMap;

public class AshtaVargaChartData
extends AbstractChartData
implements Exportable {
    private EnumMap<Rasi, Integer> varga;

    public AshtaVargaChartData(AshtavargaName ashtavargaName, EnumMap<Rasi, Integer> enumMap) {
        this.varga = enumMap;
        this.chartName = ashtavargaName.toString();
        int n = Ashtavarga.getCount(ashtavargaName);
        if (n != -1) {
            this.chartName = this.chartName + " ( " + String.valueOf(n) + " ) ";
        }
    }

    @Override
    public Table getChartHouseTable(final Rasi rasi) {
        Table table = new Table(){

            public TableData<TableRowData> getTableData() {
                return new TableData<TableRowData>(){

                    @Override
                    public TableRowData getRow(final int n) {
                        return new TableRowData(){

                            @Override
                            public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
                                return n == 1 ? AshtaVargaChartData.this.varga.get((Object)rasi) : null;
                            }
                        };
                    }

                    @Override
                    public int getRowCount() {
                        return 2;
                    }
                };
            }

            @Override
            public ColumnMetaData getColumnMetaData() {
                return AshtaVargaChartData.this.colMetaData;
            }
        };
        return table;
    }

    @Override
    public DefaultColumnMetaData getHouseTableColMetaData() {
        return new DefaultColumnMetaData(new AstrosoftTableColumn[]{AstrosoftTableColumn.C1}){

            @Override
            public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
                return Integer.class;
            }
        };
    }

    public EnumMap<Rasi, Integer> getVarga() {
        return this.varga;
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }
}

