/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.beans.Place;
import app.astrosoft.consts.Sex;
import app.astrosoft.consts.WeekDay;
import app.astrosoft.export.XMLHelper;
import app.astrosoft.util.AstroUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import swisseph.SweDate;

public class BirthData {
    private String personName;
    private Sex sex;
    private Place birthPlace;
    private int birthYear;
    private int birthMonth;
    private int birthDate;
    private int birthHour;
    private int birthMinutes;
    private int birthSeconds;
    private SweDate birthSD;
    private double birthTime;
    private double birthGMT;
    private Calendar birthDay;
    private WeekDay birthWeekDay;

    public BirthData(String string, Sex sex, int n, int n2, int n3, int n4, int n5, int n6, Place place) {
        this.personName = string;
        this.sex = sex;
        this.birthDate = n;
        this.birthMonth = n2;
        this.birthYear = n3;
        this.birthHour = n4;
        this.birthMinutes = n5;
        this.birthSeconds = n6;
        this.birthPlace = place;
        this.birthTime = AstroUtil.decimal(n4, n5, 0);
        this.birthGMT = AstroUtil.decimal(n4, n5, 0) - this.birthPlace.timeZone();
        this.birthSD = new SweDate(n3, n2, n, this.birthGMT);
        this.birthDay = new GregorianCalendar(n3, n2 - 1, n, this.birthHour, this.birthMinutes, this.birthSeconds);
        this.birthWeekDay = WeekDay.ofDay(n3, n2, n);
    }

    public BirthData(String string, int n, int n2, int n3, int n4, int n5, int n6, Place place) {
        this(string, null, n, n2, n3, n4, n5, n6, place);
    }

    public BirthData(String string, Sex sex, Calendar calendar, Place place) {
        this(string, sex, calendar.get(5), calendar.get(2) + 1, calendar.get(1), calendar.get(11), calendar.get(12), calendar.get(13), place);
    }

    public BirthData(String string, Calendar calendar, Place place) {
        this(string, null, calendar, place);
    }

    public String name() {
        return this.personName;
    }

    public int year() {
        return this.birthYear;
    }

    public int month() {
        return this.birthMonth;
    }

    public int date() {
        return this.birthDate;
    }

    public int hour() {
        return this.birthHour;
    }

    public int minutes() {
        return this.birthMinutes;
    }

    public double latitude() {
        return this.birthPlace.latitude();
    }

    public double longitude() {
        return this.birthPlace.longitude();
    }

    public String place() {
        return this.birthPlace.city();
    }

    public double timeZone() {
        return this.birthPlace.timeZone();
    }

    public SweDate birthSD() {
        return this.birthSD;
    }

    public double birthTime() {
        return this.birthTime;
    }

    public double birthGMT() {
        return this.birthGMT;
    }

    public Calendar birthDay() {
        return this.birthDay;
    }

    public WeekDay weekDay() {
        return this.birthWeekDay;
    }

    public Place getBirthPlace() {
        return this.birthPlace;
    }

    public String birthDayString() {
        return AstroUtil.formatDate(this.birthDay.getTime());
    }

    public Sex sex() {
        return this.sex;
    }

    public Element toXMLElement(Document document, String string) {
        Element element = document.createElement(string);
        XMLHelper.addElement(document, element, "Name", this.personName);
        if (this.sex != null) {
            XMLHelper.addElement(document, element, "Sex", this.sex.name());
        }
        XMLHelper.addElement(document, element, "DateTime", AstroUtil.formatDateTime(this.birthDay.getTime()));
        element.appendChild(this.birthPlace.toXMLElement(document));
        return element;
    }

    public Element toXMLElement(Document document) {
        return this.toXMLElement(document, "BirthData");
    }

    public static BirthData valueOfXMLNode(Node node) {
        String string = null;
        Calendar calendar = null;
        Place place = null;
        Sex sex = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("Name")) {
                string = node2.getTextContent();
                continue;
            }
            if (node2.getNodeName().equals("Sex")) {
                sex = Enum.valueOf(Sex.class, node2.getTextContent());
                continue;
            }
            if (node2.getNodeName().equals("DateTime")) {
                calendar = AstroUtil.getCalendar(AstroUtil.parseDateTime(node2.getTextContent()));
                continue;
            }
            if (!node2.getNodeName().equals("Place")) continue;
            place = Place.valueOfXMLNode(node2);
        }
        return new BirthData(string, sex, calendar, place);
    }
}

