/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.beans.Degree;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Roman;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.Mod;

public class HousePosition
implements Exportable {
    private Mod mod = new Mod(360);
    private Bhava[] housePositions = new Bhava[12];
    private double ascendant;
    private double siderealTime;
    private TableData<Bhava> bhavaTableData;
    private DefaultColumnMetaData bhavaTableColumnData;

    public HousePosition(double[] dArray) {
        double d = this.mod.add(dArray[12], this.mod.sub(dArray[1], dArray[12]) / 2.0);
        double d2 = 0.0;
        this.ascendant = dArray[1];
        for (int i = 1; i < dArray.length - 1; ++i) {
            d2 = this.mod.add(dArray[i], this.mod.sub(dArray[i + 1], dArray[i]) / 2.0);
            this.housePositions[i - 1] = new Bhava(i, d, dArray[i], d2);
            d = d2;
        }
        d2 = this.mod.add(dArray[12], this.mod.sub(dArray[1], dArray[12]) / 2.0);
        this.housePositions[11] = new Bhava(12, d, dArray[12], d2);
    }

    public Rasi locateHouse(double d) {
        int n = -1;
        Rasi rasi = Rasi.ofDeg(this.ascendant);
        double d2 = this.housePositions[0].start();
        double d3 = 0.0;
        if (d < d2) {
            d += 360.0;
        }
        for (Bhava bhava : this.housePositions) {
            d3 = d2 + bhava.length();
            if (d <= d3 && d >= d2) {
                n = bhava.bhava() - 1;
                break;
            }
            d2 = d3;
        }
        return rasi.absolute(n);
    }

    public Bhava[] getHousePositions() {
        return this.housePositions;
    }

    public Bhava getBhava(int n) {
        return this.housePositions[n - 1];
    }

    public double getAscendantPosition() {
        return this.ascendant;
    }

    public Rasi getAscendant() {
        return Rasi.ofDeg(this.ascendant);
    }

    public void setSiderealTime(double d) {
        this.siderealTime = d;
    }

    public double getSiderealTime() {
        return this.siderealTime;
    }

    public TableData<Bhava> getBhavaTableData() {
        if (this.bhavaTableData == null) {
            this.bhavaTableData = TableDataFactory.getTableData((TableRowData[])this.housePositions);
        }
        return this.bhavaTableData;
    }

    public ColumnMetaData getBhavaTableColumnData() {
        if (this.bhavaTableColumnData == null) {
            this.bhavaTableColumnData = new DefaultColumnMetaData(new AstrosoftTableColumn[]{AstrosoftTableColumn.House, AstrosoftTableColumn.Bhava, AstrosoftTableColumn.Start, AstrosoftTableColumn.Mid, AstrosoftTableColumn.End, AstrosoftTableColumn.Length}){

                @Override
                public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
                    switch (astrosoftTableColumn) {
                        case Start: 
                        case Mid: 
                        case End: 
                        case Length: {
                            return Degree.class;
                        }
                        case House: {
                            return Roman.class;
                        }
                    }
                    return super.getColumnClass(astrosoftTableColumn);
                }
            };
            this.bhavaTableColumnData.localizeColumns();
        }
        return this.bhavaTableColumnData;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ascendant: " + AstroUtil.dms(this.ascendant) + "\n");
        stringBuilder.append("Sidereal Time: " + AstroUtil.dms(this.siderealTime) + "\n");
        for (Bhava bhava : this.housePositions) {
            stringBuilder.append(bhava + "\n");
        }
        return stringBuilder.toString();
    }

    private boolean verifyLength() {
        double d = 0.0;
        for (Bhava bhava : this.housePositions) {
            d += bhava.length();
        }
        return d == 360.0;
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }

    public class Bhava
    implements TableRowData {
        Rasi house;
        int bhava;
        double start;
        double mid;
        double end;
        double length;

        public Bhava(int n, double d, double d2, double d3) {
            this.bhava = n;
            this.start = d;
            this.mid = d2;
            this.end = d3;
            this.length = HousePosition.this.mod.sub(d3, d);
            this.house = Rasi.ofDeg(d2);
        }

        public int bhava() {
            return this.bhava;
        }

        public Rasi house() {
            return this.house;
        }

        public double start() {
            return this.start;
        }

        public double mid() {
            return this.mid;
        }

        public double end() {
            return this.end;
        }

        public double length() {
            return this.length;
        }

        @Override
        public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
            switch (astrosoftTableColumn) {
                case House: {
                    return Roman.of(this.bhava());
                }
                case Bhava: {
                    return this.house;
                }
                case Start: {
                    return this.start();
                }
                case Mid: {
                    return this.mid();
                }
                case End: {
                    return this.end();
                }
                case Length: {
                    return this.length();
                }
            }
            return null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.bhava + "\t");
            stringBuilder.append(AstroUtil.dms(this.start) + "\t");
            stringBuilder.append(AstroUtil.dms(this.mid) + "\t");
            stringBuilder.append(AstroUtil.dms(this.end) + "\t");
            stringBuilder.append(AstroUtil.dms(this.length) + "\n");
            return stringBuilder.toString();
        }
    }
}

