/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.util.AstroUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import swisseph.SweDate;

public class Interval
implements Comparable {
    private static DateFormat dateFormater = new SimpleDateFormat("EEE dd MMM yyyy ");
    private static DateFormat dateTimeFormatter = new SimpleDateFormat("dd MMM HH:mm:ss z");
    private double start;
    private double end;
    private Interval tLongitude;

    public Interval(double d, double d2) throws IllegalArgumentException {
        if (d > d2) {
            throw new IllegalArgumentException("Start is greater than End");
        }
        this.start = d;
        this.end = d2;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public static Interval intersection(Interval interval, Interval interval2) {
        double d = Math.max(interval.start, interval2.start);
        double d2 = Math.min(interval.end, interval2.end);
        if (d2 > d) {
            return new Interval(d, d2);
        }
        return null;
    }

    public static List<Interval> intersection(List<Interval> list, List<Interval> list2) {
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        for (Interval interval : list) {
            for (Interval interval2 : list2) {
                Interval interval3 = Interval.intersection(interval, interval2);
                if (interval3 == null) continue;
                arrayList.add(interval3);
            }
        }
        return arrayList;
    }

    public static List<Interval> common(List<Interval> list, List<Interval> list2) {
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        for (Interval interval : list) {
            for (Interval interval2 : list2) {
                if (!interval.equals(interval2)) continue;
                arrayList.add(interval);
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.toString(DisplayFormat.DEG);
    }

    public String toString(DisplayFormat displayFormat) {
        if (!DisplayFormat.intervalFormats().contains((Object)displayFormat)) {
            throw new IllegalArgumentException("Invalid Interval Display Format");
        }
        String string = "";
        switch (displayFormat) {
            case DEG: {
                string = AstroUtil.dms(this.start) + " - " + AstroUtil.dms(this.end);
                break;
            }
            case DATE: {
                string = dateFormater.format(SweDate.getDate((double)this.start)) + " - " + dateFormater.format(SweDate.getDate((double)this.end));
                break;
            }
            case DATE_TIME: {
                string = dateTimeFormatter.format(SweDate.getDate((double)this.start)) + " - " + dateTimeFormatter.format(SweDate.getDate((double)this.end));
            }
        }
        return string;
    }

    public static Calendar parseDate(String string, DisplayFormat displayFormat) throws ParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        switch (displayFormat) {
            case DATE: {
                gregorianCalendar.setTime(dateFormater.parse(string));
                return gregorianCalendar;
            }
            case DATE_TIME: {
                gregorianCalendar.setTime(dateTimeFormatter.parse(string));
                return gregorianCalendar;
            }
        }
        throw new IllegalArgumentException("Invalid formatter " + (Object)((Object)displayFormat));
    }

    public boolean equals(Object object) {
        Interval interval = (Interval)object;
        return this.start == interval.start && this.end == interval.end;
    }

    public int compareTo(Object object) {
        Interval interval = (Interval)object;
        if (this.start < interval.start) {
            return -1;
        }
        if (this.start > interval.start) {
            return 1;
        }
        return 0;
    }
}

