/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.beans.Interval;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.MuhurthaRank;
import app.astrosoft.consts.Nakshathra;
import app.astrosoft.consts.Rasi;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.TableRowData;
import java.util.Comparator;

public class MuhurthaBean
implements TableRowData {
    private Interval period;
    private Interval longitude;
    private MuhurthaRank rank;
    private Nakshathra nak;
    private Rasi rasi;
    private static ColumnMetaData columnMetaData = new DefaultColumnMetaData(){
        {
            super.setSortableColumns(AstrosoftTableColumn.Period, AstrosoftTableColumn.Rank);
            super.setHiddenColumnCount(2);
            super.localizeColumns(AstrosoftTableColumn.Period, AstrosoftTableColumn.Nakshathra, AstrosoftTableColumn.Rasi, AstrosoftTableColumn.Rank);
        }

        @Override
        public Comparator<TableRowData> getColumnComparator(AstrosoftTableColumn astrosoftTableColumn) {
            return MuhurthaBean.getComparator(astrosoftTableColumn);
        }
    };

    public MuhurthaBean(Interval interval, Interval interval2, MuhurthaRank muhurthaRank) {
        this.period = interval;
        this.longitude = interval2;
        this.rank = muhurthaRank;
        this.nak = Nakshathra.ofDeg(interval2.getStart());
        this.rasi = Rasi.ofDeg(interval2.getStart());
    }

    public Interval getPeriod() {
        return this.period;
    }

    public Interval getLongitude() {
        return this.longitude;
    }

    public MuhurthaRank getRank() {
        return this.rank;
    }

    public Nakshathra getNakshathra() {
        return this.nak;
    }

    public Rasi getRasi() {
        return this.rasi;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.period.toString(DisplayFormat.DATE_TIME) + " -> " + this.longitude.toString(DisplayFormat.DEG));
        stringBuffer.append(" -> ");
        stringBuffer.append("[ " + (Object)((Object)this.rasi) + " , ");
        stringBuffer.append((Object)((Object)this.nak) + " ] ");
        stringBuffer.append((Object)((Object)this.rank) + "\n");
        return stringBuffer.toString();
    }

    public static Comparator<TableRowData> getComparator(final AstrosoftTableColumn astrosoftTableColumn) {
        Comparator<TableRowData> comparator = new Comparator<TableRowData>(){
            Comparable c1 = null;
            Comparable c2 = null;

            @Override
            public int compare(TableRowData tableRowData, TableRowData tableRowData2) {
                switch (astrosoftTableColumn) {
                    case Period: {
                        this.c1 = ((MuhurthaBean)tableRowData).period;
                        this.c2 = ((MuhurthaBean)tableRowData2).period;
                        break;
                    }
                    case Rank: {
                        this.c1 = ((MuhurthaBean)tableRowData).rank;
                        this.c2 = ((MuhurthaBean)tableRowData2).rank;
                    }
                }
                return this.c1.compareTo(this.c2);
            }
        };
        return comparator;
    }

    @Override
    public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
        switch (astrosoftTableColumn) {
            case Period: {
                return this.getPeriod().toString(DisplayFormat.DATE);
            }
            case Longitude: {
                return this.getLongitude().toString(DisplayFormat.DEG);
            }
            case Rank: {
                return this.getRank();
            }
            case Nakshathra: {
                return this.getNakshathra();
            }
            case Rasi: {
                return this.getRasi();
            }
            case PeriodPopup: {
                return this.getPeriod().toString(DisplayFormat.DATE_TIME);
            }
        }
        return null;
    }

    public static ColumnMetaData getColumnMetaData() {
        return columnMetaData;
    }
}

