/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.export.XMLHelper;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.AstrosoftTimeZone;
import java.util.EnumSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Place {
    private String city;
    private String state;
    private String country;
    private double longitude;
    private double latitude;
    private double timeZone;
    private String timeZoneId;

    public Place(String string, String string2, String string3, double d, double d2, double d3) {
        this.state = string2;
        this.country = string3;
        this.city = string;
        this.longitude = d2;
        this.latitude = d;
        this.timeZone = d3;
    }

    public Place(String string, String string2, String string3, double d, double d2, String string4) {
        this(string, string2, string3, d, d2, AstrosoftTimeZone.offset(string4));
        this.timeZoneId = string4;
    }

    public Place(String string, String string2, String string3, double d, Direction direction, double d2, Direction direction2, double d3) {
        this(string, string2, string3, d * (double)direction.val, d2 * (double)direction2.val, d3);
    }

    public Place(String string, String string2, String string3, String string4, char c, String string5, char c2, String string6) {
        this(string, string2, string3, AstroUtil.toDouble(string4, "\\."), Direction.ofChar(c), AstroUtil.toDouble(string5, "\\."), Direction.ofChar(c2), AstrosoftTimeZone.offset(string6));
        this.timeZoneId = string6;
    }

    public Place(String string, double d, double d2, double d3) {
        this(string, null, null, d, d2, d3);
    }

    public Place(String string, String string2, String string3, Location location, Location location2, String string4) {
        this(string, string2, string3, location.value(), location2.value(), AstrosoftTimeZone.offset(string4));
        this.timeZoneId = string4;
    }

    public static Place getDefault() {
        return new Place("Erode", "Tamil Nadu", "India", new Location(11, 22, Direction.NORTH), new Location(77, 44, Direction.EAST), "IST");
    }

    public String city() {
        return this.city;
    }

    public String state() {
        return this.state;
    }

    public String country() {
        return this.country;
    }

    public String display() {
        return String.format("[%s , %s , %s, %s, %s, %s]", this.city, this.state, this.country, this.longitude, this.latitude, this.timeZone);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.city);
        if (this.state != null) {
            stringBuilder.append(" , ");
            stringBuilder.append(this.state);
        }
        if (this.country != null) {
            stringBuilder.append(" , ");
            stringBuilder.append(this.country);
        }
        return stringBuilder.toString();
    }

    public double longitude() {
        return this.longitude;
    }

    public double latitude() {
        return this.latitude;
    }

    public double timeZone() {
        return this.timeZone;
    }

    public void setTimeZone(double d) {
        this.timeZone = d;
    }

    public AstrosoftTimeZone astrosoftTimeZone() {
        return new AstrosoftTimeZone(this.timeZoneId);
    }

    public Location latitudeLocation() {
        return new Location(this.latitude, LocationType.Latitude);
    }

    public Location longitudeLocation() {
        return new Location(this.longitude, LocationType.Longitude);
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement("Place");
        Location location = this.longitudeLocation();
        Location location2 = this.latitudeLocation();
        XMLHelper.addElement(document, element, "City", this.city);
        Element element2 = XMLHelper.addElement(document, element, "Longitude", location.format());
        XMLHelper.addAttribute(element2, "dir", Character.valueOf(location.dir().charVal()));
        Element element3 = XMLHelper.addElement(document, element, "Latitude", location2.format());
        XMLHelper.addAttribute(element3, "dir", Character.valueOf(location2.dir().charVal()));
        XMLHelper.addElement(document, element, "TimeZone", this.timeZoneId != null ? this.timeZoneId : "IST");
        return element;
    }

    public static void main(String[] stringArray) {
        System.out.println(Place.getDefault());
    }

    public static Place valueOfXMLNode(Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        char c = ' ';
        char c2 = ' ';
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("City")) {
                string = node2.getTextContent();
                continue;
            }
            if (node2.getNodeName().equals("State")) {
                string2 = node2.getTextContent();
                continue;
            }
            if (node2.getNodeName().equals("Country")) {
                string3 = node2.getTextContent();
                continue;
            }
            if (node2.getNodeName().equals("Longitude")) {
                string4 = node2.getTextContent();
                c2 = node2.getAttributes().getNamedItem("dir").getNodeValue().charAt(0);
                continue;
            }
            if (node2.getNodeName().equals("Latitude")) {
                string5 = node2.getTextContent();
                c = node2.getAttributes().getNamedItem("dir").getNodeValue().charAt(0);
                continue;
            }
            if (!node2.getNodeName().equals("TimeZone")) continue;
            string6 = node2.getTextContent();
        }
        return new Place(string, string2, string3, string5, c, string4, c2, string6);
    }

    public static class Location {
        private int deg;
        private int min;
        Direction dir;

        public Location(int n, int n2, Direction direction) {
            this.deg = n;
            this.min = n2;
            this.dir = direction;
        }

        public Location(String string, String string2, Direction direction) {
            this(Integer.parseInt(string), Integer.parseInt(string2), direction);
        }

        public Location(double d, LocationType locationType) {
            int[] nArray = AstroUtil.int_dms(d);
            this.deg = Math.abs(nArray[0]);
            this.min = Math.abs(nArray[1]);
            this.dir = Direction.ofVal(d, locationType);
        }

        public double value() {
            return AstroUtil.decimal(this.deg, this.min, 0) * (double)this.dir.val;
        }

        public int deg() {
            return this.deg;
        }

        public int min() {
            return this.min;
        }

        public Direction dir() {
            return this.dir;
        }

        public String toString() {
            return this.deg + "." + this.min + (Object)((Object)this.dir);
        }

        public String format() {
            return AstroUtil.twoDigit(this.deg) + "." + AstroUtil.twoDigit(this.min);
        }
    }

    public static enum Direction {
        EAST(1),
        WEST(-1),
        NORTH(1),
        SOUTH(-1);

        private int val = 1;

        private Direction(int n2) {
            this.val = n2;
        }

        public static Direction ofChar(char c) {
            for (Direction direction : Direction.values()) {
                if (direction.charVal() != Character.toUpperCase(c)) continue;
                return direction;
            }
            return null;
        }

        public char charVal() {
            return this.name().charAt(0);
        }

        public static EnumSet NS() {
            return EnumSet.of(NORTH, SOUTH);
        }

        public static EnumSet EW() {
            return EnumSet.of(EAST, WEST);
        }

        public static Direction ofVal(double d, LocationType locationType) {
            switch (locationType) {
                case Latitude: {
                    return d < 0.0 ? SOUTH : NORTH;
                }
                case Longitude: {
                    return d < 0.0 ? WEST : EAST;
                }
            }
            return null;
        }
    }

    public static enum LocationType {
        Longitude,
        Latitude;

    }
}

