/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.consts.Planet;
import java.util.Map;
import java.util.Set;

public class PlanetCharacter {
    private Map<Planet, Boolean> planetCharacter;

    public PlanetCharacter(Map<Planet, Boolean> map) {
        this.planetCharacter = map;
    }

    public boolean isBenefic(Planet planet) {
        if (this.planetCharacter.containsKey((Object)planet)) {
            return this.planetCharacter.get((Object)planet);
        }
        if (planet.isAsc()) {
            return true;
        }
        throw new IllegalArgumentException("isBenefic() is not applicable for " + planet.name());
    }

    public boolean isMalefic(Planet planet) {
        if (this.planetCharacter.containsKey((Object)planet)) {
            return this.planetCharacter.get((Object)planet) == false;
        }
        if (planet.isAsc()) {
            return true;
        }
        throw new IllegalArgumentException("isMalefic() is not applicable for " + planet.name());
    }

    public boolean isAllBenefics(Set<Planet> set) {
        if (set.isEmpty()) {
            return false;
        }
        for (Planet planet : set) {
            if (this.isBenefic(planet)) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyBenefics(Set<Planet> set) {
        if (set.isEmpty()) {
            return false;
        }
        for (Planet planet : set) {
            if (!this.isBenefic(planet)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllMalefics(Set<Planet> set) {
        if (set.isEmpty()) {
            return false;
        }
        for (Planet planet : set) {
            if (this.isMalefic(planet)) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyMalefics(Set<Planet> set) {
        if (set.isEmpty()) {
            return false;
        }
        for (Planet planet : set) {
            if (!this.isMalefic(planet)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.planetCharacter.toString();
    }
}

