/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.beans.AbstractChartData;
import app.astrosoft.beans.Place;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.Horoscope;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.ui.table.Cell;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class PlanetChartData
extends AbstractChartData
implements Exportable {
    private static final Logger log = Logger.getLogger(PlanetChartData.class.getName());
    private EnumMap<Planet, Boolean> planetDir;
    private EnumMap<Rasi, List<Planet>> planetsInRasi;
    private Varga varga;

    public PlanetChartData(Varga varga, PlanetaryInfo planetaryInfo) {
        this(varga, planetaryInfo.getDivChart(varga), planetaryInfo.getPlanetDirection());
    }

    public PlanetChartData(Varga varga, EnumMap<Planet, Integer> enumMap, EnumMap<Planet, Boolean> enumMap2) {
        super(varga.toString());
        this.varga = varga;
        this.planetDir = enumMap2;
        this.ascendant = Rasi.ofIndex(enumMap.get((Object)Planet.Ascendant) - 1);
        this.planetsInRasi = PlanetChartData.calcPlanetsInRasi(enumMap);
    }

    public static EnumMap<Rasi, List<Planet>> calcPlanetsInRasi(EnumMap<Planet, Integer> enumMap) {
        EnumMap<Rasi, List<Planet>> enumMap2 = new EnumMap<Rasi, List<Planet>>(Rasi.class);
        List<Object> list = null;
        for (Planet planet : Planet.planetsAsc()) {
            Rasi rasi = Rasi.ofIndex(enumMap.get((Object)planet) - 1);
            if (enumMap2.containsKey((Object)rasi)) {
                list = enumMap2.get((Object)rasi);
                list.add((Object)planet);
                continue;
            }
            list = new ArrayList();
            list.add((Object)planet);
            enumMap2.put(rasi, list);
        }
        return enumMap2;
    }

    @Override
    public Set<Rasi> getHouses() {
        return this.planetsInRasi.keySet();
    }

    public Map<Cell, Planet> getCells(List<Planet> list) {
        HashMap<Cell, Planet> hashMap = new HashMap<Cell, Planet>();
        if (list == null || list.size() == 0) {
            return hashMap;
        }
        switch (list.size()) {
            case 1: {
                hashMap.put(new Cell(1, AstrosoftTableColumn.C2), list.get(0));
                break;
            }
            case 2: {
                hashMap.put(new Cell(0, AstrosoftTableColumn.C1), list.get(0));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C3), list.get(1));
                break;
            }
            case 3: {
                hashMap.put(new Cell(0, AstrosoftTableColumn.C2), list.get(0));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C1), list.get(1));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C3), list.get(2));
                break;
            }
            case 4: {
                hashMap.put(new Cell(0, AstrosoftTableColumn.C1), list.get(0));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C3), list.get(1));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C1), list.get(2));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C3), list.get(3));
                break;
            }
            case 5: {
                hashMap.put(new Cell(0, AstrosoftTableColumn.C1), list.get(0));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C3), list.get(1));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C1), list.get(2));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C3), list.get(3));
                hashMap.put(new Cell(1, AstrosoftTableColumn.C2), list.get(4));
                break;
            }
            case 6: {
                hashMap.put(new Cell(0, AstrosoftTableColumn.C1), list.get(0));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C3), list.get(1));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C1), list.get(2));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C3), list.get(3));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C2), list.get(4));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C2), list.get(5));
                break;
            }
            case 7: {
                hashMap.put(new Cell(0, AstrosoftTableColumn.C1), list.get(0));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C3), list.get(1));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C1), list.get(2));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C3), list.get(3));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C2), list.get(4));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C2), list.get(5));
                hashMap.put(new Cell(1, AstrosoftTableColumn.C2), list.get(6));
                break;
            }
            case 8: {
                hashMap.put(new Cell(0, AstrosoftTableColumn.C1), list.get(0));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C3), list.get(1));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C1), list.get(2));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C3), list.get(3));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C2), list.get(4));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C2), list.get(5));
                hashMap.put(new Cell(1, AstrosoftTableColumn.C1), list.get(6));
                hashMap.put(new Cell(1, AstrosoftTableColumn.C3), list.get(7));
                break;
            }
            default: {
                hashMap.put(new Cell(0, AstrosoftTableColumn.C1), list.get(0));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C3), list.get(1));
                hashMap.put(new Cell(0, AstrosoftTableColumn.C2), list.get(4));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C1), list.get(2));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C3), list.get(3));
                hashMap.put(new Cell(2, AstrosoftTableColumn.C2), list.get(5));
                hashMap.put(new Cell(1, AstrosoftTableColumn.C1), list.get(6));
                hashMap.put(new Cell(1, AstrosoftTableColumn.C2), list.get(7));
                hashMap.put(new Cell(1, AstrosoftTableColumn.C3), list.get(8));
            }
        }
        return hashMap;
    }

    @Override
    public Table getChartHouseTable(Rasi rasi) {
        return new ChartHouseTable(rasi);
    }

    public EnumMap<Rasi, List<Planet>> getPlanetsInRasi() {
        return this.planetsInRasi;
    }

    @Override
    public DefaultColumnMetaData getHouseTableColMetaData() {
        return new DefaultColumnMetaData(AstrosoftTableColumn.chartHouseCols()){

            @Override
            public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
                return Planet.class;
            }
        };
    }

    public boolean highlightRetrogrades() {
        return this.varga == Varga.Rasi || this.varga == Varga.Navamsa || this.varga == Varga.Bhava;
    }

    public EnumMap<Planet, Boolean> getPlanetDir() {
        return this.planetDir;
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }

    public static void main(String[] stringArray) {
        Horoscope horoscope = new Horoscope("Raja", 11, 12, 1980, 1, 44, Place.getDefault());
        EnumMap<Planet, Integer> enumMap = new EnumMap<Planet, Integer>(Planet.class);
        enumMap.put(Planet.Sun, 1);
        enumMap.put(Planet.Moon, 1);
        enumMap.put(Planet.Mars, 1);
        enumMap.put(Planet.Mercury, 1);
        enumMap.put(Planet.Jupiter, 1);
        enumMap.put(Planet.Venus, 1);
        enumMap.put(Planet.Saturn, 1);
        enumMap.put(Planet.Rahu, 1);
        enumMap.put(Planet.Ketu, 1);
        enumMap.put(Planet.Ascendant, 1);
        PlanetChartData planetChartData = new PlanetChartData(Varga.Rasi, horoscope.getPlanetaryInfo());
    }

    private class ChartHouseRow
    implements TableRowData {
        private Map<Cell, Planet> cells;
        private int row;

        public ChartHouseRow(int n, Map<Cell, Planet> map) {
            this.cells = map;
            this.row = n;
        }

        @Override
        public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
            Planet planet = null;
            Cell cell = new Cell(this.row, astrosoftTableColumn);
            if (this.cells.containsKey(cell)) {
                planet = this.cells.get(cell);
            }
            return planet;
        }
    }

    private class ChartHouseData
    implements TableData<ChartHouseRow> {
        private Map<Cell, Planet> cells;

        public ChartHouseData(Map<Cell, Planet> map) {
            this.cells = map;
        }

        @Override
        public ChartHouseRow getRow(int n) {
            return new ChartHouseRow(n, this.cells);
        }

        @Override
        public int getRowCount() {
            return 3;
        }
    }

    private class ChartHouseTable
    implements Table {
        private Map<Cell, Planet> cells;

        public ChartHouseTable(Rasi rasi) {
            List list = (List)PlanetChartData.this.planetsInRasi.get((Object)rasi);
            this.cells = PlanetChartData.this.getCells(list);
        }

        public TableData<ChartHouseRow> getTableData() {
            return new ChartHouseData(this.cells);
        }

        @Override
        public ColumnMetaData getColumnMetaData() {
            return PlanetChartData.this.colMetaData;
        }
    }
}

