/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.beans;

import app.astrosoft.beans.Degree;
import app.astrosoft.beans.HousePosition;
import app.astrosoft.beans.NakshathraPada;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Karaka;
import app.astrosoft.consts.Paksha;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.VargaCharts;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.ComparableEntry;
import app.astrosoft.util.Mod;
import app.astrosoft.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class PlanetaryInfo
implements Exportable {
    private static final Logger log = Logger.getLogger(PlanetaryInfo.class.getName());
    private EnumMap<Planet, Double> planetPosition;
    private EnumMap<Planet, Double> planetRasiPosition;
    private EnumMap<Planet, Boolean> planetDirection;
    private EnumMap<Planet, Rasi> planetRasi;
    private EnumMap<Planet, Integer> planetLocation;
    private EnumMap<Planet, HousePosition.Bhava> planetBhava;
    private EnumMap<Planet, NakshathraPada> planetNakshathra;
    private EnumMap<Planet, Karaka> planetKaraka;
    private EnumMap<Varga, EnumMap<Planet, Integer>> divChart;
    private Map<Planet, Boolean> planetCharacter;
    private TableData<PlanetaryInfoRow> planateryInfoTableData;
    private DefaultColumnMetaData planateryInfoColumnMetaData;
    private Mod mod = new Mod(12);

    public PlanetaryInfo(EnumMap<Planet, Double> enumMap, EnumMap<Planet, Boolean> enumMap2, HousePosition housePosition) {
        this.planetPosition = enumMap;
        this.planetDirection = enumMap2;
        enumMap.put(Planet.Ascendant, housePosition.getAscendantPosition());
        VargaCharts vargaCharts = new VargaCharts(enumMap, housePosition);
        this.divChart = vargaCharts.getAllCharts();
        this.planetRasi = new EnumMap(Planet.class);
        this.planetNakshathra = new EnumMap(Planet.class);
        this.planetBhava = new EnumMap(Planet.class);
        this.planetLocation = new EnumMap(Planet.class);
        this.planetRasiPosition = new EnumMap(Planet.class);
        this.planetKaraka = new EnumMap(Planet.class);
        List list = new ArrayList();
        int n = housePosition.getAscendant().ordinal() + 1;
        for (Planet object : Planet.planetsAsc()) {
            this.planetRasi.put(object, Rasi.ofIndex(this.divChart.get((Object)Varga.Rasi).get((Object)object) - 1));
            this.planetNakshathra.put(object, new NakshathraPada(enumMap.get((Object)object)));
            this.planetLocation.put(object, this.mod.sub(this.divChart.get((Object)Varga.Rasi).get((Object)object), n) + 1);
            this.planetBhava.put(object, housePosition.getBhava(this.mod.sub(this.divChart.get((Object)Varga.Bhava).get((Object)object), n) + 1));
            this.planetRasiPosition.put(object, enumMap.get((Object)object) % 30.0);
            if (object.isNode() || object.isAsc()) continue;
            list.add(new ComparableEntry<Planet, Comparable>(object, this.planetRasiPosition.get((Object)object)));
        }
        list = Utils.sortEntryList(list, true);
        int n2 = 0;
        for (ComparableEntry comparableEntry : list) {
            this.planetKaraka.put((Planet)((Enum)comparableEntry.getKey()), Karaka.ofIndex(n2++));
        }
        this.calcPlanetCharacter();
    }

    public EnumMap<Planet, Double> getPlanetPosition() {
        return this.planetPosition;
    }

    public EnumMap<Planet, Boolean> getPlanetDirection() {
        return this.planetDirection;
    }

    public EnumMap<Planet, Rasi> getPlanetRasi() {
        return this.planetRasi;
    }

    public EnumMap<Planet, Rasi> getPlanetRasi(Varga varga) {
        if (varga.equals((Object)Varga.Rasi)) {
            return this.planetRasi;
        }
        EnumMap<Planet, Rasi> enumMap = new EnumMap<Planet, Rasi>(Planet.class);
        for (Planet planet : Planet.planetsAsc()) {
            this.planetRasi.put(planet, Rasi.ofIndex(this.divChart.get((Object)varga).get((Object)planet) - 1));
        }
        return enumMap;
    }

    public EnumMap<Planet, Integer> getPlanetLocation() {
        return this.planetLocation;
    }

    public EnumMap<Planet, Integer> getPlanetLocation(Varga varga) {
        if (varga.equals((Object)Varga.Rasi)) {
            return this.planetLocation;
        }
        int n = this.divChart.get((Object)varga).get((Object)Planet.Ascendant);
        log.fine("Lagna " + n);
        EnumMap<Planet, Integer> enumMap = new EnumMap<Planet, Integer>(Planet.class);
        for (Planet planet : Planet.planetsAsc()) {
            enumMap.put(planet, this.mod.sub(this.divChart.get((Object)varga).get((Object)planet), n) + 1);
        }
        return enumMap;
    }

    public EnumMap<Planet, HousePosition.Bhava> getPlanetBhava() {
        return this.planetBhava;
    }

    public void setPlanetNakshathra(EnumMap<Planet, NakshathraPada> enumMap) {
        this.planetNakshathra = enumMap;
    }

    public EnumMap<Planet, NakshathraPada> getPlanetNakshathra() {
        return this.planetNakshathra;
    }

    public EnumMap<Planet, Karaka> getPlanetKaraka() {
        return this.planetKaraka;
    }

    public static EnumMap<Planet, Integer> positionToRasiNum(EnumMap<Planet, Double> enumMap) {
        EnumMap<Planet, Integer> enumMap2 = new EnumMap<Planet, Integer>(Planet.class);
        for (Map.Entry<Planet, Double> entry : enumMap.entrySet()) {
            enumMap2.put((Planet)((Enum)entry.getKey()), (int)(entry.getValue() / 30.0) + 1);
        }
        return enumMap2;
    }

    private void calcPlanetCharacter() {
        this.planetCharacter = new EnumMap<Planet, Boolean>(Planet.class);
        for (Planet planet : Planet.subaPlanets()) {
            this.planetCharacter.put(planet, true);
        }
        for (Planet planet : Planet.papaPlanets()) {
            this.planetCharacter.put(planet, false);
        }
        Paksha paksha = Paksha.ofDeg(this.getPlanetPosition(Planet.Sun), this.getPlanetPosition(Planet.Moon));
        this.planetCharacter.put(Planet.Moon, paksha.isShukla());
    }

    public Double getPlanetPosition(Planet planet) {
        return this.planetPosition.get((Object)planet);
    }

    public EnumMap<Planet, Double> getPlanetRasiPosition() {
        return this.planetRasiPosition;
    }

    public Double getPlanetRasiPosition(Planet planet) {
        return this.planetRasiPosition.get((Object)planet);
    }

    public EnumMap<Varga, EnumMap<Planet, Integer>> getDivChart() {
        return this.divChart;
    }

    public EnumMap<Planet, Integer> getDivChart(Varga varga) {
        return this.divChart.get((Object)varga);
    }

    public Map<Planet, Boolean> getPlanetCharacter() {
        return this.planetCharacter;
    }

    public TableData<PlanetaryInfoRow> getPlanateryInfoTableData() {
        if (this.planateryInfoTableData == null) {
            this.planateryInfoTableData = new PlanetaryInfoData();
        }
        return this.planateryInfoTableData;
    }

    public DefaultColumnMetaData getPlanateryInfoColumnMetaData() {
        if (this.planateryInfoColumnMetaData == null) {
            this.planateryInfoColumnMetaData = new DefaultColumnMetaData(new AstrosoftTableColumn[]{AstrosoftTableColumn.Planet, AstrosoftTableColumn.Longitude, AstrosoftTableColumn.Rasi, AstrosoftTableColumn.NakshathraPada, AstrosoftTableColumn.JaiminiKaraka}){

                @Override
                public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
                    switch (astrosoftTableColumn) {
                        case Longitude: {
                            return Degree.class;
                        }
                    }
                    return super.getColumnClass(astrosoftTableColumn);
                }
            };
            this.planateryInfoColumnMetaData.localizeColumns();
        }
        return this.planateryInfoColumnMetaData;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Planet planet : Planet.planetsAsc()) {
            stringBuilder.append((Object)((Object)planet) + "\t" + AstroUtil.dms(this.planetPosition.get((Object)planet)) + "\t" + this.planetRasiPosition.get((Object)planet) + "\t");
            if (this.planetKaraka.containsKey((Object)planet)) {
                stringBuilder.append((Object)this.planetKaraka.get((Object)planet));
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("Charts\n" + VargaCharts.toString(this.divChart));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }

    private class PlanetaryInfoData
    implements TableData<PlanetaryInfoRow> {
        private PlanetaryInfoData() {
        }

        @Override
        public PlanetaryInfoRow getRow(int n) {
            return new PlanetaryInfoRow(Planet.values()[n]);
        }

        @Override
        public int getRowCount() {
            return 10;
        }
    }

    private class PlanetaryInfoRow
    implements TableRowData {
        Planet row;

        public PlanetaryInfoRow(Planet planet) {
            this.row = planet;
        }

        @Override
        public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
            switch (astrosoftTableColumn) {
                case Planet: {
                    return this.row;
                }
                case Longitude: {
                    return PlanetaryInfo.this.planetPosition.get((Object)this.row);
                }
                case Rasi: {
                    return PlanetaryInfo.this.planetRasi.get((Object)this.row);
                }
                case NakshathraPada: {
                    return PlanetaryInfo.this.planetNakshathra.get((Object)this.row);
                }
                case JaiminiKaraka: {
                    return PlanetaryInfo.this.planetKaraka.get((Object)this.row);
                }
            }
            return null;
        }
    }
}

