/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.consts;

import app.astrosoft.consts.Language;
import app.astrosoft.consts.Planet;
import app.astrosoft.util.Internalization;
import java.util.EnumSet;

public enum AshtavargaName {
    Sun,
    Moon,
    Mars,
    Mercury,
    Jupiter,
    Venus,
    Saturn,
    SarvaAshtavarga,
    AshtaVarga,
    Trikona,
    Ekathipathya;


    public static EnumSet<AshtavargaName> ashtavargas() {
        return EnumSet.range(Sun, SarvaAshtavarga);
    }

    public static AshtavargaName ofPlanet(Planet planet) {
        return AshtavargaName.valueOf(planet.name());
    }

    public String toString(Language language) {
        return Internalization.getString(language, this.name());
    }

    public String toString() {
        return Internalization.getString(this.name());
    }
}

