/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.consts;

import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.ui.view.ViewManager;
import java.util.EnumSet;
import javax.swing.KeyStroke;

public enum Command {
    NEW("New", 78, KeyStroke.getKeyStroke(78, 2)),
    OPEN("Open", 79, KeyStroke.getKeyStroke(79, 2)),
    OPEN_COMPACTIBILITY("Open Compactibility", KeyStroke.getKeyStroke(79, 3)),
    SAVE("Save", 83, KeyStroke.getKeyStroke(83, 2)),
    SAVE_COMPACTIBILITY("Save Compactibility", 67, KeyStroke.getKeyStroke(83, 3)),
    PRINT("Print", 80, KeyStroke.getKeyStroke(80, 2)),
    EXIT("Exit", 88, KeyStroke.getKeyStroke(88, 2)),
    EDIT_CHART("Chart Data", 67),
    EDIT_COMPACTIBILITY("Compactibility", 77),
    CHART_VIEW(ViewManager.View.CHART_VIEW.displayVal(), 67),
    DASAS_VIEW(ViewManager.View.DASAS_VIEW.displayVal(), 68),
    PLANET_POS_VIEW(ViewManager.View.PLANET_POS_VIEW.displayVal(), 80),
    BHAVA_POS_VIEW(ViewManager.View.BHAVA_POS_VIEW.displayVal(), 66),
    DIV_CHART_VIEW(ViewManager.View.DIV_CHART_VIEW.displayVal(), 73),
    ASHTAVARGA_VIEW(ViewManager.View.ASHTAVARGA_VIEW.displayVal(), 65),
    SHADBALA_VIEW(ViewManager.View.SHADBALA_VIEW.displayVal(), 83),
    YOGA_COMBINATIONS_VIEW(ViewManager.View.YOGA_COMBINATIONS_VIEW.displayVal(), 89),
    EPHEMERIS_VIEW(ViewManager.View.EPHEMERIS_VIEW.displayVal(), 69),
    PANCHANG_VIEW(ViewManager.View.PANCHANG_VIEW.displayVal(), 71),
    COMPACTIBILITY_VIEW(ViewManager.View.COMPACTIBILITY_VIEW.displayVal(), 77),
    MUHURTHA_VIEW(ViewManager.View.MUHURTHA_VIEW.displayVal()),
    AY_LAH(Ayanamsa.LAHARI.ayaName()),
    AY_RAM(Ayanamsa.RAMAN.ayaName()),
    AY_KM(Ayanamsa.KRISHNAMURTHI.ayaName()),
    LANG_EN(Language.ENGLISH.name()),
    LANG_TA(Language.TAMIL.name()),
    Place(DisplayStrings.DEF_LOC_STR),
    EphCalcTime(DisplayStrings.EPH_TIME_STR),
    PanCalcTime(DisplayStrings.PAN_TIME_STR),
    FIND_NAME_VIEW(ViewManager.View.FIND_NAME_VIEW.displayVal()),
    COMPUTE_NUMBER(DisplayStrings.COMPUTE_NUMBER_STR),
    EXPORT_NAME_DB(DisplayStrings.EXPORT_NAME_DB_STR),
    IMPORT_NAME_DB(DisplayStrings.IMPORT_NAME_DB_STR),
    IMPORT_NAME(DisplayStrings.IMPORT_NAME_STR),
    EXPORT_HOROSCOPE_TO_PDF(DisplayStrings.EXPORT_HOROSCOPE_TO_PDF_STR),
    EXPORT_COMPACTIBILITY_TO_PDF(DisplayStrings.EXPORT_COMPACTIBILITY_TO_PDF_STR);

    private String action;
    private int mnemonic = -1;
    private KeyStroke key = null;

    private Command(Enum enum_) {
        this(enum_.toString());
    }

    private Command(String string2) {
        this.action = string2;
    }

    private Command(String string2, int n2) {
        this.action = string2;
        this.mnemonic = n2;
    }

    private Command(String string2, int n2, KeyStroke keyStroke) {
        this.action = string2;
        this.mnemonic = n2;
        this.key = keyStroke;
    }

    private Command(String string2, KeyStroke keyStroke) {
        this.action = string2;
        this.key = keyStroke;
    }

    public String action() {
        return this.action;
    }

    public int mnemonic() {
        return this.mnemonic;
    }

    public KeyStroke key() {
        return this.key;
    }

    public static EnumSet<Command> ayanamsaOptions() {
        return EnumSet.range(AY_LAH, AY_KM);
    }

    public static EnumSet<Command> langOptions() {
        return EnumSet.range(LANG_EN, LANG_TA);
    }

    public static EnumSet<Command> fileMenuItems() {
        return EnumSet.range(NEW, EXIT);
    }

    public static EnumSet<Command> editMenuItems() {
        return EnumSet.range(EDIT_CHART, EDIT_COMPACTIBILITY);
    }

    public static EnumSet<Command> viewMenuItems() {
        return EnumSet.range(CHART_VIEW, PANCHANG_VIEW);
    }

    public static EnumSet<Command> computeMenuItems() {
        return EnumSet.range(COMPACTIBILITY_VIEW, MUHURTHA_VIEW);
    }

    public static EnumSet<Command> optionMenuItems() {
        return EnumSet.range(Place, PanCalcTime);
    }

    public static EnumSet<Command> numeroMenuItems() {
        return EnumSet.range(FIND_NAME_VIEW, IMPORT_NAME);
    }

    public static EnumSet<Command> exportMenuItems() {
        return EnumSet.range(EXPORT_HOROSCOPE_TO_PDF, EXPORT_COMPACTIBILITY_TO_PDF);
    }

    public static EnumSet<Command> toolBarItems() {
        return EnumSet.of(NEW, new Command[]{OPEN, SAVE, PRINT, DIV_CHART_VIEW, PLANET_POS_VIEW, BHAVA_POS_VIEW, DASAS_VIEW, CHART_VIEW, ASHTAVARGA_VIEW, SHADBALA_VIEW, EPHEMERIS_VIEW, PANCHANG_VIEW, COMPACTIBILITY_VIEW});
    }
}

