/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.consts;

import app.astrosoft.util.Internalization;
import app.astrosoft.util.Mod;

public enum Karana {
    Bava,
    Balava,
    Kaulava,
    Taitula,
    Garija,
    Vanija,
    Visti,
    Sakuna,
    Chatushpada,
    Naga,
    Kimstughna;

    private static double CHATHURDASI_SECOND_HALF;
    private static Karana[] vals;

    public static Karana ofIndex(int n) {
        return vals[n % vals.length];
    }

    public static Karana ofDeg(double d) {
        Karana karana = null;
        karana = d > CHATHURDASI_SECOND_HALF && d <= CHATHURDASI_SECOND_HALF + 6.0 ? Sakuna : (d > CHATHURDASI_SECOND_HALF + 6.0 && d <= CHATHURDASI_SECOND_HALF + 12.0 ? Chatushpada : (d > CHATHURDASI_SECOND_HALF + 12.0 && d <= CHATHURDASI_SECOND_HALF + 18.0 ? Naga : (d > 0.0 && d < 6.0 ? Kimstughna : Karana.ofIndex((int)(d - 6.0) / 6 % 7))));
        return karana;
    }

    public static Karana[] ofDeg(double d, double d2) {
        Mod mod = new Mod(360);
        double d3 = mod.sub(d2, d);
        return new Karana[]{Karana.ofDeg(d3), Karana.ofDeg(mod.add(d3, 6.0))};
    }

    public String toString() {
        return Internalization.getString(this.name());
    }

    static {
        CHATHURDASI_SECOND_HALF = 342.0;
        vals = Karana.values();
    }
}

