/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.consts;

import app.astrosoft.beans.Interval;
import app.astrosoft.consts.MuhurthaRank;
import app.astrosoft.consts.Rasi;
import app.astrosoft.util.Internalization;
import java.util.EnumSet;

public enum Nakshathra {
    Ashwini,
    Bharani,
    Krithika,
    Rohini,
    Mrigasira,
    Thiruvaadhirai,
    Punarpoosam,
    Poosam,
    Ayilyam,
    Magam,
    Pooram,
    Uththiram,
    Hastam,
    Chittirai,
    Swathi,
    Vishakham,
    Anusham,
    Kettai,
    Moolam,
    Pooradam,
    Uththiradam,
    Thiruvonam,
    Avittam,
    Shathayam,
    Poorattadhi,
    Uttarattadhi,
    Revathi;

    private static Nakshathra[] vals;

    public static Nakshathra ofIndex(int n) {
        return vals[n % vals.length];
    }

    public static Nakshathra ofDeg(double d) {
        return Nakshathra.ofIndex((int)(d / 13.333333333333334));
    }

    public static Interval degFor(Nakshathra nakshathra) {
        double d = (double)nakshathra.ordinal() * 13.333333333333334;
        double d2 = (double)(nakshathra.ordinal() + 1) * 13.333333333333334;
        Interval interval = new Interval(d, d2);
        return interval;
    }

    public Nakshathra absolute(int n) {
        return Nakshathra.ofIndex(this.ordinal() + n);
    }

    public static EnumSet<Nakshathra> ofRasi(Rasi rasi) {
        int n = rasi.ordinal() / 4 + rasi.ordinal() * 2;
        return EnumSet.range(Nakshathra.ofIndex(n), Nakshathra.ofIndex(n + 2));
    }

    public static EnumSet<Nakshathra> muhurtaNakshathras(MuhurthaRank muhurthaRank) {
        EnumSet<Nakshathra[]> enumSet = null;
        switch (muhurthaRank) {
            case VeryGood: {
                enumSet = EnumSet.of(Ashwini, new Nakshathra[]{Rohini, Mrigasira, Poosam, Uththiram, Hastam, Swathi, Anusham, Uththiradam, Thiruvonam, Uttarattadhi, Revathi});
                break;
            }
            case Good: {
                enumSet = EnumSet.of(Thiruvaadhirai, new Nakshathra[]{Punarpoosam, Magam, Chittirai, Moolam, Avittam, Shathayam});
            }
        }
        return enumSet;
    }

    public String toString() {
        return Internalization.getString(this.name());
    }

    static {
        vals = Nakshathra.values();
    }
}

