/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.consts;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.Rasi;
import app.astrosoft.util.Internalization;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public enum Planet {
    Sun("Su", 0, 6.0, 0),
    Moon("Mo", 1, 10.0, 1),
    Mars("Ma", 4, 7.0, 2),
    Mercury("Me", 2, 17.0, 6),
    Jupiter("Ju", 5, 16.0, 4),
    Venus("Ve", 3, 20.0, 8),
    Saturn("Sa", 6, 19.0, 5),
    Rahu("Ra", 11, 18.0, 3),
    Ketu("Ke", 12, 7.0, 7),
    Ascendant("Asc"),
    Ra_Ke("Ra/Ke"),
    NullPlanet;

    private String sym;
    private int swissPlanetNo;
    private double dasaPeriod = -1.0;
    private int dasaNo = -1;
    private static Planet[] vals;
    private static Planet[] orderByDasa;

    private Planet(String string2, int n2, double d, int n3) {
        this.sym = string2;
        this.swissPlanetNo = n2;
        this.dasaPeriod = d;
        this.dasaNo = n3;
    }

    private Planet(String string2) {
        this.sym = string2;
    }

    private Planet() {
    }

    public static Planet ofIndex(int n) {
        return vals[n % 9];
    }

    public String sym() {
        return this.sym;
    }

    public int planetNo() {
        return this.swissPlanetNo;
    }

    public double dasaPeriod() {
        if (this.dasaPeriod == -1.0) {
            throw new UnsupportedOperationException();
        }
        return this.dasaPeriod;
    }

    public static Set<Planet> allPlanets() {
        return EnumSet.range(Sun, Ketu);
    }

    public static Set<Planet> majorPlanets() {
        return EnumSet.range(Sun, Saturn);
    }

    public static Set<Planet> majorPlanetsAsc() {
        Set<Planet> set = Planet.majorPlanets();
        set.add(Ascendant);
        return set;
    }

    public static Set<Planet> planetsAsc() {
        return EnumSet.range(Sun, Ascendant);
    }

    public static boolean isNode(Planet planet) {
        return planet == Rahu || planet == Ketu;
    }

    public int dasaNo() {
        if (this.dasaNo == -1) {
            throw new UnsupportedOperationException();
        }
        return this.dasaNo;
    }

    public static Planet ofDasaNo(int n) {
        return orderByDasa[n % 9];
    }

    public Planet nextDasaPlanet() {
        return this.nextDasaPlanet(1);
    }

    public Planet nextDasaPlanet(int n) {
        return Planet.ofDasaNo(this.dasaNo + n);
    }

    public Planet nextPlanet() {
        return Planet.ofIndex(this.ordinal() + 1);
    }

    public static Set<Planet> doshaPlanets() {
        return EnumSet.of(Mars, Sun, Saturn, Ra_Ke);
    }

    public Rasi moolaTrikonaRasi() {
        switch (this) {
            case Sun: {
                return Rasi.Mesha;
            }
            case Moon: {
                return Rasi.Vrishabha;
            }
            case Mars: {
                return Rasi.Mesha;
            }
            case Mercury: {
                return Rasi.Kanya;
            }
            case Jupiter: {
                return Rasi.Dhanus;
            }
            case Venus: {
                return Rasi.Thula;
            }
            case Saturn: {
                return Rasi.Kumbha;
            }
        }
        throw new IllegalArgumentException("moolaTrikonaRasi() is invalid for planet " + this.name());
    }

    public boolean isMoolaTrikona(Rasi rasi) {
        return rasi == this.moolaTrikonaRasi();
    }

    public boolean isOwnerOf(Rasi rasi) {
        return this.equals((Object)rasi.owner());
    }

    public boolean isExaltedRasi(Rasi rasi) {
        return rasi.equals((Object)this.exaltedRasi());
    }

    public Rasi exaltedRasi() {
        switch (this) {
            case Sun: {
                return Rasi.Mesha;
            }
            case Moon: {
                return Rasi.Vrishabha;
            }
            case Mars: {
                return Rasi.Makara;
            }
            case Mercury: {
                return Rasi.Kanya;
            }
            case Jupiter: {
                return Rasi.Kataka;
            }
            case Venus: {
                return Rasi.Meena;
            }
            case Saturn: {
                return Rasi.Thula;
            }
        }
        throw new IllegalArgumentException("exaltedRasi() is invalid for planet " + this.name());
    }

    public boolean isDebilitatedRasi(Rasi rasi) {
        return rasi.equals((Object)this.debilitatedRasi());
    }

    public Rasi debilitatedRasi() {
        switch (this) {
            case Sun: {
                return Rasi.Thula;
            }
            case Moon: {
                return Rasi.Vrichika;
            }
            case Mars: {
                return Rasi.Kataka;
            }
            case Mercury: {
                return Rasi.Meena;
            }
            case Jupiter: {
                return Rasi.Makara;
            }
            case Venus: {
                return Rasi.Kanya;
            }
            case Saturn: {
                return Rasi.Mesha;
            }
        }
        throw new IllegalArgumentException("debilitatedRasi() is invalid for planet " + this.name());
    }

    public boolean isAspectingLocation(int n) {
        switch (this) {
            case Sun: 
            case Moon: 
            case Mercury: 
            case Venus: 
            case Rahu: 
            case Ketu: {
                return n == 7;
            }
            case Mars: {
                return n == 4 || n == 8 || n == 7;
            }
            case Jupiter: {
                return n == 5 || n == 9 || n == 7;
            }
            case Saturn: {
                return n == 3 || n == 10 || n == 7;
            }
        }
        throw new IllegalArgumentException("isAspectingLocation() is invalid for planet " + this.name());
    }

    public Character character() {
        if (Planet.papaPlanets().contains((Object)this)) {
            return Character.PAPA;
        }
        if (Planet.subaPlanets().contains((Object)this)) {
            return Character.SUBA;
        }
        return Character.UNKNOWN;
    }

    public static Set<Planet> papaPlanets() {
        return EnumSet.of(Sun, Mars, Saturn, Rahu, Ketu);
    }

    public static Set<Planet> subaPlanets() {
        return EnumSet.of(Jupiter, Venus, Mercury);
    }

    public boolean isBenefic() {
        Character character = this.character();
        if (character == Character.UNKNOWN) {
            throw new IllegalArgumentException("isBenefic() is not applicable for " + this.name());
        }
        return character == Character.SUBA;
    }

    public boolean isMalefic() {
        Character character = this.character();
        if (character == Character.UNKNOWN) {
            throw new IllegalArgumentException("isMalefic() is not applicable for " + this.name());
        }
        return character == Character.PAPA;
    }

    public boolean isAsc() {
        return this == Ascendant;
    }

    public boolean isNode() {
        return Planet.isNode(this);
    }

    public int ashtavargaNo() {
        if (this == Ascendant) {
            return 7;
        }
        if (Planet.isNode(this) || this == Ra_Ke) {
            return -1;
        }
        return this.ordinal();
    }

    public static List<AstrosoftTableColumn> toTableColumn(Set<Planet> set) {
        ArrayList<AstrosoftTableColumn> arrayList = new ArrayList<AstrosoftTableColumn>();
        for (Planet planet : set) {
            arrayList.add(AstrosoftTableColumn.valueOf(planet.name()));
        }
        return arrayList;
    }

    public String toString() {
        return Internalization.getString(this.name());
    }

    public String toString(DisplayFormat displayFormat) {
        return Internalization.getString(displayFormat, this.name(), this.sym());
    }

    public static Iterator<Planet> dasaIterator(Planet planet) {
        return new DasaIterator(planet);
    }

    public static Iterable<Planet> dasaLords(final Planet planet) {
        return new Iterable<Planet>(){

            @Override
            public Iterator<Planet> iterator() {
                return new DasaIterator(planet);
            }
        };
    }

    public static void main(String[] stringArray) {
        for (Planet planet : Planet.dasaLords(Saturn)) {
            System.out.println((Object)planet);
        }
    }

    static {
        vals = Planet.values();
        orderByDasa = new Planet[]{Sun, Moon, Mars, Rahu, Jupiter, Saturn, Mercury, Ketu, Venus};
    }

    private static class DasaIterator
    implements Iterator<Planet> {
        Planet current = null;
        short count = 0;

        public DasaIterator(Planet planet) {
            this.current = planet;
        }

        @Override
        public boolean hasNext() {
            return this.count != 9;
        }

        @Override
        public Planet next() {
            Planet planet = this.current;
            this.current = planet.nextDasaPlanet();
            this.count = (short)(this.count + 1);
            return planet;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }

    public static enum Character {
        PAPA,
        SUBA,
        UNKNOWN;

    }
}

