/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.consts;

import app.astrosoft.beans.Interval;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Planet;
import app.astrosoft.util.Internalization;
import app.astrosoft.util.Mod;

public enum Rasi {
    Mesha("Ari", Planet.Mars),
    Vrishabha("Tau", Planet.Venus),
    Mithuna("Gem", Planet.Mercury),
    Kataka("Can", Planet.Moon),
    Simha("Leo", Planet.Sun),
    Kanya("Vir", Planet.Mercury),
    Thula("Lib", Planet.Venus),
    Vrichika("Sco", Planet.Mars),
    Dhanus("Sag", Planet.Jupiter),
    Makara("Cap", Planet.Saturn),
    Kumbha("Aqu", Planet.Saturn),
    Meena("Pis", Planet.Jupiter);

    private String sym;
    private Planet owner;
    private static Rasi[] vals;

    private Rasi(String string2, Planet planet) {
        this.sym = string2;
        this.owner = planet;
    }

    public static Rasi ofIndex(int n) {
        return vals[n % vals.length];
    }

    public static Rasi ofDeg(double d) {
        return Rasi.ofIndex((int)(d / 30.0));
    }

    public String sym() {
        return this.sym;
    }

    public static Interval longitudeForRasi(Rasi rasi) {
        double d = (double)rasi.ordinal() * 30.0;
        double d2 = d + 30.0;
        Interval interval = new Interval(d, d2);
        return interval;
    }

    public Rasi absolute(int n) {
        return Rasi.ofIndex(this.ordinal() + n);
    }

    public Rasi next() {
        return this.absolute(1);
    }

    public Rasi previous() {
        return this.absolute(-1);
    }

    public Rasi[] trines() {
        return new Rasi[]{this, this.absolute(4), this.absolute(8)};
    }

    public Planet owner() {
        return this.owner;
    }

    public int bhava(Rasi rasi) {
        Mod mod = new Mod(12);
        return mod.sub(this.ordinal(), rasi.ordinal()) + 1;
    }

    public boolean isOddSign() {
        return this.ordinal() % 2 == 0;
    }

    public boolean isEvenSign() {
        return !this.isOddSign();
    }

    public boolean isMovableSign() {
        return this == Mesha || this == Kataka || this == Thula || this == Makara;
    }

    public boolean isFixedSign() {
        return this == Vrishabha || this == Simha || this == Vrichika || this == Kumbha;
    }

    public String toString() {
        return Internalization.getString(this.name());
    }

    public String toString(Language language) {
        return Internalization.getString(language, this.name());
    }

    public String toString(DisplayFormat displayFormat) {
        return Internalization.getString(displayFormat, this.name(), this.sym());
    }

    static {
        vals = Rasi.values();
    }
}

