/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.consts;

import app.astrosoft.util.Internalization;
import java.util.Calendar;
import java.util.GregorianCalendar;

public enum WeekDay {
    Sunday,
    Monday,
    Tuesday,
    Wednesday,
    Thursday,
    Friday,
    Saturday;

    private static final String[] rahukala;
    private static final String[] yamakanda;
    private static final String[][] auspiciousTime;
    private static WeekDay[] vals;

    public static WeekDay ofIndex(int n) {
        return vals[n % vals.length];
    }

    public static WeekDay ofDay(int n, int n2, int n3) {
        return WeekDay.ofCalendar(new GregorianCalendar(n, n2 - 1, n3));
    }

    public static WeekDay ofCalendar(Calendar calendar) {
        return WeekDay.ofIndex(calendar.get(7) - 1);
    }

    public String rahuKala() {
        return rahukala[this.ordinal()];
    }

    public String yamaKanda() {
        return yamakanda[this.ordinal()];
    }

    public String[] auspiciousTime() {
        return auspiciousTime[this.ordinal()];
    }

    public String sym() {
        return this.name().substring(0, 3);
    }

    public String toString() {
        return Internalization.getString(this.name());
    }

    static {
        rahukala = new String[]{"04:30 PM - 06:00 PM", "07:30 AM - 09:00 AM", "03:00 PM - 4:30 PM", "12:00 PM - 01:30 PM", "01:30 PM - 03:00 PM", "10:30 AM - 12:00 PM", "09:00 AM - 10:30 AM"};
        yamakanda = new String[]{"12:00 PM - 1:30 PM", "10:30 AM - 12:00 AM", "09:00 AM - 10:30 AM", "07:30 AM - 09:00 AM", "06:00 AM - 07:30 AM", "03:00 PM - 04:30 PM", "01:30 PM - 03:00 PM"};
        auspiciousTime = new String[][]{{"07.30 - 10.00 am", "02.00 - 04.30 pm", "09.00 pm - 12.00 am"}, {"06.00 - 07.00 am ", "12.00 - 02.00 pm", "06.00 - 09.00 pm , 10.00 - 11.00 pm"}, {"10.30 - 11.00 am", "12.00 - 01.00 pm , 04.30 - 06.00 pm ", "07.00 - 08.00 pm"}, {"09.00 - 10.00 am", "01.30 - 03.00 pm , 04.00 - 05.00 pm", "07.00 - 10.00 pm , 11.00 pm - 12.00 am"}, {"09.00 - 10.30 am", "01.00 - 01.30 pm , 04.30 - 06.00 pm", "06.00 - 07.00 pm , 08.00 - 09.00 pm"}, {"06.00 - 09.00  am", "01.00 - 01.30 pm , 05.00 - 06.00 pm", "08.00 - 9.00 pm , 10.30 - 11.00 pm"}, {"07.00 - 07.30 am , 10.30 - 12.00 pm", "12.00 - 01.00 pm , 05.00 - 06.00 pm", "06.00 - 07.30 pm , 09.00 - 10.00 pm"}};
        vals = WeekDay.values();
    }
}

