/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.consts;

import app.astrosoft.export.XMLHelper;
import app.astrosoft.html.Attribute;
import app.astrosoft.html.Tag;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public enum YogaCombination {
    AmalaYoga,
    AnaphaYoga,
    SunaphaYoga,
    GajakesariYoga,
    KemadrumaYoga,
    ChandraManglaYoga,
    DhurdhuraYoga,
    AdhiYoga,
    ChatussagaraYoga,
    VasumathiYoga,
    RajalakshanaYoga,
    SakataYoga,
    SubhaVesiYoga,
    PapaVesiYoga,
    SubhaVasiYoga,
    PapaVasiYoga,
    ObhayachariYoga,
    HamsaYoga,
    MalavyaYoga,
    SasaYoga,
    RuchakaYoga,
    BhadraYoga,
    KusumaYoga,
    JayaYoga,
    SivaYoga,
    ChapaYoga,
    KahalaYoga,
    LakshmiYoga,
    MahabhagyaYoga,
    BudhaAdityaYoga,
    SankhaYoga,
    BheriYoga,
    SreenathaYoga,
    GajaYoga,
    AmsavataraYoga,
    DevendraYoga,
    MakutaYoga,
    VidyutYoga,
    IndraYoga,
    RaviYoga,
    GoYoga,
    ThrilochanaYoga;

    private static Set<YogaCombination> negativeYogas;
    private static final Logger log;
    private static final String XML_SOURCE = "/resources/YogaCombinations.xml";
    private static XPath xpath;
    private static final Attribute titleColorAttr;

    public String getDefinition() {
        return this.getXmlNode("Definition").getTextContent();
    }

    public String getResults() {
        return this.getXmlNode("Results").getTextContent();
    }

    private Node getXmlNode(String string) {
        String string2 = "//Astrosoft/YogaCombinations/YogaCombination[@Name='" + this.name() + "']";
        InputSource inputSource = new InputSource(YogaCombination.class.getResourceAsStream(XML_SOURCE));
        Node node = null;
        try {
            node = (Node)xpath.evaluate(string2, inputSource, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            log.log(Level.SEVERE, "Exception in queryin xml", xPathExpressionException);
        }
        if (node != null) {
            return XMLHelper.getChildNode(node, string);
        }
        throw new IllegalArgumentException(string + "is not found in XML");
    }

    public boolean isPosition() {
        return !negativeYogas.contains((Object)this);
    }

    public boolean isNegative() {
        return negativeYogas.contains((Object)this);
    }

    public String getHtmlString() {
        Tag tag = new Tag("html");
        Tag tag2 = new Tag("head");
        tag2.add(YogaCombination.generateStyleTag());
        tag.add(tag2);
        Tag tag3 = new Tag("body");
        String string = this.getDefinition();
        String string2 = this.getResults();
        Tag tag4 = new Tag("p");
        tag4.add(YogaCombination.generateTitleTag("Definition:-"));
        tag4.add(string);
        Tag tag5 = new Tag("p");
        tag5.add(YogaCombination.generateTitleTag("Results:-"));
        tag5.add(string2);
        tag3.add(tag4);
        tag3.add(tag5);
        tag.add(tag3);
        System.out.println(tag);
        return tag.toString();
    }

    private static Tag generateStyleTag() {
        Tag tag = new Tag("style");
        tag.addAttribute(new Attribute("type", "text/css"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("body { \n");
        stringBuffer.append("    \t\tfont-family: Tahoma; \n");
        stringBuffer.append("    \t\tfont-size: 12pt; \n");
        stringBuffer.append("    \t\tcolor:#000000; \n");
        stringBuffer.append("    \t\tbackground:#FFFFFC; \n");
        stringBuffer.append("    \t } \n");
        tag.add(stringBuffer.toString());
        return tag;
    }

    private static Tag generateTitleTag(String string) {
        Tag tag = new Tag("font");
        tag.addAttribute(titleColorAttr);
        Tag tag2 = new Tag("b");
        tag2.add(string);
        tag.add(tag2);
        return tag;
    }

    public static void main(String[] stringArray) {
        System.out.println(AmalaYoga.getResults());
    }

    static {
        negativeYogas = EnumSet.of(SakataYoga, KemadrumaYoga, PapaVesiYoga);
        log = Logger.getLogger(YogaCombination.class.getName());
        xpath = XPathFactory.newInstance().newXPath();
        titleColorAttr = new Attribute("color", "#0000FF");
    }
}

