/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.consts.AshtavargaName;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.MapTableRow;
import app.astrosoft.ui.table.MapTableRowHelper;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.ui.table.TableRowData;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Vector;

public class Ashtavarga
implements Exportable {
    private static int[] one = new int[]{0, 2, 6, 9, 11, 12, 18, 22, 23, 26, 27, 29, 30, 31, 32, 34, 35, 36, 39, 41, 45, 47, 48, 55};
    private static int[] two = new int[]{0, 2, 6, 10, 18, 25, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 39, 41, 45, 47, 48};
    private static int[] three = new int[]{1, 3, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 19, 23, 27, 29, 32, 36, 38, 41, 42, 43, 45, 46, 47, 49, 50, 54, 55};
    private static int[] four = new int[]{0, 2, 6, 7, 11, 12, 13, 18, 22, 25, 26, 29, 30, 31, 32, 34, 35, 36, 39, 41, 45, 46, 47, 48, 55};
    private static int[] five = new int[]{3, 4, 10, 11, 13, 14, 16, 19, 24, 27, 29, 33, 35, 37, 38, 39, 41, 42, 44, 43, 45, 46, 47, 52, 54, 50};
    private static int[] six = new int[]{1, 3, 4, 5, 7, 8, 9, 10, 14, 15, 16, 17, 19, 20, 21, 23, 24, 25, 27, 28, 31, 35, 37, 38, 39, 42, 43, 49, 50, 51, 52, 53, 54, 55};
    private static int[] seven = new int[]{0, 2, 5, 6, 8, 9, 11, 12, 13, 18, 22, 26, 30, 32, 33, 34, 36, 39, 48};
    private static int[] eight = new int[]{0, 2, 6, 8, 11, 12, 18, 21, 22, 25, 26, 28, 29, 30, 31, 32, 34, 36, 40, 41, 44, 45, 46, 47, 48, 51};
    private static int[] nine = new int[]{0, 2, 3, 4, 6, 10, 13, 22, 24, 26, 27, 29, 30, 32, 33, 35, 37, 39, 41, 42, 43, 44, 45, 46, 47, 51};
    private static int[] ten = new int[]{0, 1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 20, 22, 23, 25, 26, 27, 30, 31, 32, 34, 35, 36, 37, 39, 44, 45, 46, 48, 50, 51, 55};
    private static int[] eleven = new int[]{0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 39, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static int[] twelve = new int[]{3, 5, 7, 12, 20, 21, 24, 27, 28, 38, 40, 41, 42, 51, 52, 53, 50};
    private static EnumMap<AshtavargaName, Integer> count;
    private static int[] rasiGunaVals;
    private static int[] grahaGunaVals;
    Vector<int[]> v;
    private EnumMap<AshtavargaName, EnumMap<Rasi, Integer>> ashtavarga;
    private EnumMap<AshtavargaName, EnumMap<Rasi, Integer>> trikonaReduced;
    private EnumMap<AshtavargaName, EnumMap<Rasi, Integer>> ekathipathiyaReduced;
    private EnumMap<AshtavargaName, Integer> rasiGuna;
    private EnumMap<AshtavargaName, Integer> grahaGuna;
    private EnumMap<Planet, Integer> planetPos;

    public Ashtavarga(EnumMap<Planet, Integer> enumMap) {
        this.planetPos = enumMap;
        this.v = new Vector();
        this.v.add(one);
        this.v.add(two);
        this.v.add(three);
        this.v.add(four);
        this.v.add(five);
        this.v.add(six);
        this.v.add(seven);
        this.v.add(eight);
        this.v.add(nine);
        this.v.add(ten);
        this.v.add(eleven);
        this.v.add(twelve);
        this.computeAstavarga();
        this.calcSarvastaVarga();
        this.doTrikonaReduction();
        this.doEkathipathiyaReduction();
        this.calcGunakaras();
        this.initCount();
    }

    private void initCount() {
        count = new EnumMap(AshtavargaName.class);
        count.put(AshtavargaName.Sun, 48);
        count.put(AshtavargaName.Moon, 49);
        count.put(AshtavargaName.Mars, 39);
        count.put(AshtavargaName.Mercury, 54);
        count.put(AshtavargaName.Jupiter, 56);
        count.put(AshtavargaName.Venus, 52);
        count.put(AshtavargaName.Saturn, 39);
    }

    private int getParal(int n, int n2) {
        int n3 = 0;
        int[] nArray = this.v.elementAt(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n2) continue;
            n3 = 1;
            break;
        }
        return n3;
    }

    private void computeAstavarga() {
        this.ashtavarga = new EnumMap(AshtavargaName.class);
        int n = 0;
        int n2 = 0;
        for (Planet planet : Planet.majorPlanets()) {
            EnumMap<Rasi, Integer> enumMap = this.initParals();
            for (Rasi rasi : Rasi.values()) {
                int n3 = 0;
                for (Planet planet2 : Planet.majorPlanetsAsc()) {
                    n = (rasi.ordinal() + 1 - this.planetPos.get((Object)planet2) + 12) % 12;
                    n2 = this.getParal(n, 8 * planet.ordinal() + planet2.ashtavargaNo());
                    n3 += n2;
                }
                enumMap.put(rasi, n3);
            }
            this.ashtavarga.put(AshtavargaName.ofPlanet(planet), enumMap);
        }
    }

    private void calcSarvastaVarga() {
        int n = 0;
        EnumMap<Rasi, Integer> enumMap = new EnumMap<Rasi, Integer>(Rasi.class);
        for (Rasi rasi : Rasi.values()) {
            n = 0;
            for (Planet planet : Planet.majorPlanets()) {
                n += this.ashtavarga.get((Object)AshtavargaName.ofPlanet(planet)).get((Object)rasi).intValue();
            }
            enumMap.put(rasi, n);
        }
        this.ashtavarga.put(AshtavargaName.SarvaAshtavarga, enumMap);
    }

    private void doTrikonaReduction() {
        this.trikonaReduced = new EnumMap(AshtavargaName.class);
        for (AshtavargaName ashtavargaName : this.ashtavarga.keySet()) {
            EnumMap<Rasi, Integer> enumMap = this.initParals();
            EnumMap<Rasi, Integer> enumMap2 = this.ashtavarga.get((Object)ashtavargaName);
            for (Rasi rasi = Rasi.Mesha; rasi != Rasi.Simha; rasi = rasi.next()) {
                int n;
                int n2;
                int n3;
                Rasi[] rasiArray = rasi.trines();
                if (ashtavargaName == AshtavargaName.SarvaAshtavarga) {
                    n3 = enumMap2.get((Object)rasiArray[0]) % 12;
                    n2 = enumMap2.get((Object)rasiArray[1]) % 12;
                    n = enumMap2.get((Object)rasiArray[2]) % 12;
                } else {
                    n3 = enumMap2.get((Object)rasiArray[0]);
                    n2 = enumMap2.get((Object)rasiArray[1]);
                    n = enumMap2.get((Object)rasiArray[2]);
                }
                if (n3 == n2 && n2 == n) {
                    for (Rasi rasi2 : rasiArray) {
                        enumMap.put(rasi2, 0);
                    }
                    continue;
                }
                if (n3 == 0 && n2 == 0 || n3 == 0 && n == 0 || n == 0 && n2 == 0) {
                    for (Rasi rasi2 : rasiArray) {
                        enumMap.put(rasi2, 0);
                    }
                    continue;
                }
                int n4 = Math.min(Math.min(n3, n2), n);
                if (n3 != n4) {
                    enumMap.put(rasiArray[0], n3 - n4);
                }
                if (n2 != n4) {
                    enumMap.put(rasiArray[1], n2 - n4);
                }
                if (n == n4) continue;
                enumMap.put(rasiArray[2], n - n4);
            }
            this.trikonaReduced.put(ashtavargaName, enumMap);
        }
    }

    private void doEkathipathiyaReduction() {
        this.ekathipathiyaReduced = new EnumMap(AshtavargaName.class);
        for (AshtavargaName ashtavargaName : this.ashtavarga.keySet()) {
            Rasi rasi = Rasi.Makara;
            Rasi rasi2 = Rasi.Kumbha;
            EnumMap<Rasi, Integer> enumMap = this.initParals();
            EnumMap<Rasi, Integer> enumMap2 = this.trikonaReduced.get((Object)ashtavargaName);
            while (rasi != Rasi.Kataka) {
                int n = enumMap2.get((Object)rasi);
                int n2 = enumMap2.get((Object)rasi2);
                if (rasi == Rasi.Simha && rasi2 == Rasi.Kataka) {
                    enumMap.put(rasi, n);
                    enumMap.put(rasi2, n2);
                } else if (n == 0 || n2 == 0 || this.hasPlanet(rasi) && this.hasPlanet(rasi2)) {
                    enumMap.put(rasi, n);
                    enumMap.put(rasi2, n2);
                } else if (this.hasPlanet(rasi) && !this.hasPlanet(rasi2)) {
                    if (n >= n2) {
                        enumMap.put(rasi, n);
                        enumMap.put(rasi2, 0);
                    } else if (n < n2) {
                        enumMap.put(rasi, n);
                        enumMap.put(rasi2, n);
                    }
                } else if (!this.hasPlanet(rasi) && this.hasPlanet(rasi2)) {
                    if (n2 >= n) {
                        enumMap.put(rasi, 0);
                        enumMap.put(rasi2, n2);
                    } else if (n2 < n) {
                        enumMap.put(rasi, n2);
                        enumMap.put(rasi2, n2);
                    }
                } else if (n == n2) {
                    enumMap.put(rasi, 0);
                    enumMap.put(rasi2, 0);
                } else if (n < n2) {
                    enumMap.put(rasi, n);
                    enumMap.put(rasi2, n);
                } else {
                    enumMap.put(rasi, n2);
                    enumMap.put(rasi2, n2);
                }
                rasi = rasi.previous();
                rasi2 = rasi2.next();
            }
            this.ekathipathiyaReduced.put(ashtavargaName, enumMap);
        }
    }

    private boolean hasPlanet(Rasi rasi) {
        boolean bl = false;
        int n = rasi.ordinal() + 1;
        for (Planet planet : Planet.majorPlanetsAsc()) {
            if (this.planetPos.get((Object)planet) != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void calcGunakaras() {
        this.rasiGuna = new EnumMap(AshtavargaName.class);
        this.grahaGuna = new EnumMap(AshtavargaName.class);
        int n = 0;
        for (AshtavargaName ashtavargaName : this.ashtavarga.keySet()) {
            EnumMap<Rasi, Integer> enumMap = this.ekathipathiyaReduced.get((Object)ashtavargaName);
            n = 0;
            for (Rasi rasi : Rasi.values()) {
                n += rasiGunaVals[rasi.ordinal()] * enumMap.get((Object)rasi);
            }
            this.rasiGuna.put(ashtavargaName, n);
            n = 0;
            for (Planet planet : Planet.majorPlanets()) {
                n += grahaGunaVals[planet.ordinal()] * enumMap.get((Object)Rasi.ofIndex(this.planetPos.get((Object)planet) - 1));
            }
            this.grahaGuna.put(ashtavargaName, n);
        }
    }

    private EnumMap<Rasi, Integer> initParals() {
        EnumMap<Rasi, Integer> enumMap = new EnumMap<Rasi, Integer>(Rasi.class);
        for (Rasi rasi : Rasi.values()) {
            enumMap.put(rasi, 0);
        }
        return enumMap;
    }

    public static int getCount(AshtavargaName ashtavargaName) {
        if (count.containsKey((Object)ashtavargaName)) {
            return count.get((Object)ashtavargaName);
        }
        return -1;
    }

    public Table getGunaTable(AshtavargaName ashtavargaName) {
        final DefaultColumnMetaData defaultColumnMetaData = new DefaultColumnMetaData(AstrosoftTableColumn.keyvalCols());
        defaultColumnMetaData.localizeColumns();
        MapTableRowHelper mapTableRowHelper = new MapTableRowHelper(defaultColumnMetaData);
        ArrayList<MapTableRow> arrayList = new ArrayList<MapTableRow>();
        int n = this.rasiGuna.get((Object)ashtavargaName);
        int n2 = this.grahaGuna.get((Object)ashtavargaName);
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.RASI_GUNA_STR, n}));
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.GRAHA_GUNA_STR, n2}));
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.SUTHDHA_BINDU_STR, n + n2}));
        final TableData tableData = TableDataFactory.getTableData(arrayList);
        Table table = new Table(){

            @Override
            public TableData<? extends TableRowData> getTableData() {
                return tableData;
            }

            @Override
            public ColumnMetaData getColumnMetaData() {
                return defaultColumnMetaData;
            }
        };
        return table;
    }

    public EnumMap<Rasi, Integer> getAshtavarga(AshtavargaName ashtavargaName) {
        return this.ashtavarga.get((Object)ashtavargaName);
    }

    public EnumMap<Rasi, Integer> getTrikona(AshtavargaName ashtavargaName) {
        return this.trikonaReduced.get((Object)ashtavargaName);
    }

    public EnumMap<Rasi, Integer> getEkathipathiya(AshtavargaName ashtavargaName) {
        return this.ekathipathiyaReduced.get((Object)ashtavargaName);
    }

    public int getGrahaGuna(AshtavargaName ashtavargaName) {
        return this.grahaGuna.get((Object)ashtavargaName);
    }

    public int getRasiGuna(AshtavargaName ashtavargaName) {
        return this.rasiGuna.get((Object)ashtavargaName);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ashtavarga\n");
        int n = 0;
        int n2 = 0;
        for (AshtavargaName ashtavargaName : this.ashtavarga.keySet()) {
            stringBuilder.append((Object)((Object)ashtavargaName) + " Astavarga \n\n");
            n = 0;
            for (Rasi rasi : Rasi.values()) {
                n += this.ashtavarga.get((Object)ashtavargaName).get((Object)rasi).intValue();
                stringBuilder.append((Object)((Object)rasi) + " -->  " + this.ashtavarga.get((Object)ashtavargaName).get((Object)rasi) + "\n");
            }
            stringBuilder.append("Sum " + n + "\n\n");
            n2 += n;
            stringBuilder.append("RasiGuna " + this.rasiGuna.get((Object)ashtavargaName) + "\n");
            stringBuilder.append("GrahaGuna " + this.grahaGuna.get((Object)ashtavargaName) + "\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("Total " + n2 + "\n");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        EnumMap<Planet, Integer> enumMap = new EnumMap<Planet, Integer>(Planet.class);
        enumMap.put(Planet.Sun, 8);
        enumMap.put(Planet.Moon, 10);
        enumMap.put(Planet.Mars, 9);
        enumMap.put(Planet.Mercury, 8);
        enumMap.put(Planet.Jupiter, 6);
        enumMap.put(Planet.Venus, 7);
        enumMap.put(Planet.Saturn, 6);
        enumMap.put(Planet.Rahu, 4);
        enumMap.put(Planet.Ketu, 10);
        enumMap.put(Planet.Ascendant, 6);
        Ashtavarga ashtavarga = new Ashtavarga(enumMap);
        System.out.println(ashtavarga);
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }

    static {
        rasiGunaVals = new int[]{7, 10, 8, 4, 10, 5, 7, 8, 9, 5, 11, 12};
        grahaGunaVals = new int[]{5, 5, 8, 5, 10, 7, 5};
    }
}

