/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.beans.BirthData;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.AstroConsts;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Kuta;
import app.astrosoft.consts.Nakshathra;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.core.Horoscope;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.export.XMLHelper;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.MapTableRow;
import app.astrosoft.ui.table.MapTableRowHelper;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.FileOps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Compactibility
implements Exportable {
    private String boyName;
    private String girlName;
    private int boyNak;
    private int girlNak;
    private int boyRasi;
    private int girlRasi;
    private BirthData boyBirthData;
    private BirthData girlBirthData;
    private EnumMap<Kuta, Integer> kutas;
    private TableData<? extends TableRowData> kutaTableData;
    private TableData<? extends TableRowData> boyInfo;
    private TableData<? extends TableRowData> girlInfo;
    private static DefaultColumnMetaData kutaTableColumnMetaData;
    private static DefaultColumnMetaData infoTableColumnMetaData;
    private TableData<? extends TableRowData> doshaTableData;
    private static DefaultColumnMetaData doshaTableColumnMetaData;
    private int totalKutaGained = 0;
    private PlanetaryInfo boyPlanetaryInfo;
    private PlanetaryInfo girlPlanetaryInfo;
    private EnumMap<Planet, Double> boyDosha;
    private EnumMap<Planet, Double> girlDosha;
    private double bDoshaTotal = 0.0;
    private double gDoshaTotal = 0.0;
    private String bCurPeriod;
    private String gCurPeriod;
    private Rasi beejaRasi;
    private Rasi kshetraRasi;
    private double beejaPos;
    private double kshetraPos;
    private boolean hasHoroscope = false;

    public Compactibility(String string, String string2, Nakshathra nakshathra, Nakshathra nakshathra2, Rasi rasi, Rasi rasi2) {
        this.boyName = string;
        this.girlName = string2;
        this.boyNak = nakshathra.ordinal();
        this.girlNak = nakshathra2.ordinal();
        this.boyRasi = rasi.ordinal();
        this.girlRasi = rasi2.ordinal();
        this.kutas = new EnumMap(Kuta.class);
        this.totalKutaGained = 0;
        this.calcKutas();
        for (Kuta kuta : Kuta.values()) {
            this.totalKutaGained += this.kutas.get((Object)kuta).intValue();
        }
        this.constructColumnMetaData();
    }

    public Compactibility(Horoscope horoscope, Horoscope horoscope2) {
        this(horoscope.getBirthData().name(), horoscope2.getBirthData().name(), horoscope.getNakshathra().getNak(), horoscope2.getNakshathra().getNak(), horoscope.getRasi(), horoscope2.getRasi());
        this.boyBirthData = horoscope.getBirthData();
        this.girlBirthData = horoscope2.getBirthData();
        this.bCurPeriod = horoscope.getCurrentDasa();
        this.gCurPeriod = horoscope2.getCurrentDasa();
        this.boyPlanetaryInfo = horoscope.getPlanetaryInfo();
        this.girlPlanetaryInfo = horoscope2.getPlanetaryInfo();
        this.calcDoshas();
        this.calcBeejaKshetra();
        this.hasHoroscope = true;
    }

    public void saveToXML(String string) {
        Document document = XMLHelper.createDOM();
        Element element = XMLHelper.addRootElement(document, "Compactibility");
        XMLHelper.addAttribute(element, "hasHoroscope", "true");
        if (this.hasHoroscope) {
            element.appendChild(this.boyBirthData.toXMLElement(document, "BoyData"));
            element.appendChild(this.girlBirthData.toXMLElement(document, "GirlData"));
            XMLHelper.addAttribute(element, "hasHoroscope", "true");
        } else {
            XMLHelper.addAttribute(element, "hasHoroscope", "false");
            Element element2 = document.createElement("BoyData");
            Element element3 = document.createElement("GirlData");
            XMLHelper.addElement(document, element2, "Name", this.boyName);
            XMLHelper.addElement(document, element2, "Name", this.girlName);
            XMLHelper.addElement(document, element2, "Rasi", this.boyRasi().name());
            XMLHelper.addElement(document, element2, "Nakshathra", this.boyNak().name());
            XMLHelper.addElement(document, element3, "Rasi", this.girlRasi().name());
            XMLHelper.addElement(document, element3, "Nakshathra", this.girlNak().name());
            element.appendChild(element2);
            element.appendChild(element3);
        }
        XMLHelper.saveXML(document, string);
    }

    public static Compactibility createFromXML(String string) {
        Compactibility compactibility;
        Document document = XMLHelper.parseXML(string);
        Element element = (Element)document.getChildNodes().item(0);
        boolean bl = Boolean.valueOf(element.getAttribute("hasHoroscope"));
        Node node = element.getChildNodes().item(0);
        Node node2 = element.getChildNodes().item(1);
        if (bl) {
            compactibility = new Compactibility(new Horoscope(BirthData.valueOfXMLNode(node)), new Horoscope(BirthData.valueOfXMLNode(node2)));
        } else {
            Map<String, String> map = XMLHelper.getChildElements(node);
            Map<String, String> map2 = XMLHelper.getChildElements(node2);
            compactibility = new Compactibility(map.get("Name"), map2.get("Name"), Nakshathra.valueOf(map.get("Nakshathra")), Nakshathra.valueOf(map2.get("Nakshathra")), Rasi.valueOf(map.get("Rasi")), Rasi.valueOf(map2.get("Rasi")));
        }
        return compactibility;
    }

    private void calcKutas() {
        this.kutas.put(Kuta.Dina, this.calcDinaKuta());
        this.kutas.put(Kuta.Gana, this.calcGanaKuta());
        this.kutas.put(Kuta.Mahendra, this.calcMahendraKuta());
        this.kutas.put(Kuta.StreeDeergha, this.calcStreeDeerghaKuta());
        this.kutas.put(Kuta.Yoni, this.calcYoniKuta());
        this.kutas.put(Kuta.Rasi, this.calcRasiKuta());
        this.kutas.put(Kuta.RasiAdhipathi, this.calcRasiAdhipathiKuta());
        this.kutas.put(Kuta.Vasya, this.calcVasyaKuta());
        this.kutas.put(Kuta.Rajju, this.calcRajjuKuta());
        this.kutas.put(Kuta.Vedha, this.calcVedhaKuta());
        this.kutas.put(Kuta.Varna, this.calcVarnaKuta());
        this.kutas.put(Kuta.Nadi, this.calcNadiKuta());
    }

    private int calcDinaKuta() {
        int n = this.boyNak - this.girlNak + 1;
        if (n <= 0) {
            n += 27;
        }
        if ((n %= 9) % 2 == 0) {
            return 3;
        }
        return 0;
    }

    private int calcGanaKuta() {
        int n = this.findGana(this.boyNak);
        int n2 = this.findGana(this.girlNak);
        int n3 = 0;
        if (n == n2 || n == 1 && n2 == 2) {
            n3 = 6;
        } else if (n == 2 && n2 == 1) {
            n3 = 4;
        } else if (n == 3 && (n2 == 1 || n2 == 2)) {
            n3 = 3;
        } else if (n2 == 3 && (n == 1 || n == 2)) {
            int n4 = this.girlNak - this.boyNak + 1;
            if (n4 <= 0) {
                n4 += 27;
            }
            n3 = n4 > 14 ? 3 : 0;
        }
        return n3;
    }

    private int findGana(int n) {
        int n2 = 0;
        switch (n) {
            case 0: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 26: {
                n2 = 1;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                n2 = 3;
            }
        }
        return n2;
    }

    private int calcMahendraKuta() {
        int n = this.boyNak - this.girlNak + 1;
        if (n <= 0) {
            n += 27;
        }
        if (n == 4 || n == 7 || n == 10 || n == 13 || n == 16 || n == 19 || n == 22 || n == 25) {
            return 1;
        }
        return 0;
    }

    private int calcStreeDeerghaKuta() {
        int n = this.boyNak - this.girlNak + 1;
        if (n <= 0) {
            n += 27;
        }
        if (n > 9) {
            return 1;
        }
        return 0;
    }

    private int calcYoniKuta() {
        int n = this.findYoni(this.boyNak);
        int n2 = this.findYoni(this.girlNak);
        int n3 = FileOps.getFromFile(KutaFile.YoniKuta.file(), n, n2);
        return n3;
    }

    private int findYoni(int n) {
        int n2 = 0;
        switch (n) {
            case 0: 
            case 23: {
                n2 = 1;
                break;
            }
            case 1: 
            case 26: {
                n2 = 2;
                break;
            }
            case 2: 
            case 7: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 4;
                break;
            }
            case 5: 
            case 18: {
                n2 = 5;
                break;
            }
            case 6: 
            case 8: {
                n2 = 6;
                break;
            }
            case 9: 
            case 10: {
                n2 = 7;
                break;
            }
            case 11: 
            case 25: {
                n2 = 8;
                break;
            }
            case 12: 
            case 14: {
                n2 = 9;
                break;
            }
            case 13: 
            case 15: {
                n2 = 10;
                break;
            }
            case 16: 
            case 17: {
                n2 = 11;
                break;
            }
            case 19: 
            case 21: {
                n2 = 12;
                break;
            }
            case 20: {
                n2 = 13;
                break;
            }
            case 22: 
            case 24: {
                n2 = 14;
            }
        }
        return n2;
    }

    private int calcRasiKuta() {
        int n = FileOps.getFromFile(KutaFile.RasiKuta.file(), this.girlRasi + 1, this.boyRasi + 1);
        return n;
    }

    private int calcRasiAdhipathiKuta() {
        Planet planet;
        int n = 0;
        Planet planet2 = Rasi.ofIndex(this.boyRasi).owner();
        if (planet2 == (planet = Rasi.ofIndex(this.girlRasi).owner())) {
            n = 5;
            return n;
        }
        int n2 = AstroConsts.permanentRel(planet2, planet);
        int n3 = AstroConsts.permanentRel(planet, planet2);
        if (n2 < 0 || n3 < 0) {
            n = 0;
        } else if (n2 == 0 && n3 == 0) {
            n = 2;
        } else if (n2 == 1 && n3 == 1) {
            n = 5;
        } else if (n2 == 1 && n3 == 0 || n2 == 0 && n3 == 1) {
            n = 4;
        }
        return n;
    }

    private int calcVasyaKuta() {
        int n = 0;
        switch (this.girlRasi) {
            case 0: {
                if (this.boyRasi != 0 && this.boyRasi != 4 && this.boyRasi != 7) break;
                n = 2;
                break;
            }
            case 1: {
                if (this.boyRasi != 1 && this.boyRasi != 3 && this.boyRasi != 6) break;
                n = 2;
                break;
            }
            case 2: {
                if (this.boyRasi != 2 && this.boyRasi != 5) break;
                n = 2;
                break;
            }
            case 3: {
                if (this.boyRasi != 3 && this.boyRasi != 7 && this.boyRasi != 8) break;
                n = 2;
                break;
            }
            case 4: {
                if (this.boyRasi != 4 && this.boyRasi != 6) break;
                n = 2;
                break;
            }
            case 5: {
                if (this.boyRasi != 5 && this.boyRasi != 2 && this.boyRasi != 11) break;
                n = 2;
                break;
            }
            case 6: {
                if (this.boyRasi != 6 && this.boyRasi != 5 && this.boyRasi != 9) break;
                n = 2;
                break;
            }
            case 7: {
                if (this.boyRasi != 7 && this.boyRasi != 3) break;
                n = 2;
                break;
            }
            case 8: {
                if (this.boyRasi != 8 && this.boyRasi != 11) break;
                n = 2;
                break;
            }
            case 9: {
                if (this.boyRasi != 9 && this.boyRasi != 0 && this.boyRasi != 10) break;
                n = 2;
                break;
            }
            case 10: {
                if (this.boyRasi != 10 && this.boyRasi != 0) break;
                n = 2;
                break;
            }
            case 11: {
                if (this.boyRasi != 11 && this.boyRasi != 9) break;
                n = 2;
            }
        }
        return n;
    }

    private int calcRajjuKuta() {
        int[] nArray = new int[]{0, 8, 9, 17, 18, 26};
        int[] nArray2 = new int[]{1, 7, 10, 16, 19, 25};
        int[] nArray3 = new int[]{2, 6, 11, 15, 20, 24};
        int[] nArray4 = new int[]{3, 5, 12, 14, 21, 23};
        int[] nArray5 = new int[]{4, 13, 22};
        if (this.found(nArray, this.boyNak) && this.found(nArray, this.girlNak)) {
            return 0;
        }
        if (this.found(nArray2, this.boyNak) && this.found(nArray2, this.girlNak)) {
            return 0;
        }
        if (this.found(nArray3, this.boyNak) && this.found(nArray3, this.girlNak)) {
            return 0;
        }
        if (this.found(nArray4, this.boyNak) && this.found(nArray4, this.girlNak)) {
            return 0;
        }
        if (this.found(nArray5, this.boyNak) && this.found(nArray5, this.girlNak)) {
            return 0;
        }
        return 1;
    }

    private boolean found(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private int calcVedhaKuta() {
        if (this.boyNak == 0 && this.girlNak == 17 || this.boyNak == 17 && this.girlNak == 0) {
            return 0;
        }
        if (this.boyNak == 1 && this.girlNak == 16 || this.boyNak == 16 && this.girlNak == 1) {
            return 0;
        }
        if (this.boyNak == 2 && this.girlNak == 15 || this.boyNak == 15 && this.girlNak == 2) {
            return 0;
        }
        if (this.boyNak == 3 && this.girlNak == 14 || this.boyNak == 14 && this.girlNak == 3) {
            return 0;
        }
        if (this.boyNak == 5 && this.girlNak == 21 || this.boyNak == 21 && this.girlNak == 5) {
            return 0;
        }
        if (this.boyNak == 6 && this.girlNak == 20 || this.boyNak == 20 && this.girlNak == 6) {
            return 0;
        }
        if (this.boyNak == 7 && this.girlNak == 19 || this.boyNak == 19 && this.girlNak == 7) {
            return 0;
        }
        if (this.boyNak == 8 && this.girlNak == 18 || this.boyNak == 18 && this.girlNak == 8) {
            return 0;
        }
        if (this.boyNak == 9 && this.girlNak == 26 || this.boyNak == 26 && this.girlNak == 9) {
            return 0;
        }
        if (this.boyNak == 10 && this.girlNak == 25 || this.boyNak == 25 && this.girlNak == 10) {
            return 0;
        }
        if (this.boyNak == 11 && this.girlNak == 24 || this.boyNak == 24 && this.girlNak == 11) {
            return 0;
        }
        if (this.boyNak == 12 && this.girlNak == 23 || this.boyNak == 12 && this.girlNak == 23) {
            return 0;
        }
        if (this.boyNak == 4 && this.girlNak == 22 || this.boyNak == 22 && this.girlNak == 4) {
            return 0;
        }
        return 1;
    }

    private int calcVarnaKuta() {
        int n = this.findGrade(this.boyRasi);
        int n2 = this.findGrade(this.girlRasi);
        if (n2 > n) {
            return 0;
        }
        return 1;
    }

    private int findGrade(int n) {
        int n2 = 0;
        switch (n) {
            case 3: 
            case 7: 
            case 11: {
                n2 = 4;
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
            case 0: 
            case 2: 
            case 10: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                n2 = 1;
            }
        }
        return n2;
    }

    private int calcNadiKuta() {
        int n = FileOps.getFromFile(KutaFile.NadiKuta.file(), this.girlNak + 1, this.boyNak + 1);
        return n;
    }

    private void calcDoshas() {
        EnumMap<Planet, Integer> enumMap = this.boyPlanetaryInfo.getPlanetLocation();
        EnumMap<Planet, Integer> enumMap2 = this.girlPlanetaryInfo.getPlanetLocation();
        EnumMap<Planet, Rasi> enumMap3 = this.boyPlanetaryInfo.getPlanetRasi();
        EnumMap<Planet, Rasi> enumMap4 = this.girlPlanetaryInfo.getPlanetRasi();
        this.boyDosha = new EnumMap(Planet.class);
        this.girlDosha = new EnumMap(Planet.class);
        this.boyDosha.put(Planet.Mars, this.calcMarsDosha(enumMap.get((Object)Planet.Mars), enumMap3.get((Object)Planet.Mars)));
        this.boyDosha.put(Planet.Sun, this.calcSunDosha(enumMap.get((Object)Planet.Sun), enumMap3.get((Object)Planet.Sun)));
        this.boyDosha.put(Planet.Saturn, this.calcSatDosha(enumMap.get((Object)Planet.Saturn), enumMap3.get((Object)Planet.Saturn)));
        this.boyDosha.put(Planet.Ra_Ke, this.calcRahuKetuDosha(enumMap.get((Object)Planet.Rahu), enumMap.get((Object)Planet.Ketu), enumMap3.get((Object)Planet.Rahu), enumMap3.get((Object)Planet.Ketu)));
        this.girlDosha.put(Planet.Mars, this.calcMarsDosha(enumMap2.get((Object)Planet.Mars), enumMap4.get((Object)Planet.Mars)));
        this.girlDosha.put(Planet.Sun, this.calcSunDosha(enumMap2.get((Object)Planet.Sun), enumMap4.get((Object)Planet.Sun)));
        this.girlDosha.put(Planet.Saturn, this.calcSatDosha(enumMap2.get((Object)Planet.Saturn), enumMap4.get((Object)Planet.Saturn)));
        this.girlDosha.put(Planet.Ra_Ke, this.calcRahuKetuDosha(enumMap2.get((Object)Planet.Rahu), enumMap2.get((Object)Planet.Ketu), enumMap4.get((Object)Planet.Rahu), enumMap4.get((Object)Planet.Ketu)));
        for (Double d : this.boyDosha.values()) {
            this.bDoshaTotal += d.doubleValue();
        }
        for (Double d : this.girlDosha.values()) {
            this.gDoshaTotal += d.doubleValue();
        }
    }

    private double calcMarsDosha(int n, Rasi rasi) {
        double d = 0.0;
        if (n == 7 || n == 8 || n == 2 || n == 4 || n == 12) {
            switch (rasi) {
                case Mesha: 
                case Vrichika: {
                    d = 60.0;
                    break;
                }
                case Vrishabha: 
                case Thula: 
                case Kumbha: {
                    d = 80.0;
                    break;
                }
                case Mithuna: 
                case Kanya: {
                    d = 90.0;
                    break;
                }
                case Kataka: {
                    d = 100.0;
                    break;
                }
                case Simha: 
                case Dhanus: 
                case Meena: {
                    d = 70.0;
                    break;
                }
                case Makara: {
                    d = 50.0;
                }
            }
            if (n == 2 || n == 4 || n == 12) {
                d /= 2.0;
            }
        } else {
            d = 0.0;
        }
        return d;
    }

    private double calcSunDosha(int n, Rasi rasi) {
        double d = 0.0;
        if (n == 7 || n == 8 || n == 2 || n == 4 || n == 12) {
            switch (rasi) {
                case Vrichika: 
                case Dhanus: 
                case Meena: {
                    d = 35.0;
                    break;
                }
                case Vrishabha: 
                case Kumbha: 
                case Makara: {
                    d = 45.0;
                    break;
                }
                case Mesha: {
                    d = 25.0;
                    break;
                }
                case Thula: {
                    d = 50.0;
                    break;
                }
                case Mithuna: 
                case Kanya: 
                case Kataka: {
                    d = 40.0;
                    break;
                }
                case Simha: {
                    d = 30.0;
                }
            }
            if (n == 2 || n == 4 || n == 12) {
                d /= 2.0;
            }
        } else {
            d = 0.0;
        }
        return d;
    }

    private double calcSatDosha(int n, Rasi rasi) {
        double d = 0.0;
        if (n == 7 || n == 8 || n == 2 || n == 4 || n == 12) {
            switch (rasi) {
                case Vrishabha: 
                case Mithuna: 
                case Kanya: {
                    d = 52.5;
                    break;
                }
                case Vrichika: 
                case Kataka: 
                case Simha: {
                    d = 67.5;
                    break;
                }
                case Mesha: {
                    d = 75.0;
                    break;
                }
                case Thula: {
                    d = 37.5;
                    break;
                }
                case Dhanus: 
                case Meena: {
                    d = 60.0;
                    break;
                }
                case Kumbha: 
                case Makara: {
                    d = 45.0;
                }
            }
            if (n == 2 || n == 4 || n == 12) {
                d /= 2.0;
            }
        } else {
            d = 0.0;
        }
        return d;
    }

    private double calcRahuKetuDosha(int n, int n2, Rasi rasi, Rasi rasi2) {
        double d = 0.0;
        double d2 = 0.0;
        if (n == 7 || n == 8 || n == 2 || n == 4 || n == 12) {
            switch (rasi) {
                case Mesha: 
                case Kumbha: 
                case Kataka: 
                case Simha: {
                    d = 67.5;
                    break;
                }
                case Thula: 
                case Mithuna: 
                case Kanya: 
                case Dhanus: 
                case Meena: 
                case Makara: {
                    d = 52.5;
                    break;
                }
                case Vrishabha: {
                    d = 75.0;
                    break;
                }
                case Vrichika: {
                    d = 37.5;
                }
            }
            if (n == 2 || n == 4 || n == 12) {
                d /= 2.0;
            }
        }
        if (n2 == 7 || n2 == 8 || n2 == 2 || n2 == 4 || n2 == 12) {
            switch (rasi2) {
                case Mesha: 
                case Kumbha: 
                case Kataka: 
                case Simha: {
                    d2 = 67.5;
                    break;
                }
                case Thula: 
                case Mithuna: 
                case Kanya: 
                case Dhanus: 
                case Meena: 
                case Makara: {
                    d2 = 52.5;
                    break;
                }
                case Vrishabha: {
                    d2 = 75.0;
                    break;
                }
                case Vrichika: {
                    d2 = 37.5;
                }
            }
            if (n2 == 2 || n2 == 4 || n2 == 12) {
                d2 /= 2.0;
            }
        }
        return d + d2;
    }

    private void calcBeejaKshetra() {
        EnumMap<Planet, Double> enumMap = this.boyPlanetaryInfo.getPlanetPosition();
        EnumMap<Planet, Double> enumMap2 = this.girlPlanetaryInfo.getPlanetPosition();
        double d = enumMap.get((Object)Planet.Sun) + enumMap.get((Object)Planet.Venus) + enumMap.get((Object)Planet.Jupiter);
        double d2 = enumMap2.get((Object)Planet.Moon) + enumMap2.get((Object)Planet.Mars) + enumMap2.get((Object)Planet.Jupiter);
        this.beejaRasi = Rasi.ofDeg(d);
        this.beejaPos = d % 30.0;
        this.kshetraRasi = Rasi.ofDeg(d2);
        this.kshetraPos = d2 % 30.0;
    }

    private Rasi boyRasi() {
        return Rasi.ofIndex(this.boyRasi);
    }

    private Rasi girlRasi() {
        return Rasi.ofIndex(this.girlRasi);
    }

    private Nakshathra boyNak() {
        return Nakshathra.ofIndex(this.boyNak);
    }

    private Nakshathra girlNak() {
        return Nakshathra.ofIndex(this.girlNak);
    }

    public EnumMap<Kuta, Integer> getKutas() {
        return this.kutas;
    }

    public PlanetaryInfo getBoyPlanetaryInfo() {
        return this.boyPlanetaryInfo;
    }

    public PlanetaryInfo getGirlPlanetaryInfo() {
        return this.girlPlanetaryInfo;
    }

    public BirthData getBoyBirthData() {
        return this.boyBirthData;
    }

    public BirthData getGirlBirthData() {
        return this.girlBirthData;
    }

    public String getBoyName() {
        return this.boyName;
    }

    public String getGirlName() {
        return this.girlName;
    }

    public Rasi getBoyRasi() {
        return Rasi.ofIndex(this.boyRasi);
    }

    public Rasi getGirlRasi() {
        return Rasi.ofIndex(this.girlRasi);
    }

    public Nakshathra getBoyNak() {
        return Nakshathra.ofIndex(this.boyNak);
    }

    public Nakshathra getGirlNak() {
        return Nakshathra.ofIndex(this.girlNak);
    }

    public TableData<? extends TableRowData> getKutaTableData() {
        if (this.kutaTableData == null) {
            TableData<TableRowData> tableData = TableDataFactory.getTableData(this.constructKutaRows(), Kuta.class);
            TableData<TableRowData> tableData2 = TableDataFactory.getTableData(this.constructTotalRow());
            this.kutaTableData = TableDataFactory.getTableData(tableData, tableData2);
        }
        return this.kutaTableData;
    }

    public boolean hasHoroscope() {
        return this.hasHoroscope;
    }

    private void constructColumnMetaData() {
        kutaTableColumnMetaData = new DefaultColumnMetaData(new AstrosoftTableColumn[]{AstrosoftTableColumn.Kuta, AstrosoftTableColumn.KutaGained, AstrosoftTableColumn.MaxKuta}){

            @Override
            public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
                if (astrosoftTableColumn == AstrosoftTableColumn.Kuta) {
                    return Kuta.class;
                }
                return Number.class;
            }
        };
        kutaTableColumnMetaData.localizeColumns();
        doshaTableColumnMetaData = new DefaultColumnMetaData(new AstrosoftTableColumn[]{AstrosoftTableColumn.Dosha, AstrosoftTableColumn.Boy, AstrosoftTableColumn.Girl}){

            @Override
            public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
                if (astrosoftTableColumn == AstrosoftTableColumn.Dosha) {
                    return Planet.class;
                }
                return Number.class;
            }
        };
        doshaTableColumnMetaData.localizeColumns();
        infoTableColumnMetaData = new DefaultColumnMetaData(AstrosoftTableColumn.Key, AstrosoftTableColumn.Value, AstrosoftTableColumn.Beeja, AstrosoftTableColumn.Kshetra);
        infoTableColumnMetaData.setHiddenColumnCount(2);
        infoTableColumnMetaData.localizeColumns();
    }

    private EnumMap<Kuta, TableRowData> constructKutaRows() {
        EnumMap<Kuta, TableRowData> enumMap = new EnumMap<Kuta, TableRowData>(Kuta.class);
        MapTableRowHelper mapTableRowHelper = new MapTableRowHelper(kutaTableColumnMetaData);
        for (Kuta kuta : Kuta.values()) {
            enumMap.put(kuta, mapTableRowHelper.createRow(new Object[]{kuta, this.kutas.get((Object)kuta), kuta.maxValue()}));
        }
        return enumMap;
    }

    private List<TableRowData> constructTotalRow() {
        MapTableRow mapTableRow = new MapTableRow();
        mapTableRow.addColumn(AstrosoftTableColumn.Kuta, (Object)DisplayStrings.TOTAL_STR);
        mapTableRow.addColumn(AstrosoftTableColumn.KutaGained, this.totalKutaGained);
        mapTableRow.addColumn(AstrosoftTableColumn.MaxKuta, Kuta.totalValue());
        ArrayList<TableRowData> arrayList = new ArrayList<TableRowData>();
        arrayList.add(mapTableRow);
        return arrayList;
    }

    public static ColumnMetaData getKutaTableColumnMetaData() {
        return kutaTableColumnMetaData;
    }

    public TableData<? extends TableRowData> getBoyInfo() {
        MapTableRowHelper mapTableRowHelper = new MapTableRowHelper(AstrosoftTableColumn.Key, AstrosoftTableColumn.Value, AstrosoftTableColumn.Beeja);
        if (this.boyInfo == null) {
            ArrayList<MapTableRow> arrayList = new ArrayList<MapTableRow>();
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.BOY_STR, this.boyName}));
            if (this.hasHoroscope) {
                arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.DOB_STR, this.boyBirthData.birthDayString()}));
                arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.TOB_STR, AstroUtil.timeFormat(this.boyBirthData.birthTime(), true)}));
                arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.PLACE_STR, this.boyBirthData.place()}));
            }
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.NAK_STR, this.boyNak()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.RASI_STR, this.boyRasi()}));
            if (this.hasHoroscope) {
                arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.CURR_PD_STR, this.bCurPeriod}));
                arrayList.add(mapTableRowHelper.createRow(new Object[]{AstrosoftTableColumn.Beeja, this.beejaRasi, this.beejaPos}));
            }
            this.boyInfo = TableDataFactory.getTableData(arrayList);
        }
        return this.boyInfo;
    }

    public TableData<? extends TableRowData> getGirlInfo() {
        MapTableRowHelper mapTableRowHelper = new MapTableRowHelper(AstrosoftTableColumn.Key, AstrosoftTableColumn.Value, AstrosoftTableColumn.Kshetra);
        if (this.girlInfo == null) {
            ArrayList<MapTableRow> arrayList = new ArrayList<MapTableRow>();
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.GIRL_STR, this.girlName}));
            if (this.hasHoroscope) {
                arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.DOB_STR, this.girlBirthData.birthDayString()}));
                arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.TOB_STR, AstroUtil.timeFormat(this.girlBirthData.birthTime(), true)}));
                arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.PLACE_STR, this.girlBirthData.place()}));
            }
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.NAK_STR, this.girlNak()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.RASI_STR, this.girlRasi()}));
            if (this.hasHoroscope) {
                arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.CURR_PD_STR, this.gCurPeriod}));
                arrayList.add(mapTableRowHelper.createRow(new Object[]{AstrosoftTableColumn.Kshetra, this.kshetraRasi, this.kshetraPos}));
            }
            this.girlInfo = TableDataFactory.getTableData(arrayList);
        }
        return this.girlInfo;
    }

    public static ColumnMetaData getInfoTableColumnMetaData() {
        return infoTableColumnMetaData;
    }

    public TableData<? extends TableRowData> getDoshaTableData() {
        MapTableRowHelper mapTableRowHelper = new MapTableRowHelper(doshaTableColumnMetaData);
        if (this.doshaTableData == null) {
            ArrayList<MapTableRow> arrayList = new ArrayList<MapTableRow>();
            for (Planet planet : Planet.doshaPlanets()) {
                arrayList.add(mapTableRowHelper.createRow(new Object[]{planet, this.boyDosha.get((Object)planet), this.girlDosha.get((Object)planet)}));
            }
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.TOTAL_STR, this.bDoshaTotal, this.gDoshaTotal}));
            this.doshaTableData = TableDataFactory.getTableData(arrayList);
        }
        return this.doshaTableData;
    }

    public static ColumnMetaData getDoshaTableColumnMetaData() {
        return doshaTableColumnMetaData;
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }

    public String getTitle() {
        return "Compactibility Report of " + this.boyName + " and " + this.girlName;
    }

    public String createDocumentName() {
        return AstroSoft.getPreferences().getAstrosoftFilesDir() + this.boyName + "_" + this.girlName + "__Compactibility.pdf";
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < 12; ++i) {
            int n;
            for (int j = n = i / 4 + i * 2; j < n + 3; ++j) {
                System.out.print((Object)((Object)Nakshathra.ofIndex(j)) + " , ");
                if (Rasi.ofIndex(i).equals((Object)Rasi.Kataka) && Nakshathra.ofIndex(j).equals((Object)Nakshathra.Ayilyam)) {
                    for (int k = 0; k < 12; ++k) {
                        int n2;
                        for (int i2 = n2 = k / 4 + k * 2; i2 < n2 + 3; ++i2) {
                            Compactibility compactibility = new Compactibility(null, null, Nakshathra.ofIndex(j), Nakshathra.ofIndex(i2), Rasi.ofIndex(i), Rasi.ofIndex(k));
                            System.out.print(compactibility.totalKutaGained + " , ");
                        }
                    }
                }
                System.out.println();
            }
        }
    }

    private static enum KutaFile {
        RasiKuta,
        YoniKuta,
        NadiKuta;


        public String file() {
            return this.name() + ".txt";
        }
    }
}

