/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Month;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.SwissHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import swisseph.SweDate;

public class Ephemeris
implements PreferenceChangeListener {
    private static AstrosoftPref preferences = AstroSoft.getPreferences();
    private Calendar cal;
    private List<EnumMap<Planet, EphData>> ephemeris;
    private Mode mode;
    private SwissHelper swissHelper;

    public Ephemeris(int n, int n2, Mode mode) {
        this(new GregorianCalendar(n2, n, 1), mode);
    }

    public Ephemeris(int n, int n2) {
        this(n2, n, Mode.Daily);
    }

    public Ephemeris(Calendar calendar, Mode mode) {
        this.cal = calendar;
        this.mode = mode;
        calendar.set(5, 1);
        if (mode.isMonthly()) {
            calendar.set(2, 0);
        }
        this.calcEphemeris();
    }

    public void setAyanamsa(Ayanamsa ayanamsa) {
        this.swissHelper.setAyanamsa(ayanamsa);
        this.calcEphemeris();
    }

    private void calcEphemeris() {
        this.ephemeris = new ArrayList<EnumMap<Planet, EphData>>();
        double d = preferences.getPlace().timeZone();
        double d2 = preferences.getEphCalcTime() - d;
        this.swissHelper = new SwissHelper();
        Calendar calendar = AstroUtil.getCalendar();
        calendar.setTime(this.cal.getTime());
        while (calendar.get(this.mode.parentCalField) == this.cal.get(this.mode.parentCalField)) {
            SweDate sweDate = new SweDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), d2);
            this.swissHelper.setSweDate(sweDate);
            this.ephemeris.add(this.swissHelper.getEphData());
            calendar.add(this.mode.incCalField, 1);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public Calendar getDate() {
        return this.cal;
    }

    public Table getEphemerisTable() {
        List<AstrosoftTableColumn> list = Planet.toTableColumn(Planet.allPlanets());
        if (this.mode.isDaily()) {
            list.add(0, AstrosoftTableColumn.Date);
        } else {
            list.add(0, AstrosoftTableColumn.Month);
        }
        final DefaultColumnMetaData defaultColumnMetaData = new DefaultColumnMetaData(list){

            @Override
            public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
                if (astrosoftTableColumn == AstrosoftTableColumn.Date) {
                    return Integer.class;
                }
                if (astrosoftTableColumn == AstrosoftTableColumn.Month) {
                    return String.class;
                }
                return EphData.class;
            }
        };
        defaultColumnMetaData.localizeColumns();
        Table table = new Table(){

            public TableData<TableRowData> getTableData() {
                return new TableData<TableRowData>(){
                    EnumMap<Planet, EphData> row;

                    @Override
                    public TableRowData getRow(final int n) {
                        this.row = (EnumMap)Ephemeris.this.ephemeris.get(n);
                        return new TableRowData(){

                            @Override
                            public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
                                if (astrosoftTableColumn == AstrosoftTableColumn.Date) {
                                    return n + 1;
                                }
                                if (astrosoftTableColumn == AstrosoftTableColumn.Month) {
                                    return Month.ofIndex(n).toString(DisplayFormat.FULL_NAME);
                                }
                                return row.get((Object)Planet.valueOf(astrosoftTableColumn.name()));
                            }
                        };
                    }

                    @Override
                    public int getRowCount() {
                        return Ephemeris.this.ephemeris.size();
                    }
                };
            }

            @Override
            public ColumnMetaData getColumnMetaData() {
                return defaultColumnMetaData;
            }
        };
        return table;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(AstrosoftPref.Preference.Ayanamsa.name())) {
            this.setAyanamsa(Enum.valueOf(Ayanamsa.class, preferenceChangeEvent.getNewValue()));
        } else if (preferenceChangeEvent.getKey().equals(AstrosoftPref.Preference.EphCalcTime.name())) {
            this.calcEphemeris();
        } else if (preferenceChangeEvent.getKey().equals(AstrosoftPref.Preference.Place.name())) {
            this.calcEphemeris();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (EnumMap<Planet, EphData> enumMap : this.ephemeris) {
            for (Planet planet : enumMap.keySet()) {
                stringBuilder.append(enumMap.get((Object)planet) + "\t");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        Ephemeris ephemeris = new Ephemeris(1, 2003, Mode.Monthly);
        System.out.println(ephemeris);
    }

    public static class EphData {
        private double position;
        private Rasi house;
        private boolean isReverse;

        public EphData(double d, Boolean bl) {
            this.position = d % 30.0;
            this.house = Rasi.ofDeg(d);
            this.isReverse = bl != null ? bl : false;
        }

        public double getPosition() {
            return this.position;
        }

        public Rasi getHouse() {
            return this.house;
        }

        public boolean isReverse() {
            return this.isReverse;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(AstroUtil.todegmin(this.position, " " + this.house.toString(DisplayFormat.SYMBOL) + " "));
            if (this.isReverse) {
                stringBuilder.append((Object)DisplayStrings.RETRO_SYM);
            }
            return stringBuilder.toString();
        }
    }

    public static enum Mode {
        Daily(2, 5),
        Monthly(1, 2);

        private int incCalField;
        private int parentCalField;

        private Mode(int n2, int n3) {
            this.parentCalField = n2;
            this.incCalField = n3;
        }

        public int incCalField() {
            return this.incCalField;
        }

        public int parentCalField() {
            return this.parentCalField;
        }

        public boolean isDaily() {
            return this == Daily;
        }

        public boolean isMonthly() {
            return this == Monthly;
        }
    }
}

