/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.beans.BirthData;
import app.astrosoft.beans.HousePosition;
import app.astrosoft.beans.NakshathraPada;
import app.astrosoft.beans.Place;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Paksha;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Sex;
import app.astrosoft.consts.Thithi;
import app.astrosoft.consts.Varga;
import app.astrosoft.consts.Yoga;
import app.astrosoft.core.Ashtavarga;
import app.astrosoft.core.ShadBala;
import app.astrosoft.core.VimDasa;
import app.astrosoft.core.Vimshottari;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.export.XMLHelper;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.DefaultTable;
import app.astrosoft.ui.table.MapTableRow;
import app.astrosoft.ui.table.MapTableRowHelper;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.SwissHelper;
import app.astrosoft.xps.yoga.YogaFinder;
import app.astrosoft.xps.yoga.YogaResults;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.w3c.dom.Document;
import swisseph.SweDate;

public class Horoscope
implements PreferenceChangeListener,
Exportable {
    private static final Logger log = Logger.getLogger(Horoscope.class.getName());
    private BirthData birthData;
    private SwissHelper swissHelper;
    private double ayanamsa;
    private double sunrise;
    private double sunset;
    private HousePosition housePosition;
    private PlanetaryInfo planetaryInfo;
    private Vimshottari vimDasa;
    private Ashtavarga ashtaVarga;
    private Thithi thithi;
    private Paksha pak;
    private Yoga yoga;
    private ShadBala shadBala;
    private TableData<MapTableRow> infoTableData;
    private static DefaultColumnMetaData infoTableColumnMetaData;
    private String title;
    private boolean isBirthAtDay;
    private YogaResults yogaCombinations;

    public Horoscope(String string, int n, int n2, int n3, int n4, int n5, Place place) {
        this(new BirthData(string, n, n2, n3, n4, n5, 0, place));
    }

    public Horoscope(String string, int n, int n2, int n3, int n4, int n5, double d, double d2, double d3, String string2) {
        this(string, n, n2, n3, n4, n5, new Place(string2, d2, d, d3));
    }

    public Horoscope(BirthData birthData) {
        this.birthData = birthData;
        this.swissHelper = new SwissHelper(birthData.birthSD());
        AstroSoft.getPreferences().addPreferenceChangeListener(this);
        this.calculate();
    }

    public static Horoscope createFromFile(String string) {
        Horoscope horoscope = null;
        try {
            horoscope = new Horoscope(BirthData.valueOfXMLNode(XMLHelper.parseXML(string).getChildNodes().item(0)));
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(nullPointerException);
        }
        if (horoscope != null) {
            return horoscope;
        }
        try {
            if (string == null) {
                return null;
            }
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine();
            int n = Integer.parseInt(bufferedReader.readLine());
            int n2 = Integer.parseInt(bufferedReader.readLine());
            int n3 = Integer.parseInt(bufferedReader.readLine());
            int n4 = Integer.parseInt(bufferedReader.readLine());
            int n5 = Integer.parseInt(bufferedReader.readLine());
            double d = Double.parseDouble(bufferedReader.readLine());
            double d2 = Double.parseDouble(bufferedReader.readLine());
            double d3 = Double.parseDouble(bufferedReader.readLine());
            String string3 = bufferedReader.readLine();
            Place place = new Place(string3, d2, d, d3);
            fileInputStream.close();
            horoscope = new Horoscope(string2, n, n2, n3, n4, n5, place);
            horoscope.saveToFile(string);
        }
        catch (Exception exception) {
            return null;
        }
        return horoscope;
    }

    public void saveToFile(String string) {
        Document document = XMLHelper.createDOM();
        document.appendChild(this.birthData.toXMLElement(document));
        XMLHelper.saveXML(document, string);
    }

    public void calculate() {
        this.calcPlanetaryInfo();
        this.calcDetails();
        this.infoTableData = null;
    }

    public void calculateAll() {
        this.calculate();
        this.calcDashaBhukthis();
        this.calcAshtaVarga();
        this.calcShadBala();
    }

    public void setAyanamsa(Ayanamsa ayanamsa) {
        this.swissHelper.setAyanamsa(ayanamsa);
        this.calculateAll();
    }

    private void calcSunRiseSet() {
        this.sunrise = AstroUtil.getSunRise(this.birthData.year(), this.birthData.month(), this.birthData.date(), this.birthData.longitude(), this.birthData.latitude(), this.birthData.timeZone());
        this.sunset = AstroUtil.getSunSet(this.birthData.year(), this.birthData.month(), this.birthData.date(), this.birthData.longitude(), this.birthData.latitude(), this.birthData.timeZone());
        this.isBirthAtDay = this.birthData.birthTime() > this.sunrise && this.birthData.birthTime() < this.sunset;
    }

    public void calcHousePositions() {
        this.housePosition = this.swissHelper.calcHousePosition(this.birthData.longitude(), this.birthData.latitude());
    }

    public void calcPlanetaryInfo() {
        this.calcHousePositions();
        EnumMap<Planet, Double> enumMap = this.swissHelper.getPlanetaryPosition();
        this.planetaryInfo = new PlanetaryInfo(enumMap, this.swissHelper.getPlanetDirection(), this.housePosition);
        this.ayanamsa = this.swissHelper.getAyanamsa();
    }

    public void calcDashaBhukthis() {
        this.vimDasa = new Vimshottari(this.getPlanetaryPosition(Planet.Moon), this.birthData.birthDay());
    }

    public void calcAshtaVarga() {
        this.ashtaVarga = new Ashtavarga(this.getDivChart(Varga.Rasi));
    }

    private void calcDetails() {
        this.calcSunRiseSet();
        this.thithi = Thithi.ofDeg(this.getPlanetaryPosition(Planet.Sun), this.getPlanetaryPosition(Planet.Moon));
        this.pak = Paksha.ofDeg(this.getPlanetaryPosition(Planet.Sun), this.getPlanetaryPosition(Planet.Moon));
        this.yoga = Yoga.ofDeg(this.getPlanetaryPosition(Planet.Sun), this.getPlanetaryPosition(Planet.Moon));
    }

    private void calcShadBala() {
        if (this.birthData.year() < 1900) {
            log.warning("Year should be less than 1900");
        } else {
            this.shadBala = new ShadBala(this.planetaryInfo, this.housePosition, this.birthData, this.ayanamsa, this.sunrise, this.sunset, this.getPaksha());
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(AstrosoftPref.Preference.Language.name())) {
            this.languageChanged();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        stringBuilder.append("Bhava\n");
        stringBuilder.append(this.housePosition);
        stringBuilder.append("\n");
        stringBuilder.append("Planetary Info\n");
        stringBuilder.append(this.planetaryInfo);
        stringBuilder.append("\n");
        stringBuilder.append("Thithi " + (Object)((Object)this.thithi) + " Paksha " + (Object)((Object)this.pak));
        stringBuilder.append("\n");
        stringBuilder.append("AshtaVarga \n");
        stringBuilder.append(this.ashtaVarga);
        stringBuilder.append("\n");
        stringBuilder.append("ShadBala \n");
        stringBuilder.append(this.shadBala);
        stringBuilder.append("\n");
        stringBuilder.append("Dasas\n");
        boolean bl2 = false;
        boolean bl3 = false;
        stringBuilder.append(this.vimDasa);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public HousePosition getHousePosition() {
        return this.housePosition;
    }

    public BirthData getBirthData() {
        return this.birthData;
    }

    public SweDate getBirthSD() {
        return this.birthData.birthSD();
    }

    public String getPersonName() {
        return this.birthData.name();
    }

    public Rasi getAscendant() {
        return this.housePosition.getAscendant();
    }

    public Rasi getRasi() {
        return this.planetaryInfo.getPlanetRasi().get((Object)Planet.Moon);
    }

    public NakshathraPada getNakshathra() {
        return this.planetaryInfo.getPlanetNakshathra().get((Object)Planet.Moon);
    }

    public PlanetaryInfo getPlanetaryInfo() {
        return this.planetaryInfo;
    }

    public EnumMap<Planet, Double> getPlanetaryPosition() {
        return this.planetaryInfo.getPlanetPosition();
    }

    public Double getPlanetaryPosition(Planet planet) {
        return this.planetaryInfo.getPlanetPosition(planet);
    }

    public EnumMap<Planet, Integer> getPlanetaryLocation() {
        return this.planetaryInfo.getPlanetLocation();
    }

    public int getPlanetaryLocation(Planet planet) {
        return this.planetaryInfo.getPlanetLocation().get((Object)planet);
    }

    public EnumMap<Planet, Rasi> getPlanetRasis() {
        return this.planetaryInfo.getPlanetRasi();
    }

    public EnumMap<Planet, Boolean> getPlanetDirection() {
        return this.planetaryInfo.getPlanetDirection();
    }

    public EnumMap<Varga, EnumMap<Planet, Integer>> getDivChart() {
        return this.planetaryInfo.getDivChart();
    }

    public EnumMap<Planet, Integer> getDivChart(Varga varga) {
        return this.planetaryInfo.getDivChart(varga);
    }

    public Thithi getThithi() {
        return this.thithi;
    }

    public Paksha getPaksha() {
        return this.pak;
    }

    public Yoga getYoga() {
        return this.yoga;
    }

    public double getAyanamsa() {
        return this.ayanamsa;
    }

    public double getSunrise() {
        return this.sunrise;
    }

    public double getSunset() {
        return this.sunset;
    }

    public boolean isBirthAtDay() {
        return this.isBirthAtDay;
    }

    public Sex getPersonSex() {
        return this.birthData.sex();
    }

    public YogaResults getYogaCombinations() {
        if (this.yogaCombinations == null) {
            this.yogaCombinations = YogaFinder.getInstance().findYogas(this);
        }
        return this.yogaCombinations;
    }

    public ShadBala getShadBala() {
        if (this.shadBala == null) {
            this.calcShadBala();
        }
        return this.shadBala;
    }

    public Ashtavarga getAshtaVarga() {
        if (this.ashtaVarga == null) {
            this.calcAshtaVarga();
        }
        return this.ashtaVarga;
    }

    public String getDasaBal() {
        return this.getVimshottariDasa().getBalance();
    }

    public Vimshottari getVimshottariDasa() {
        if (this.vimDasa == null) {
            this.calcDashaBhukthis();
        }
        return this.vimDasa;
    }

    public String getCurrentDasa() {
        VimDasa vimDasa = (VimDasa)this.getVimshottariDasa().getCurrent();
        if (vimDasa != null) {
            return vimDasa.fullDasa();
        }
        return "No";
    }

    public TableData<MapTableRow> getInfoTableData() {
        if (this.infoTableData == null) {
            ArrayList<MapTableRow> arrayList = new ArrayList<MapTableRow>();
            MapTableRowHelper mapTableRowHelper = new MapTableRowHelper(Horoscope.getInfoTableColumnMetaData());
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.NAME_STR, this.birthData.name()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.DOB_STR, this.birthData.birthDayString()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.TOB_STR, AstroUtil.timeFormat(this.birthData.birthTime(), true)}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.PLACE_STR, this.birthData.place()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.SID_TIME_STR, AstroUtil.dms(this.getHousePosition().getSiderealTime())}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.SUNRISE_SET_STR, AstroUtil.timeFormat(this.getSunrise()) + "/" + AstroUtil.timeFormat(this.getSunset())}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.NAK_STR, this.getNakshathra()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.RASI_STR, this.getRasi()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.LANGA_STR, this.getAscendant()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.YOGA_STR, this.getYoga()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.THITHI_STR, this.getThithi()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.AYANAMSA_STR, AstroUtil.dms(this.getAyanamsa())}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.CURR_PD_STR, this.getCurrentDasa()}));
            arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.DASA_STR, this.getDasaBal()}));
            this.infoTableData = TableDataFactory.getTableData(arrayList);
        }
        return this.infoTableData;
    }

    public static DefaultColumnMetaData getInfoTableColumnMetaData() {
        if (infoTableColumnMetaData == null) {
            infoTableColumnMetaData = new DefaultColumnMetaData(AstrosoftTableColumn.Key, AstrosoftTableColumn.Value);
            infoTableColumnMetaData.localizeColumns();
        }
        return infoTableColumnMetaData;
    }

    public Table getHoroscopeInfo() {
        return new DefaultTable(this.getInfoTableData(), Horoscope.getInfoTableColumnMetaData());
    }

    public String getTitle() {
        if (this.title == null) {
            StringBuilder stringBuilder = new StringBuilder("Horoscope of ");
            stringBuilder.append(this.birthData.name());
            stringBuilder.append(" born on ");
            stringBuilder.append(this.birthData.birthDayString());
            stringBuilder.append(" " + AstroUtil.timeFormat(this.birthData.birthTime()));
            stringBuilder.append(" at ");
            stringBuilder.append(this.birthData.place());
            this.title = stringBuilder.toString();
        }
        return this.title;
    }

    public static void main(String[] stringArray) {
        Horoscope.runTests();
    }

    public void languageChanged() {
        log.entering("Horoscope", "languageChanged()");
        this.infoTableData = null;
        this.calcDashaBhukthis();
    }

    public static void runTests() {
        AstroSoft.getPreferences().setAyanamsa(Ayanamsa.LAHARI);
        Horoscope horoscope = new Horoscope("Raja", 11, 12, 1980, 1, 44, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        System.out.println("----------------------Raja----------------------");
        System.out.println(horoscope.getPlanetaryInfo());
        Horoscope horoscope2 = new Horoscope("Elango", 17, 4, 1957, 7, 10, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        System.out.println("----------------------Elango----------------------");
        System.out.println(horoscope2.getPlanetaryInfo());
        Horoscope horoscope3 = new Horoscope("Mani", 10, 8, 1960, 5, 30, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        System.out.println("----------------------Mani----------------------");
        System.out.println(horoscope3.getPlanetaryInfo());
        Horoscope horoscope4 = new Horoscope("Suba", 31, 3, 1988, 18, 10, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        System.out.println("----------------------Suba----------------------");
        System.out.println(horoscope4.getPlanetaryInfo());
        horoscope = new Horoscope("Viji", 7, 8, 1982, 11, 45, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        System.out.println("----------------------Viji----------------------");
        System.out.println(horoscope.getPlanetaryInfo());
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }

    public String createDocumentName() {
        return AstroSoft.getPreferences().getAstrosoftFilesDir() + this.birthData.name() + "_Horoscope.pdf";
    }
}

