/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.beans.Interval;
import app.astrosoft.beans.MuhurthaBean;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.MuhurthaRank;
import app.astrosoft.consts.Nakshathra;
import app.astrosoft.consts.Rasi;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.MuhurthaHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.List;
import swisseph.SweDate;

public class Muhurtha {
    private double mDate;
    private double startJulDay;
    private double endJulDay;
    private Rasi mRasi;
    private Nakshathra mNak;
    private int incPeriod = 2;
    private boolean filterByRasi = false;
    private boolean filterByMuhurthaNaks = false;
    private EnumMap<MuhurthaRank, List<Interval>> favLogitudes;
    private List<Interval> transitPeriods;

    public Muhurtha(Calendar calendar, Rasi rasi, Nakshathra nakshathra) {
        calendar.add(5, -2);
        double d = AstroUtil.decimal(calendar.get(10), calendar.get(12), calendar.get(13));
        SweDate sweDate = new SweDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), d);
        this.startJulDay = this.mDate = sweDate.getJulDay();
        this.mRasi = rasi;
        this.mNak = nakshathra;
    }

    public Muhurtha(Calendar calendar, Rasi rasi, Nakshathra nakshathra, boolean bl, boolean bl2) {
        this(calendar, rasi, nakshathra);
        this.filterByRasi = bl;
        this.filterByMuhurthaNaks = bl2;
    }

    public Muhurtha(Calendar calendar, Rasi rasi, Nakshathra nakshathra, boolean bl, boolean bl2, int n) {
        this(calendar, rasi, nakshathra, bl, bl2);
        this.incPeriod = n;
    }

    public void setIncPeriod(int n) {
        this.incPeriod = n;
    }

    public void calcMuhurtha() {
        this.calcFavLongitudes();
    }

    private List<Interval> calcFavNakLongitudes() {
        int[] nArray;
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        for (int n : nArray = new int[]{1, 3, 5, 7, 8, 10, 12, 14, 16, 17, 19, 21, 23, 25, 26}) {
            arrayList.add(Nakshathra.degFor(this.mNak.absolute(n)));
        }
        return arrayList;
    }

    private List<Interval> calcFavRasiLongitudes() {
        int[] nArray;
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        for (int n : nArray = new int[]{0, 2, 6, 9, 10}) {
            arrayList.add(Rasi.longitudeForRasi(this.mRasi.absolute(n)));
        }
        return arrayList;
    }

    private List<Interval> calcFavMuhurthaLongitudes(MuhurthaRank muhurthaRank) {
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        for (Nakshathra nakshathra : Nakshathra.muhurtaNakshathras(muhurthaRank)) {
            arrayList.add(Nakshathra.degFor(nakshathra));
        }
        return arrayList;
    }

    private void calcFavLongitudes() {
        this.favLogitudes = new EnumMap(MuhurthaRank.class);
        List<Interval> list = this.calcFavNakLongitudes();
        this.favLogitudes.put(MuhurthaRank.VeryGood, list);
        if (this.filterByRasi) {
            this.favLogitudes.put(MuhurthaRank.VeryGood, Interval.intersection(list, this.calcFavRasiLongitudes()));
        }
        List<Interval> list2 = this.favLogitudes.get((Object)MuhurthaRank.VeryGood);
        if (this.filterByMuhurthaNaks) {
            for (MuhurthaRank muhurthaRank : MuhurthaRank.values()) {
                List<Interval> list3 = this.calcFavMuhurthaLongitudes(muhurthaRank);
                this.favLogitudes.put(muhurthaRank, Interval.intersection(list2, list3));
            }
        }
    }

    public TableData<? extends TableRowData> getNextTransitPeriods() {
        MuhurthaHelper muhurthaHelper = new MuhurthaHelper(this.favLogitudes);
        this.endJulDay = AstroUtil.incJulDate(this.startJulDay, 0, this.incPeriod, 0);
        Interval interval = new Interval(this.startJulDay, this.endJulDay);
        List<MuhurthaBean> list = muhurthaHelper.getTransists(interval);
        this.startJulDay = this.endJulDay;
        return TableDataFactory.getTableData(list);
    }

    public void printFavLongitudes() {
        for (MuhurthaRank muhurthaRank : this.favLogitudes.keySet()) {
            System.out.println("************** " + (Object)((Object)muhurthaRank) + " ****************");
            for (Interval interval : this.favLogitudes.get((Object)muhurthaRank)) {
                System.out.println(interval.toString(DisplayFormat.DEG));
            }
            System.out.println("*****************************************");
        }
    }

    public static void main(String[] stringArray) {
        Muhurtha muhurtha = new Muhurtha(new GregorianCalendar(2005, 11, 1), Rasi.Vrishabha, Nakshathra.Rohini, false, true);
        muhurtha.calcMuhurtha();
        muhurtha.printFavLongitudes();
        System.out.println(muhurtha.getNextTransitPeriods());
    }
}

