/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.beans.ChartData;
import app.astrosoft.beans.Place;
import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Karana;
import app.astrosoft.consts.Nakshathra;
import app.astrosoft.consts.Paksha;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Thithi;
import app.astrosoft.consts.Varga;
import app.astrosoft.consts.WeekDay;
import app.astrosoft.consts.Yoga;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.DefaultTable;
import app.astrosoft.ui.table.MapTableRow;
import app.astrosoft.ui.table.MapTableRowHelper;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.SwissHelper;
import app.astrosoft.util.TransitHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import swisseph.SweDate;

public class Panchang {
    private static final AstrosoftPref preferences = AstroSoft.getPreferences();
    private static final double PAN_APPROXIMATION = 0.01;
    private SwissHelper swissHelper;
    private Place place;
    private double moon;
    private double sun;
    private double totalSpeed;
    private double diffSpeed;
    private Calendar cal;
    private WeekDay weekday;
    private double sunrise;
    private double sunset;
    private double panTime;
    private double timeZone;
    private PanEvent nakshathra;
    private PanEvent thithi;
    private PanEvent yoga;
    private KaranaEvent karana;
    private Paksha pak;
    private EnumMap<Planet, Integer> rasi;
    private EnumMap<Planet, Boolean> dir;
    private static DefaultColumnMetaData panchangColumnMetaData;
    public static final int AUS_TIME_ROW = 9;

    public Panchang(Calendar calendar) {
        this.cal = AstroUtil.getCalendar(calendar.getTime());
        this.calcPanchang();
    }

    public Panchang(Date date) {
        this.cal = AstroUtil.getCalendar(date);
        this.calcPanchang();
    }

    private void calcPlanetaryInfo() {
        this.place = preferences.getPlace();
        this.timeZone = (double)this.cal.getTimeZone().getRawOffset() / 3600000.0 + (double)((long)this.cal.get(16) / 3600000L);
        this.place.setTimeZone(this.timeZone);
        this.panTime = preferences.getPanCalcTime() - this.timeZone;
        this.swissHelper = new SwissHelper(new SweDate(this.cal.get(1), this.cal.get(2) + 1, this.cal.get(5), this.panTime));
        EnumMap<Planet, Double> enumMap = this.swissHelper.getPlanetaryPosition();
        this.sun = enumMap.get((Object)Planet.Sun);
        this.moon = enumMap.get((Object)Planet.Moon);
        this.rasi = PlanetaryInfo.positionToRasiNum(enumMap);
        this.rasi.put(Planet.Ascendant, this.swissHelper.getAscendant(this.place.longitude(), this.place.latitude()).ordinal() + 1);
        this.dir = this.swissHelper.getPlanetDirection();
        double d = this.swissHelper.getPlanetSpeed(Planet.Moon);
        double d2 = this.swissHelper.getPlanetSpeed(Planet.Sun);
        this.totalSpeed = d2 + d;
        this.diffSpeed = d - d2;
    }

    private void calcPanchang() {
        this.calcPlanetaryInfo();
        TransitHelper transitHelper = this.swissHelper.getTransitHelper(Planet.Moon);
        Date date = transitHelper.getTransitDate(AstroUtil.nakEndPosition(this.moon), this.swissHelper.getSweDate().getJulDay());
        double d = AstroUtil.dateToTimeDouble(date);
        if ((double)(date.getTime() - this.cal.getTimeInMillis()) / 8.64E7 > 1.0) {
            d += 24.0;
        }
        this.nakshathra = new PanEvent(Nakshathra.ofDeg(this.moon).toString(), d);
        this.thithi = new PanEvent(Thithi.ofDeg(this.sun, this.moon).toString(), this.findThithiEnd(this.sun, this.moon, this.diffSpeed));
        this.yoga = new PanEvent(Yoga.ofDeg(this.sun, this.moon).toString(), this.findYogaEnd((this.sun + this.moon) % 360.0, this.totalSpeed));
        this.karana = this.calcKarana();
        this.pak = Paksha.ofDeg(this.sun, this.moon);
        this.weekday = WeekDay.ofCalendar(this.cal);
        this.sunrise = AstroUtil.getSunRise(this.cal, this.place);
        this.sunset = AstroUtil.getSunSet(this.cal, this.place);
    }

    private KaranaEvent calcKarana() {
        Karana[] karanaArray = Karana.ofDeg(this.sun, this.moon);
        double d = Panchang.getMoonSunDiff(this.sun, this.moon);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 6.0 - d % 6.0;
        double d6 = (d + d5) % 180.0;
        if (d6 % 12.0 == 0.0) {
            d3 = this.thithi.getEnding();
            double d7 = d5 + 6.0;
            d2 = AstroUtil.endTime(this.diffSpeed, d7);
            d4 = d2 + this.timeZone + this.computeCorrection(d + 6.0, d6 + 6.0, d2, 6.0);
        } else {
            d2 = AstroUtil.endTime(this.diffSpeed, d5);
            d3 = d2 + this.timeZone + this.computeCorrection(d, d6, d2, 6.0);
            d4 = this.thithi.getEnding();
        }
        KaranaEvent karanaEvent = new KaranaEvent(karanaArray[0].toString(), d3, karanaArray[1].toString(), d4);
        return karanaEvent;
    }

    private double findYogaEnd(double d, double d2) {
        double d3 = 13.333333333333334 - d % 13.333333333333334;
        double d4 = AstroUtil.endTime(d2, d3);
        return d4 + this.timeZone + this.yogaCorrection(d, d + d3, d4);
    }

    private double yogaCorrection(double d, double d2, double d3) {
        double d4 = 0.0;
        SwissHelper swissHelper = new SwissHelper(new SweDate(this.cal.get(1), this.cal.get(2) + 1, this.cal.get(5), d3));
        EnumMap<Planet, Double> enumMap = swissHelper.getPlanetaryPosition(EnumSet.of(Planet.Sun, Planet.Moon));
        double d5 = enumMap.get((Object)Planet.Moon);
        double d6 = enumMap.get((Object)Planet.Sun);
        double d7 = (d6 + d5) % 360.0;
        double d8 = d2 - d7;
        if (d8 > 13.333333333333334) {
            d8 = 360.0 - d8;
        }
        d4 = AstroUtil.endTime(this.totalSpeed, d8);
        if (Math.abs(d8) > 0.01) {
            d4 += this.yogaCorrection(d7, d2, d3 + d4);
        }
        return d4;
    }

    private double findThithiEnd(double d, double d2, double d3) {
        double d4 = Panchang.getMoonSunDiff(d, d2);
        double d5 = 12.0 - d4 % 12.0;
        double d6 = AstroUtil.endTime(this.diffSpeed, d5);
        return this.timeZone + d6 + this.computeCorrection(Panchang.getMoonSunDiff(d, d2), d4 + d5, d6, 12.0);
    }

    private double computeCorrection(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        SwissHelper swissHelper = new SwissHelper(new SweDate(this.cal.get(1), this.cal.get(2) + 1, this.cal.get(5), d3));
        EnumMap<Planet, Double> enumMap = swissHelper.getPlanetaryPosition(EnumSet.of(Planet.Sun, Planet.Moon));
        double d6 = enumMap.get((Object)Planet.Moon);
        double d7 = enumMap.get((Object)Planet.Sun);
        double d8 = Panchang.getMoonSunDiff(d7, d6);
        double d9 = d2 - d8;
        if (d2 % 180.0 == 0.0 && d9 > d4) {
            d9 -= 180.0;
        }
        d5 = AstroUtil.endTime(this.diffSpeed, d9);
        if (Math.abs(d9) > 0.01) {
            d5 += this.computeCorrection(Panchang.getMoonSunDiff(d7, d6), d2, d3 + d5, d4);
        }
        return d5;
    }

    public String rahuKala() {
        return this.weekday.rahuKala();
    }

    public String yamaKanda() {
        return this.weekday.yamaKanda();
    }

    public String[] auspiciousTime() {
        return this.weekday.auspiciousTime();
    }

    public Calendar getDate() {
        return this.cal;
    }

    private static DefaultColumnMetaData getPanchangColumnMetaData() {
        if (panchangColumnMetaData == null) {
            panchangColumnMetaData = new DefaultColumnMetaData(AstrosoftTableColumn.keyvalCols());
            panchangColumnMetaData.localizeColumns();
        }
        return panchangColumnMetaData;
    }

    public TableData<MapTableRow> getPanchangTableData() {
        ArrayList<MapTableRow> arrayList = new ArrayList<MapTableRow>();
        MapTableRowHelper mapTableRowHelper = new MapTableRowHelper(Panchang.getPanchangColumnMetaData());
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.DATE_STR, AstroUtil.formatDate(this.cal.getTime())}));
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.DAY_STR, this.weekday}));
        arrayList.add(mapTableRowHelper.createRow((Object)((Object)DisplayStrings.NAK_STR) + " ( " + AstrosoftTableColumn.End.toString() + " ) ", this.nakshathra));
        arrayList.add(mapTableRowHelper.createRow((Object)((Object)DisplayStrings.THITHI_STR) + " ( " + AstrosoftTableColumn.End.toString() + " ) ", this.thithi));
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.PAKSHA_STR, this.pak}));
        arrayList.add(mapTableRowHelper.createRow((Object)((Object)DisplayStrings.YOGA_STR) + " ( " + AstrosoftTableColumn.End.toString() + " ) ", this.yoga));
        arrayList.add(mapTableRowHelper.createRow((Object)((Object)DisplayStrings.KARANA_STR) + " ( " + AstrosoftTableColumn.End.toString() + " ) ", this.karana));
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.SUNRISE_STR, AstroUtil.timeFormat(this.sunrise)}));
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.SUNSET_STR, AstroUtil.timeFormat(this.sunset)}));
        String string = Arrays.toString(this.auspiciousTime());
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.AUS_TIME_STR, string.substring(1, string.length() - 1)}));
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.RAHU_KALA_STR, this.rahuKala()}));
        arrayList.add(mapTableRowHelper.createRow(new Object[]{DisplayStrings.YAMA_KANDA_STR, this.yamaKanda()}));
        return TableDataFactory.getTableData(arrayList);
    }

    public Table getPanchangTable() {
        return new DefaultTable(this.getPanchangTableData(), Panchang.getPanchangColumnMetaData());
    }

    public ChartData getPlanetChartData() {
        return new PlanetChartData(Varga.Rasi, this.rasi, this.dir);
    }

    public static double getMoonSunDiff(double d, double d2) {
        double d3 = d2 > d ? d2 - d : d2 + 360.0 - d;
        if (d3 > 180.0) {
            d3 -= 180.0;
        }
        return d3;
    }

    public WeekDay getWeekday() {
        return this.weekday;
    }

    public static void main(String[] stringArray) {
        for (int i = 1; i <= 30; ++i) {
            Panchang panchang = new Panchang(new GregorianCalendar(2006, 9, i, 0, 0));
            System.out.println(panchang);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.cal.getTime() + "\n");
        stringBuilder.append((Object)((Object)this.weekday) + "\n");
        stringBuilder.append(this.nakshathra + "\n");
        stringBuilder.append(this.thithi + "\n");
        stringBuilder.append((Object)((Object)this.pak) + "\n");
        stringBuilder.append(this.yoga + "\n");
        stringBuilder.append(this.karana + "\n");
        stringBuilder.append(AstroUtil.timeFormat(this.sunrise) + " - " + AstroUtil.timeFormat(this.sunset) + "\n");
        return stringBuilder.toString();
    }

    private static class KaranaEvent {
        private PanEvent first;
        private PanEvent second;

        public KaranaEvent(String string, double d, String string2, double d2) {
            this.first = new PanEvent(string, d);
            this.second = new PanEvent(string2, d2);
        }

        public String toString() {
            return this.first + " , " + this.second;
        }
    }

    private static class PanEvent {
        private String event;
        private double ending;

        public PanEvent(String string, double d) {
            this.event = string;
            this.ending = d;
        }

        public double getEnding() {
            return this.ending;
        }

        public String toString() {
            return this.event + " ( " + AstroUtil.todegmin(this.ending, ":") + " ) ";
        }
    }
}

