/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.core.Ephemeris;
import app.astrosoft.core.Panchang;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.util.AstroUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class PanchangList
implements Iterable<Panchang>,
Exportable {
    private Calendar cal;
    private Ephemeris.Mode mode;

    public PanchangList(int n) {
        this(new GregorianCalendar(n, 0, 1), Ephemeris.Mode.Monthly);
    }

    public PanchangList(int n, int n2) {
        this(new GregorianCalendar(n, n2, 1), Ephemeris.Mode.Daily);
    }

    private PanchangList(Calendar calendar, Ephemeris.Mode mode) {
        this.cal = calendar;
        this.mode = mode;
        calendar.set(5, 1);
    }

    @Override
    public Iterator<Panchang> iterator() {
        return new PanchangIterator(this.cal, this.mode);
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }

    public static void main(String[] stringArray) {
        PanchangList panchangList = new PanchangList(2007);
        for (Panchang panchang : panchangList) {
            System.out.println(panchang);
            System.out.println("------------------------------------------------------");
        }
    }

    public static class PanchangIterator
    implements Iterator<Panchang> {
        private Calendar start;
        private Calendar current;
        private Ephemeris.Mode mode;

        public PanchangIterator(Calendar calendar, Ephemeris.Mode mode) {
            this.start = calendar;
            this.current = AstroUtil.getCalendar(calendar.getTime());
            this.mode = mode;
        }

        @Override
        public boolean hasNext() {
            return this.current.get(this.mode.parentCalField()) == this.start.get(this.mode.parentCalField());
        }

        @Override
        public Panchang next() {
            Panchang panchang = new Panchang(this.current);
            this.current.add(5, 1);
            return panchang;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported for PanchangIterator");
        }
    }
}

