/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.beans.BirthData;
import app.astrosoft.beans.HousePosition;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.AstroConsts;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.Paksha;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Roman;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.Horoscope;
import app.astrosoft.core.VargaCharts;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.ComparableEntry;
import app.astrosoft.util.Mod;
import app.astrosoft.util.SwissHelper;
import app.astrosoft.util.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ShadBala
implements Exportable {
    private static final Logger log = Logger.getLogger(ShadBala.class.getName());
    private BirthData birthData;
    private double ayanamsa;
    private double sunrise;
    private double sunset;
    private Paksha pak;
    private int[][] Rel;
    private int birthDate;
    private int birthMonth;
    private int birthYear;
    private Planet VaraAdipathi;
    private Calendar birthDay;
    private long epochDays;
    private long Ahargana;
    private boolean birthDayNight;
    private HousePosition housePosition;
    private EnumMap<Planet, Double> planetPosition;
    private EnumMap<Planet, Integer> planetLocation;
    private EnumMap<Planet, HousePosition.Bhava> planetBhava;
    private EnumMap<Varga, EnumMap<Planet, Integer>> divChart;
    private Map<Planet, Boolean> planetCharacter;
    private EnumMap<Bala, EnumMap<Planet, Double>> PlanetBala;
    private EnumMap<Bala, ArrayList<Double>> BhavaBala;
    private EnumMap<Planet, Double> StrengthPer = new EnumMap(Planet.class);
    private EnumMap<Planet, Integer> ShadBalaRank;
    private ArrayList<Integer> BhavaBalaRank;
    private TableData<PlanetBalaRow> planetBalaTableData;
    private DefaultColumnMetaData planetBalaColumnMetaData;
    private DefaultColumnMetaData sthanaBalaColumnMetaData;
    private DefaultColumnMetaData kalaBalaColumnMetaData;
    private TableData<BhavaBalaRow> bhavaBalaTableData;
    private DefaultColumnMetaData bhavaBalaColumnMetaData;

    public ShadBala(PlanetaryInfo planetaryInfo, HousePosition housePosition, BirthData birthData, double d, double d2, double d3, Paksha paksha) {
        if (birthData.year() < 1900) {
            throw new IllegalArgumentException("WARNING: Year should be less than 1900");
        }
        this.birthData = birthData;
        this.housePosition = housePosition;
        this.planetPosition = planetaryInfo.getPlanetPosition();
        this.planetLocation = planetaryInfo.getPlanetLocation();
        this.planetBhava = planetaryInfo.getPlanetBhava();
        this.divChart = planetaryInfo.getDivChart();
        this.planetCharacter = planetaryInfo.getPlanetCharacter();
        this.ayanamsa = d;
        this.sunrise = d2;
        this.sunset = d3;
        this.pak = paksha;
        this.birthDay = new GregorianCalendar();
        this.birthDay.setTime(birthData.birthDay().getTime());
        if (birthData.birthTime() < d2) {
            this.birthDay.add(5, -1);
        }
        this.birthDate = this.birthDay.get(5);
        this.birthMonth = this.birthDay.get(2) + 1;
        this.birthYear = this.birthDay.get(1);
        this.birthDayNight = birthData.birthTime() > d2 && birthData.birthTime() < d3;
        this.Rel = new int[7][7];
        this.calcBalas();
    }

    private void calcBalas() {
        double d;
        this.PlanetBala = new EnumMap(Bala.class);
        double[] dArray = new double[]{300.0, 360.0, 300.0, 420.0, 390.0, 330.0, 300.0};
        this.PlanetBala.put(Bala.ResidentialStrength, this.calcResidentialStrength());
        this.PlanetBala.put(Bala.SthanaBala, this.calcSthanaBala());
        this.calcKalaBala();
        this.PlanetBala.put(Bala.DigBala, this.calcDigBala());
        this.PlanetBala.put(Bala.DrikBala, this.calcDrikBala());
        this.PlanetBala.put(Bala.ChestaBala, this.calcChestabala());
        this.PlanetBala.put(Bala.NaisargikaBala, this.calcNaisargikaBala());
        this.calcIshtaKashtaBala();
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            d = this.PlanetBala.get((Object)Bala.SthanaBala).get((Object)planet) + this.PlanetBala.get((Object)Bala.DigBala).get((Object)planet) + this.PlanetBala.get((Object)Bala.KalaBala).get((Object)planet) + this.PlanetBala.get((Object)Bala.NaisargikaBala).get((Object)planet) + this.PlanetBala.get((Object)Bala.DrikBala).get((Object)planet);
            if (planet != Planet.Sun && planet != Planet.Moon) {
                d += this.PlanetBala.get((Object)Bala.ChestaBala).get((Object)planet).doubleValue();
            }
            enumMap.put(planet, d);
        }
        this.PlanetBala.put(Bala.ShadBala, enumMap);
        for (Planet planet : Planet.majorPlanets()) {
            d = (Double)enumMap.get((Object)planet) / dArray[planet.ordinal()] * 100.0;
            this.StrengthPer.put(planet, d);
        }
        this.calcBhavaBalas();
        this.calcRanks();
    }

    private EnumMap<Planet, Double> calcNaisargikaBala() {
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        enumMap.put(Planet.Sun, 60.0);
        enumMap.put(Planet.Moon, 51.43);
        enumMap.put(Planet.Mars, 17.14);
        enumMap.put(Planet.Mercury, 25.7);
        enumMap.put(Planet.Jupiter, 34.28);
        enumMap.put(Planet.Venus, 42.85);
        enumMap.put(Planet.Saturn, 8.57);
        return enumMap;
    }

    private boolean calcSubaPapa(Planet planet) {
        boolean bl = false;
        if (planet == Planet.Mercury) {
            bl = true;
            int n = this.divChart.get((Object)Varga.Rasi).get((Object)Planet.Mercury);
            for (Planet planet2 : Planet.allPlanets()) {
                if (this.divChart.get((Object)Varga.Rasi).get((Object)planet2) != n || planet2 != Planet.Sun && planet2 != Planet.Mars && planet2 != Planet.Saturn && planet2 != Planet.Rahu && planet2 != Planet.Ketu) continue;
                bl = false;
            }
        } else {
            bl = this.planetCharacter.get((Object)planet);
        }
        return bl;
    }

    private EnumMap<Planet, Double> calcResidentialStrength() {
        double d = 0.0;
        double d2 = 0.0;
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.allPlanets()) {
            BhavaType bhavaType = this.poorvaUttraBhava(this.planetPosition.get((Object)planet), this.planetBhava.get((Object)planet));
            if (bhavaType == BhavaType.Poorva) {
                d = this.planetPosition.get((Object)planet) - this.planetBhava.get((Object)planet).start();
                d2 = this.planetBhava.get((Object)planet).mid() - this.planetBhava.get((Object)planet).start();
            } else if (bhavaType == BhavaType.Uttra) {
                d = this.planetBhava.get((Object)planet).end() - this.planetPosition.get((Object)planet);
                d2 = this.planetBhava.get((Object)planet).end() - this.planetBhava.get((Object)planet).mid();
            } else {
                log.severe("Residential Strength Error, invalid bhava type " + (Object)((Object)bhavaType));
            }
            Mod mod = new Mod(360);
            d = mod.correct(d);
            d2 = mod.correct(d2);
            enumMap.put(planet, d * 100.0 / d2);
        }
        return enumMap;
    }

    private BhavaType poorvaUttraBhava(double d, HousePosition.Bhava bhava) {
        BhavaType bhavaType = null;
        if (d >= bhava.start() && d <= bhava.mid()) {
            bhavaType = BhavaType.Poorva;
        } else if (d >= bhava.mid() && d <= bhava.end()) {
            bhavaType = BhavaType.Uttra;
        } else {
            log.info("Residential Strengh! Need to verify");
            double d2 = bhava.length();
            double d3 = bhava.start();
            double d4 = d3 + d2 / 2.0;
            double d5 = d4 + d2 / 2.0;
            log.info("length " + d2);
            log.info("start " + d3);
            log.info("mid " + d4);
            log.info("end " + d5);
            log.info("pos " + d);
            bhavaType = d4 <= 360.0 ? (d >= d3 && d <= d4 ? BhavaType.Poorva : BhavaType.Uttra) : ((d += 360.0) >= d4 && d <= d5 ? BhavaType.Uttra : BhavaType.Poorva);
            log.info("type " + (Object)((Object)bhavaType));
        }
        return bhavaType;
    }

    private EnumMap<Planet, Double> calcSthanaBala() {
        this.PlanetBala.put(Bala.OchchaBala, this.calcOchchaBala());
        this.PlanetBala.put(Bala.SaptavargajaBala, this.calcSaptavargajaBala());
        this.PlanetBala.put(Bala.OjaYugmarasyamsaBala, this.calcOjaYugmarasyamsaBala());
        this.PlanetBala.put(Bala.KendraBala, this.calcKendraBala());
        this.PlanetBala.put(Bala.DrekkanaBala, this.calcDrekkanaBala());
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            double d = 0.0;
            for (Bala bala : Bala.sthanaBalas()) {
                d += this.PlanetBala.get((Object)bala).get((Object)planet).doubleValue();
            }
            enumMap.put(planet, d);
        }
        this.PlanetBala.put(Bala.SthanaBala, enumMap);
        return enumMap;
    }

    private EnumMap<Planet, Double> calcOchchaBala() {
        double[] dArray = new double[]{190.0, 213.0, 118.0, 345.0, 275.0, 177.0, 20.0};
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            double d = Math.abs(this.planetPosition.get((Object)planet) - dArray[planet.ordinal()]) / 3.0;
            if (d > 60.0) {
                d = 120.0 - d;
            }
            enumMap.put(planet, d);
        }
        return enumMap;
    }

    private EnumMap<Planet, Double> calcOjaYugmarasyamsaBala() {
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            int n = VargaCharts.oddEven(this.divChart.get((Object)Varga.Rasi).get((Object)planet));
            int n2 = VargaCharts.oddEven(this.divChart.get((Object)Varga.Navamsa).get((Object)planet));
            if (planet == Planet.Sun || planet == Planet.Mars || planet == Planet.Mercury || planet == Planet.Jupiter || planet == Planet.Saturn) {
                enumMap.put(planet, (double)(n * 15) + (double)(n2 * 15));
            }
            if (planet != Planet.Moon && planet != Planet.Venus) continue;
            enumMap.put(planet, Double.valueOf(15 * (n == 0 ? 1 : 0) + 15 * (n2 == 0 ? 1 : 0)));
        }
        return enumMap;
    }

    private EnumMap<Planet, Double> calcKendraBala() {
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        for (Planet planet : Planet.majorPlanets()) {
            switch (this.planetLocation.get((Object)planet)) {
                case 1: 
                case 4: 
                case 7: 
                case 10: {
                    enumMap.put(planet, 60.0);
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 11: {
                    enumMap.put(planet, 30.0);
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 12: {
                    enumMap.put(planet, 15.0);
                }
            }
        }
        return enumMap;
    }

    private EnumMap<Planet, Double> calcDrekkanaBala() {
        int n = 0;
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        for (Planet planet : Planet.majorPlanets()) {
            n = (int)(this.planetPosition.get((Object)planet) % 30.0 / 10.0) + 1;
            if ((planet == Planet.Sun || planet == Planet.Mars || planet == Planet.Jupiter) && n == 1) {
                enumMap.put(planet, 15.0);
            }
            if ((planet == Planet.Mercury || planet == Planet.Saturn) && n == 2) {
                enumMap.put(planet, 15.0);
            }
            if (planet != Planet.Moon && planet != Planet.Venus || n != 3) continue;
            enumMap.put(planet, 15.0);
        }
        return enumMap;
    }

    private EnumMap<Planet, Double> calcSaptavargajaBala() {
        this.calcRelationShips();
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            enumMap.put(planet, this.SaptavargajaBala(Varga.Rasi, planet) + this.SaptavargajaBala(Varga.Hora, planet) + this.SaptavargajaBala(Varga.Drekkana, planet) + this.SaptavargajaBala(Varga.Saptamsa, planet) + this.SaptavargajaBala(Varga.Navamsa, planet) + this.SaptavargajaBala(Varga.Dwadasamsa, planet) + this.SaptavargajaBala(Varga.Trimshamsa, planet));
        }
        return enumMap;
    }

    private double SaptavargajaBala(Varga varga, Planet planet) {
        double d = 0.0;
        Rasi rasi = Rasi.ofIndex(this.divChart.get((Object)varga).get((Object)planet) - 1);
        Planet planet2 = rasi.owner();
        if (planet == planet2) {
            d = varga == Varga.Rasi && planet2.isMoolaTrikona(rasi) ? 45.0 : 30.0;
        } else {
            switch (this.Rel[planet.ordinal()][planet2.ordinal()]) {
                case 2: {
                    d = 22.5;
                    break;
                }
                case 1: {
                    d = 15.0;
                    break;
                }
                case 0: {
                    d = 7.5;
                    break;
                }
                case -1: {
                    d = 3.75;
                    break;
                }
                case -2: {
                    d = 1.875;
                }
            }
        }
        return d;
    }

    private void calcRelationShips() {
        int n = 0;
        for (Planet planet : Planet.majorPlanets()) {
            for (Planet planet2 : Planet.majorPlanets()) {
                if (planet == planet2) {
                    this.Rel[planet.ordinal()][planet2.ordinal()] = 2;
                } else {
                    n = this.planetLocation.get((Object)planet2) - this.planetLocation.get((Object)planet) + 1;
                    if (n <= 0) {
                        n += 12;
                    }
                    this.Rel[planet.ordinal()][planet2.ordinal()] = n == 2 || n == 3 || n == 4 || n == 10 || n == 11 || n == 12 ? 1 : -1;
                }
                this.Rel[planet.ordinal()][planet2.ordinal()] = this.Rel[planet.ordinal()][planet2.ordinal()] + AstroConsts.permanentRel(planet, planet2);
            }
        }
    }

    private EnumMap<Planet, Double> calcDigBala() {
        double d = 0.0;
        double d2 = 0.0;
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            if (planet == Planet.Sun || planet == Planet.Mars) {
                d = this.housePosition.getBhava(4).mid();
            }
            if (planet == Planet.Jupiter || planet == Planet.Mercury) {
                d = this.housePosition.getBhava(7).mid();
            }
            if (planet == Planet.Moon || planet == Planet.Venus) {
                d = this.housePosition.getBhava(10).mid();
            }
            if (planet == Planet.Saturn) {
                d = this.housePosition.getBhava(1).mid();
            }
            if ((d2 = Math.abs(this.planetPosition.get((Object)planet) - d)) > 180.0) {
                d2 = 360.0 - d2;
            }
            enumMap.put(planet, d2 / 3.0);
        }
        return enumMap;
    }

    private void calcKalaBala() {
        this.calcAhargana();
        this.PlanetBala.put(Bala.AbdaBala, this.calcAbdaBala());
        this.PlanetBala.put(Bala.MasaBala, this.calcMasaBala());
        this.PlanetBala.put(Bala.VaraBala, this.calcVaraBala());
        this.PlanetBala.put(Bala.PakshaBala, this.calcPakshaBala());
        this.PlanetBala.put(Bala.TribhagaBala, this.calcTribhagaBala());
        this.PlanetBala.put(Bala.HoraBala, this.calcHoraBala());
        this.PlanetBala.put(Bala.NatonnataBala, this.calcNatonnataBala());
        this.PlanetBala.put(Bala.AyanaBala, this.calcAyanaBala());
        this.PlanetBala.put(Bala.YuddhaBala, this.calcYuddhaBala());
    }

    private EnumMap<Planet, Double> calcVaraBala() {
        this.VaraAdipathi = Planet.ofIndex((int)((this.Ahargana + 2L) % 7L));
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        enumMap.put(this.VaraAdipathi, 45.0);
        return enumMap;
    }

    private EnumMap<Planet, Double> calcAbdaBala() {
        Planet planet = Planet.ofIndex((int)((this.Ahargana / 360L * 3L + 3L) % 7L));
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        enumMap.put(planet, 15.0);
        return enumMap;
    }

    private EnumMap<Planet, Double> calcMasaBala() {
        Planet planet = Planet.ofIndex((int)((this.Ahargana / 30L * 2L + 3L) % 7L));
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        enumMap.put(planet, 30.0);
        return enumMap;
    }

    private void calcAhargana() {
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        int n = this.birthYear - 1900;
        this.epochDays = n * 365 + n / 4 + nArray[this.birthMonth - 1] - 1 + this.birthDate;
        this.Ahargana = this.epochDays + 26543L;
    }

    private EnumMap<Planet, Double> calcPakshaBala() {
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        double d = Math.abs(this.planetPosition.get((Object)Planet.Moon) - this.planetPosition.get((Object)Planet.Sun));
        if (d > 180.0) {
            d = 360.0 - d;
        }
        double d2 = d / 3.0;
        if (this.calcSubaPapa(Planet.Moon)) {
            enumMap.put(Planet.Moon, d2 * 2.0);
        } else {
            enumMap.put(Planet.Moon, (60.0 - d2) * 2.0);
        }
        enumMap.put(Planet.Sun, 60.0 - d2);
        enumMap.put(Planet.Mars, 60.0 - d2);
        enumMap.put(Planet.Saturn, 60.0 - d2);
        enumMap.put(Planet.Jupiter, d2);
        enumMap.put(Planet.Venus, d2);
        if (this.calcSubaPapa(Planet.Mercury)) {
            enumMap.put(Planet.Mercury, d2);
        } else {
            enumMap.put(Planet.Mercury, 60.0 - d2);
        }
        return enumMap;
    }

    private EnumMap<Planet, Double> calcTribhagaBala() {
        double d = 0.0;
        int n = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.birthDayNight) {
            d2 = this.sunrise;
            d3 = this.sunset;
        } else if (this.birthData.birthTime() < this.sunrise) {
            d2 = this.sunrise;
            d3 = AstroUtil.getSunSet(this.birthYear, this.birthMonth, this.birthDate, this.birthData.longitude(), this.birthData.latitude(), this.birthData.timeZone());
        } else if (this.birthData.birthTime() > this.sunset) {
            this.birthDay.add(5, 1);
            d2 = AstroUtil.getSunRise(this.birthDay.get(1), this.birthDay.get(2) + 1, this.birthDay.get(5), this.birthData.longitude(), this.birthData.latitude(), this.birthData.timeZone());
            d3 = this.sunset;
        } else {
            log.severe("TribhagaBala Error:");
        }
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        if (this.birthDayNight) {
            d = (d3 - d2) / 3.0;
            n = (int)((this.birthData.birthTime() - d2) / d) + 1;
            switch (n) {
                case 1: {
                    enumMap.put(Planet.Mercury, 60.0);
                    break;
                }
                case 2: {
                    enumMap.put(Planet.Sun, 60.0);
                    break;
                }
                case 3: {
                    enumMap.put(Planet.Saturn, 60.0);
                }
            }
        } else {
            d = (24.0 + d2 - d3) / 3.0;
            double d4 = this.birthData.birthTime() - d3;
            if (d4 < 0.0) {
                d4 += 24.0;
            }
            n = (int)(d4 / d) + 1;
            switch (n) {
                case 1: {
                    enumMap.put(Planet.Moon, 60.0);
                    break;
                }
                case 2: {
                    enumMap.put(Planet.Venus, 60.0);
                    break;
                }
                case 3: {
                    enumMap.put(Planet.Mars, 60.0);
                }
            }
        }
        enumMap.put(Planet.Jupiter, 60.0);
        return enumMap;
    }

    private EnumMap<Planet, Double> calcHoraBala() {
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        Planet[] planetArray = new Planet[]{Planet.Sun, Planet.Venus, Planet.Mercury, Planet.Moon, Planet.Saturn, Planet.Jupiter, Planet.Mars};
        int[] nArray = new int[]{0, 3, 6, 2, 5, 1, 4};
        double d = AstroUtil.getSunRise(this.birthYear, this.birthMonth, this.birthDate, this.birthData.longitude(), this.birthData.latitude(), this.birthData.timeZone());
        double d2 = this.birthData.birthTime() - d;
        if (d2 < 0.0) {
            d2 += 24.0;
        }
        int n = (int)d2 + 1;
        int n2 = (nArray[this.VaraAdipathi.ordinal()] + n - 1) % 7;
        enumMap.put(planetArray[n2], 60.0);
        return enumMap;
    }

    private EnumMap<Planet, Double> calcNatonnataBala() {
        double d = SwissHelper.calcNatonnataBalaDeg(this.birthData.birthSD(), this.birthData.birthTime());
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        enumMap.put(Planet.Sun, d / 3.0);
        enumMap.put(Planet.Jupiter, d / 3.0);
        enumMap.put(Planet.Venus, d / 3.0);
        enumMap.put(Planet.Moon, (180.0 - d) / 3.0);
        enumMap.put(Planet.Mars, (180.0 - d) / 3.0);
        enumMap.put(Planet.Saturn, (180.0 - d) / 3.0);
        enumMap.put(Planet.Mercury, 60.0);
        return enumMap;
    }

    private EnumMap<Planet, Double> calcAyanaBala() {
        double[] dArray = this.calcKranti();
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        for (Planet planet : Planet.majorPlanets()) {
            if (planet == Planet.Sun || planet == Planet.Venus || planet == Planet.Mars || planet == Planet.Jupiter) {
                enumMap.put(planet, (24.0 + dArray[planet.ordinal()]) * 60.0 / 48.0);
                continue;
            }
            if (planet == Planet.Moon || planet == Planet.Saturn) {
                enumMap.put(planet, (24.0 + dArray[planet.ordinal()] * -1.0) * 60.0 / 48.0);
                continue;
            }
            enumMap.put(planet, (24.0 + Math.abs(dArray[planet.ordinal()])) * 60.0 / 48.0);
        }
        enumMap.put(Planet.Sun, enumMap.get((Object)Planet.Sun) * 2.0);
        return enumMap;
    }

    private double[] calcKranti() {
        double[] dArray = new double[]{0.0, 6.033333333333333, 11.716666666666667, 16.7, 20.633333333333333, 23.133333333333333, 24.0};
        double d = 0.0;
        double[] dArray2 = new double[7];
        for (Planet planet : Planet.majorPlanets()) {
            double d2 = this.planetPosition.get((Object)planet) + this.ayanamsa;
            int n = d2 > 180.0 && d2 <= 360.0 ? -1 : 1;
            if (d2 > 0.0 && d2 <= 90.0) {
                d = d2;
            } else if (d2 > 90.0 && d2 <= 180.0) {
                d = 180.0 - d2;
            } else if (d2 > 180.0 && d2 <= 270.0) {
                d = d2 - 180.0;
            } else if (d2 > 270.0 && d2 <= 360.0) {
                d = 360.0 - d2;
            }
            int n2 = (int)d / 15;
            double d3 = d % 15.0;
            double d4 = (dArray[n2 + 1] - dArray[n2]) * d3 / 15.0;
            dArray2[planet.ordinal()] = (dArray[n2] + d4) * (double)n;
        }
        return dArray2;
    }

    private EnumMap<Planet, Double> calcYuddhaBala() {
        double[] dArray = new double[]{0.0, 0.0, 9.4, 6.6, 190.4, 16.6, 158.0};
        double d = 0.0;
        EnumMap<Planet, Double> enumMap = ShadBala.initBala();
        EnumMap<Planet, Double> enumMap2 = new EnumMap<Planet, Double>(Planet.class);
        enumMap.put(Planet.Sun, 0.0);
        enumMap.put(Planet.Moon, 0.0);
        this.PlanetBala.put(Bala.YuddhaBala, enumMap);
        for (Planet planet : Planet.majorPlanets()) {
            double d2 = 0.0;
            for (Bala bala : Bala.kalaBalas()) {
                d2 += this.PlanetBala.get((Object)bala).get((Object)planet).doubleValue();
            }
            enumMap2.put(planet, d2);
        }
        for (Planet planet : EnumSet.range(Planet.Mars, Planet.Venus)) {
            for (Planet planet2 : EnumSet.range(planet.nextPlanet(), Planet.Saturn)) {
                Planet planet3 = this.findWinner(planet, planet2);
                if (planet3 == null) continue;
                d = Math.abs((Double)enumMap2.get((Object)planet) - (Double)enumMap2.get((Object)planet2)) / Math.abs(dArray[planet.ordinal()] - dArray[planet2.ordinal()]);
                enumMap.put(planet, d);
                if (planet3 == planet) {
                    enumMap.put(planet, d);
                    enumMap.put(planet2, d * -1.0);
                    enumMap2.put(planet, (Double)enumMap2.get((Object)planet) + d);
                    enumMap2.put(planet2, (Double)enumMap2.get((Object)planet2) - d);
                    continue;
                }
                enumMap.put(planet2, d);
                enumMap.put(planet, d * -1.0);
                enumMap2.put(planet, (Double)enumMap2.get((Object)planet) - d);
                enumMap2.put(planet2, (Double)enumMap2.get((Object)planet2) + d);
            }
        }
        this.PlanetBala.put(Bala.KalaBala, enumMap2);
        return enumMap;
    }

    private Planet findWinner(Planet planet, Planet planet2) {
        double d = this.planetPosition.get((Object)planet) - this.planetPosition.get((Object)planet2);
        Planet planet3 = null;
        if (d >= -1.0 && d <= 0.0) {
            planet3 = planet;
        } else if (d > 0.0 && d <= 1.0) {
            planet3 = planet2;
        }
        return planet3;
    }

    private EnumMap<Planet, Double> calcDrikBala() {
        double[][] dArray = new double[7][7];
        int[] nArray = new int[7];
        for (Planet planet : Planet.majorPlanets()) {
            if (this.calcSubaPapa(planet)) {
                nArray[planet.ordinal()] = 1;
                continue;
            }
            nArray[planet.ordinal()] = -1;
        }
        for (Planet planet : Planet.majorPlanets()) {
            for (Planet object : Planet.majorPlanets()) {
                double d = this.planetPosition.get((Object)object) - this.planetPosition.get((Object)planet);
                if (d < 0.0) {
                    d += 360.0;
                }
                double d2 = this.findViseshaDrishti(d, planet);
                dArray[planet.ordinal()][object.ordinal()] = this.findDrishtiValue(d) + d2;
            }
        }
        double d = 0.0;
        EnumMap enumMap = new EnumMap(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            d = 0.0;
            for (Planet planet2 : Planet.majorPlanets()) {
                d += (double)nArray[planet2.ordinal()] * dArray[planet2.ordinal()][planet.ordinal()];
            }
            enumMap.put(planet, d / 4.0);
        }
        return enumMap;
    }

    private double findDrishtiValue(double d) {
        double d2 = 0.0;
        if (d >= 30.0 && d <= 60.0) {
            d2 = (d - 30.0) / 2.0;
        } else if (d > 60.0 && d <= 90.0) {
            d2 = d - 60.0 + 15.0;
        } else if (d > 90.0 && d <= 120.0) {
            d2 = (120.0 - d) / 2.0 + 30.0;
        } else if (d > 120.0 && d <= 150.0) {
            d2 = 150.0 - d;
        } else if (d > 150.0 && d <= 180.0) {
            d2 = (d - 150.0) * 2.0;
        } else if (d > 180.0 && d <= 300.0) {
            d2 = (300.0 - d) / 2.0;
        }
        return d2;
    }

    private double findViseshaDrishti(double d, Planet planet) {
        double d2 = 0.0;
        switch (planet) {
            case Saturn: {
                if (!(d >= 60.0 && d <= 90.0) && (!(d >= 270.0) || !(d <= 300.0))) break;
                d2 = 45.0;
                break;
            }
            case Jupiter: {
                if (!(d >= 120.0 && d <= 150.0) && (!(d >= 240.0) || !(d <= 270.0))) break;
                d2 = 30.0;
                break;
            }
            case Mars: {
                if (!(d >= 90.0 && d <= 120.0) && (!(d >= 210.0) || !(d <= 240.0))) break;
                d2 = 15.0;
                break;
            }
            default: {
                d2 = 0.0;
            }
        }
        return d2;
    }

    private EnumMap<Planet, Double> calcChestabala() {
        double d = this.birthData.birthTime() + (5.066666666666666 - this.birthData.timeZone());
        double d2 = (double)this.epochDays + d / 24.0;
        double[] dArray = new double[7];
        double[] dArray2 = new double[7];
        dArray[3] = dArray[5] = (d2 * 0.9855931 + 257.4568) % 360.0;
        dArray[0] = dArray[5];
        dArray[2] = (d2 * 0.5240218 + 270.22) % 360.0;
        double d3 = 3.33 + 0.0067 * (double)(this.birthYear - 1900);
        dArray[4] = (d2 * 0.08310024 + 220.04 - d3) % 360.0;
        d3 = 5.0 + 0.001 * (double)(this.birthYear - 1900);
        dArray[6] = (d2 * 0.03333857 + 236.74 + d3) % 360.0;
        dArray2[4] = dArray2[6] = dArray[0];
        dArray2[2] = dArray2[6];
        d3 = 6.67 + 0.00133 * (double)(this.birthYear - 1900);
        dArray2[3] = (d2 * 4.092385 + 164.0 + d3) % 360.0;
        d3 = 5.0 + 1.0E-4 * (double)(this.birthYear - 1900);
        dArray2[5] = (d2 * 1.602159 + 328.51 - d3) % 360.0;
        double d4 = (this.planetPosition.get((Object)Planet.Sun) + this.ayanamsa + 90.0) % 360.0;
        if (d4 > 180.0) {
            d4 = 360.0 - d4;
        }
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        enumMap.put(Planet.Sun, d4 / 3.0);
        d4 = this.planetPosition.get((Object)Planet.Moon) - this.planetPosition.get((Object)Planet.Sun);
        if (d4 < 0.0) {
            d4 += 360.0;
        }
        if (d4 > 180.0) {
            d4 = 360.0 - d4;
        }
        enumMap.put(Planet.Moon, d4 / 3.0);
        for (Planet planet : EnumSet.range(Planet.Mars, Planet.Saturn)) {
            d4 = dArray2[planet.ordinal()] - (dArray[planet.ordinal()] + this.planetPosition.get((Object)planet)) / 2.0;
            if (d4 < 360.0) {
                d4 += 360.0;
            }
            if ((d4 %= 360.0) > 180.0) {
                d4 = 360.0 - d4;
            }
            enumMap.put(planet, d4 / 3.0);
        }
        return enumMap;
    }

    public void calcIshtaKashtaBala() {
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        EnumMap<Planet, Double> enumMap2 = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            double d = this.PlanetBala.get((Object)Bala.OchchaBala).get((Object)planet) * this.PlanetBala.get((Object)Bala.ChestaBala).get((Object)planet);
            enumMap.put(planet, Math.sqrt(d));
            d = (60.0 - this.PlanetBala.get((Object)Bala.OchchaBala).get((Object)planet)) * (60.0 - this.PlanetBala.get((Object)Bala.ChestaBala).get((Object)planet));
            enumMap2.put(planet, Math.sqrt(d));
        }
        this.PlanetBala.put(Bala.IshtaBala, enumMap);
        this.PlanetBala.put(Bala.KashtaBala, enumMap2);
    }

    public void calcBhavaBalas() {
        this.BhavaBala = new EnumMap(Bala.class);
        this.BhavaBala.put(Bala.BhavaAdhipathiBala, this.calcBhavaAdhipathiBala());
        this.BhavaBala.put(Bala.BhavaDigBala, this.calcBhavaDigBala());
        this.BhavaBala.put(Bala.BhavaDrishtiBala, this.calcBhavaDrishtiBala());
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < 12; ++i) {
            double d = 0.0;
            for (Bala bala : Bala.bhavaBalas()) {
                d += this.BhavaBala.get((Object)bala).get(i).doubleValue();
            }
            arrayList.add(i, d);
        }
        this.BhavaBala.put(Bala.BhavaBala, arrayList);
    }

    public ArrayList<Double> calcBhavaAdhipathiBala() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 1; i <= 12; ++i) {
            Planet planet = this.housePosition.getBhava(i).house().owner();
            arrayList.add(i - 1, this.PlanetBala.get((Object)Bala.ShadBala).get((Object)planet));
        }
        return arrayList;
    }

    public ArrayList<Double> calcBhavaDigBala() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        for (int i = 1; i <= 12; ++i) {
            if (this.housePosition.getBhava(i).mid() >= 210.0 && this.housePosition.getBhava(i).mid() <= 240.0) {
                n = 1 - i;
            } else if (this.housePosition.getBhava(i).mid() >= 0.0 && this.housePosition.getBhava(i).mid() <= 60.0 || this.housePosition.getBhava(i).mid() >= 120.0 && this.housePosition.getBhava(i).mid() <= 150.0 || this.housePosition.getBhava(i).mid() >= 255.0 && this.housePosition.getBhava(i).mid() <= 285.0) {
                n = 4 - i;
            } else if (this.housePosition.getBhava(i).mid() >= 60.0 && this.housePosition.getBhava(i).mid() <= 90.0 || this.housePosition.getBhava(i).mid() >= 150.0 && this.housePosition.getBhava(i).mid() <= 210.0 || this.housePosition.getBhava(i).mid() >= 300.0 && this.housePosition.getBhava(i).mid() <= 330.0 || this.housePosition.getBhava(i).mid() >= 240.0 && this.housePosition.getBhava(i).mid() <= 255.0) {
                n = 7 - i;
            } else if (this.housePosition.getBhava(i).mid() >= 90.0 && this.housePosition.getBhava(i).mid() <= 120.0 || this.housePosition.getBhava(i).mid() >= 330.0 && this.housePosition.getBhava(i).mid() <= 360.0 || this.housePosition.getBhava(i).mid() >= 285.0 && this.housePosition.getBhava(i).mid() <= 300.0) {
                n = 10 - i;
            }
            if (n < 0) {
                n += 12;
            }
            if (n > 6) {
                n = 12 - n;
            }
            arrayList.add(i - 1, (double)n * 10.0);
        }
        return arrayList;
    }

    private ArrayList<Double> calcBhavaDrishtiBala() {
        double[][] dArray = new double[7][12];
        int[] nArray = new int[7];
        for (Planet planet : Planet.majorPlanets()) {
            if (this.calcSubaPapa(planet)) {
                nArray[planet.ordinal()] = 1;
                continue;
            }
            nArray[planet.ordinal()] = -1;
        }
        nArray[3] = 1;
        for (Planet planet : Planet.majorPlanets()) {
            for (int i = 1; i <= 12; ++i) {
                double d = this.housePosition.getBhava(i).mid() - this.planetPosition.get((Object)planet);
                if (d < 0.0) {
                    d += 360.0;
                }
                double d2 = this.findViseshaDrishti(d, planet);
                dArray[planet.ordinal()][i - 1] = planet == Planet.Mercury || planet == Planet.Jupiter ? this.findDrishtiValue(d) + d2 : (this.findDrishtiValue(d) + d2) / 4.0;
            }
        }
        double d = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < 12; ++i) {
            d = 0.0;
            for (int j = 0; j < 7; ++j) {
                d += (double)nArray[j] * dArray[j][i];
            }
            arrayList.add(i, d);
        }
        return arrayList;
    }

    private void calcRanks() {
        Object object;
        List list = Utils.sortMap(this.StrengthPer.entrySet(), true);
        this.ShadBalaRank = new EnumMap(Planet.class);
        for (int i = 1; i <= 7; ++i) {
            object = list.get(i - 1);
            this.ShadBalaRank.put((Planet)((Enum)((ComparableEntry)object).getKey()), i);
        }
        this.BhavaBalaRank = new ArrayList();
        ArrayList<Double> arrayList = this.BhavaBala.get((Object)Bala.BhavaBala);
        object = new ArrayList();
        ((ArrayList)object).addAll(arrayList);
        Collections.sort(object, Collections.reverseOrder());
        for (int i = 0; i < 12; ++i) {
            int n = ((ArrayList)object).indexOf(arrayList.get(i)) + 1;
            this.BhavaBalaRank.add(i, n);
        }
    }

    private static EnumMap<Planet, Double> initBala() {
        EnumMap<Planet, Double> enumMap = new EnumMap<Planet, Double>(Planet.class);
        for (Planet planet : Planet.majorPlanets()) {
            enumMap.put(planet, 0.0);
        }
        return enumMap;
    }

    public Map<Planet, Double> getStrengthPer() {
        return this.StrengthPer;
    }

    public TableData<PlanetBalaRow> getPlanetBalaTableData() {
        if (this.planetBalaTableData == null) {
            this.planetBalaTableData = new PlanetBalaTableData();
        }
        return this.planetBalaTableData;
    }

    public DefaultColumnMetaData getPlanetBalaColumnMetaData() {
        if (this.planetBalaColumnMetaData == null) {
            this.planetBalaColumnMetaData = new PlanetBalaColumnMetaData((EnumSet)Bala.planetBalas(), new AstrosoftTableColumn[]{AstrosoftTableColumn.ShadBala, AstrosoftTableColumn.Rupa, AstrosoftTableColumn.BalaPercentage, AstrosoftTableColumn.Rank, AstrosoftTableColumn.IshtaBala, AstrosoftTableColumn.KashtaBala}){

                @Override
                public Comparator getColumnComparator(final AstrosoftTableColumn astrosoftTableColumn) {
                    return new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (sortableColumns.contains((Object)astrosoftTableColumn)) {
                                Comparable comparable = (Comparable)((PlanetBalaRow)object).getColumnData(astrosoftTableColumn);
                                Comparable comparable2 = (Comparable)((PlanetBalaRow)object2).getColumnData(astrosoftTableColumn);
                                if (comparable == null && comparable2 == null) {
                                    return 0;
                                }
                                if (comparable == null) {
                                    return -1;
                                }
                                if (comparable2 == null) {
                                    return 1;
                                }
                                return comparable.compareTo(comparable2);
                            }
                            return 0;
                        }
                    };
                }
            };
            this.planetBalaColumnMetaData.setSortableColumns(AstrosoftTableColumn.Planet, AstrosoftTableColumn.ResidentialStrength, AstrosoftTableColumn.Rank, AstrosoftTableColumn.KashtaBala, AstrosoftTableColumn.IshtaBala);
        }
        return this.planetBalaColumnMetaData;
    }

    public TableData<BhavaBalaRow> getBhavaBalaTableData() {
        if (this.bhavaBalaTableData == null) {
            this.bhavaBalaTableData = new BhavaBalaTableData();
        }
        return this.bhavaBalaTableData;
    }

    public DefaultColumnMetaData getBhavaBalaColumnMetaData() {
        if (this.bhavaBalaColumnMetaData == null) {
            List<AstrosoftTableColumn> list = Bala.toTableColumn(Bala.bhavaBalas());
            list.add(0, AstrosoftTableColumn.House);
            list.add(1, AstrosoftTableColumn.Bhava);
            list.add(AstrosoftTableColumn.BhavaBala);
            list.add(AstrosoftTableColumn.Rupa);
            list.add(AstrosoftTableColumn.Rank);
            this.bhavaBalaColumnMetaData = new DefaultColumnMetaData(list){

                @Override
                public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
                    switch (astrosoftTableColumn) {
                        case House: 
                        case Rank: {
                            return Roman.class;
                        }
                        case Bhava: {
                            return HousePosition.Bhava.class;
                        }
                    }
                    return Number.class;
                }

                @Override
                public Comparator getColumnComparator(final AstrosoftTableColumn astrosoftTableColumn) {
                    return new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (sortableColumns.contains((Object)astrosoftTableColumn)) {
                                Comparable comparable = (Comparable)((BhavaBalaRow)object).getColumnData(astrosoftTableColumn);
                                Comparable comparable2 = (Comparable)((BhavaBalaRow)object2).getColumnData(astrosoftTableColumn);
                                return comparable.compareTo(comparable2);
                            }
                            return 0;
                        }
                    };
                }
            };
            this.bhavaBalaColumnMetaData.localizeColumns();
            this.bhavaBalaColumnMetaData.setSortableColumns(AstrosoftTableColumn.Bhava, AstrosoftTableColumn.Rank);
        }
        return this.bhavaBalaColumnMetaData;
    }

    public DefaultColumnMetaData getSthanaBalaColumnMetaData() {
        if (this.sthanaBalaColumnMetaData == null) {
            this.sthanaBalaColumnMetaData = new PlanetBalaColumnMetaData(Bala.sthanaBalas(), AstrosoftTableColumn.SthanaBala);
        }
        return this.sthanaBalaColumnMetaData;
    }

    public DefaultColumnMetaData getKalaBalaColumnMetaData() {
        if (this.kalaBalaColumnMetaData == null) {
            this.kalaBalaColumnMetaData = new PlanetBalaColumnMetaData(Bala.kalaBalas(), AstrosoftTableColumn.KalaBala);
        }
        return this.kalaBalaColumnMetaData;
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ShadBala \n");
        for (Planet planet : Planet.majorPlanets()) {
            stringBuilder.append(planet.toString() + " --> " + this.planetLocation.get((Object)planet) + "\n");
            stringBuilder.append(planet.toString() + " --> " + this.PlanetBala.get((Object)Bala.ResidentialStrength).get((Object)planet) + "\n");
            stringBuilder.append("OchachaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.OchchaBala).get((Object)planet) + "\n");
            stringBuilder.append("OjaYugmarasyamsaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.OjaYugmarasyamsaBala).get((Object)planet) + "\n");
            stringBuilder.append("KendraBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.KendraBala).get((Object)planet) + "\n");
            stringBuilder.append("DrekkanaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.DrekkanaBala).get((Object)planet) + "\n");
            stringBuilder.append("SapthavargaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.SaptavargajaBala).get((Object)planet) + "\n");
            stringBuilder.append("SthanaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.SthanaBala).get((Object)planet) + "\n");
            stringBuilder.append("DigBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.DigBala).get((Object)planet) + "\n");
            stringBuilder.append("NaisargikaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.NaisargikaBala).get((Object)planet) + "\n");
            stringBuilder.append("AbdaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.AbdaBala).get((Object)planet) + "\n");
            stringBuilder.append("MasaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.MasaBala).get((Object)planet) + "\n");
            stringBuilder.append("VaraBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.VaraBala).get((Object)planet) + "\n");
            stringBuilder.append("PakshaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.PakshaBala).get((Object)planet) + "\n");
            stringBuilder.append("TribhagaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.TribhagaBala).get((Object)planet) + "\n");
            stringBuilder.append("HoraBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.HoraBala).get((Object)planet) + "\n");
            stringBuilder.append("NatonnataBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.NatonnataBala).get((Object)planet) + "\n");
            stringBuilder.append("AyanaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.AyanaBala).get((Object)planet) + "\n");
            stringBuilder.append("YuddhaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.YuddhaBala).get((Object)planet) + "\n");
            stringBuilder.append("KalaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.KalaBala).get((Object)planet) + "\n");
            stringBuilder.append("DrikBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.DrikBala).get((Object)planet) + "\n");
            stringBuilder.append("ChestaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.ChestaBala).get((Object)planet) + "\n");
            stringBuilder.append("IshtaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.IshtaBala).get((Object)planet) + "\n");
            stringBuilder.append("KashtaBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.KashtaBala).get((Object)planet) + "\n");
            stringBuilder.append("ShadBala:-->" + planet.toString() + " :-> " + this.PlanetBala.get((Object)Bala.ShadBala).get((Object)planet) / 60.0 + "\n");
            stringBuilder.append("ShadBala Per:-->" + planet.toString() + " :-> " + this.StrengthPer.get((Object)planet) + "\n");
            stringBuilder.append("ShadBala Rank:-->" + planet.toString() + " :-> " + this.ShadBalaRank.get((Object)planet) + "\n");
        }
        for (int i = 0; i < 12; ++i) {
            stringBuilder.append("BhavaAdhipathiBala: " + (i + 1) + " : -->" + this.BhavaBala.get((Object)Bala.BhavaAdhipathiBala).get(i) / 60.0 + "\n");
            stringBuilder.append("BhavaDigBala: " + (i + 1) + " : -->" + this.BhavaBala.get((Object)Bala.BhavaDigBala).get(i) + "\n");
            stringBuilder.append("BhavaDrishtiBala: " + (i + 1) + " : -->" + this.BhavaBala.get((Object)Bala.BhavaDrishtiBala).get(i) + "\n");
            stringBuilder.append("BhavaBala: " + (i + 1) + " : -->" + this.BhavaBala.get((Object)Bala.BhavaBala).get(i) + "\n");
            stringBuilder.append("BhavaBala Rank: " + (i + 1) + " : -->" + this.BhavaBalaRank.get(i) + "\n");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        Horoscope horoscope = new Horoscope("Raja", 11, 12, 1980, 1, 44, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        horoscope.setAyanamsa(Ayanamsa.KRISHNAMURTHI);
        ShadBala shadBala = new ShadBala(horoscope.getPlanetaryInfo(), horoscope.getHousePosition(), horoscope.getBirthData(), horoscope.getAyanamsa(), horoscope.getSunrise(), horoscope.getSunset(), horoscope.getPaksha());
        System.out.println(shadBala);
    }

    private class BhavaBalaRow
    implements TableRowData {
        int bhava;

        public BhavaBalaRow(int n) {
            this.bhava = n;
        }

        @Override
        public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
            if (astrosoftTableColumn == AstrosoftTableColumn.House) {
                return Roman.of(this.bhava + 1);
            }
            if (astrosoftTableColumn == AstrosoftTableColumn.Bhava) {
                return ShadBala.this.housePosition.getBhava(this.bhava + 1).house();
            }
            if (astrosoftTableColumn == AstrosoftTableColumn.Rupa) {
                return (Double)((ArrayList)ShadBala.this.BhavaBala.get((Object)Bala.BhavaBala)).get(this.bhava) / 60.0;
            }
            if (astrosoftTableColumn == AstrosoftTableColumn.Rank) {
                return Roman.of((Integer)ShadBala.this.BhavaBalaRank.get(this.bhava));
            }
            Bala bala = astrosoftTableColumn.toEnum(Bala.class);
            return ((ArrayList)ShadBala.this.BhavaBala.get((Object)bala)).get(this.bhava);
        }
    }

    private class BhavaBalaTableData
    implements TableData<BhavaBalaRow> {
        private BhavaBalaTableData() {
        }

        @Override
        public BhavaBalaRow getRow(int n) {
            return new BhavaBalaRow(n);
        }

        @Override
        public int getRowCount() {
            return 12;
        }
    }

    private class PlanetBalaRow
    implements TableRowData {
        Planet row;

        public PlanetBalaRow(Planet planet) {
            this.row = planet;
        }

        @Override
        public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
            if (astrosoftTableColumn == AstrosoftTableColumn.Planet) {
                return this.row;
            }
            if (astrosoftTableColumn == AstrosoftTableColumn.Rupa) {
                Double d = (Double)((EnumMap)ShadBala.this.PlanetBala.get((Object)Bala.ShadBala)).get((Object)this.row);
                if (d != null) {
                    return d / 60.0;
                }
                return null;
            }
            if (astrosoftTableColumn == AstrosoftTableColumn.BalaPercentage) {
                return ShadBala.this.StrengthPer.get((Object)this.row);
            }
            if (astrosoftTableColumn == AstrosoftTableColumn.Rank) {
                Integer n = (Integer)ShadBala.this.ShadBalaRank.get((Object)this.row);
                if (n != null) {
                    return Roman.of((Integer)ShadBala.this.ShadBalaRank.get((Object)this.row));
                }
                return null;
            }
            Bala bala = astrosoftTableColumn.toEnum(Bala.class);
            return ((EnumMap)ShadBala.this.PlanetBala.get((Object)bala)).get((Object)this.row);
        }
    }

    private class PlanetBalaTableData
    implements TableData<PlanetBalaRow> {
        private PlanetBalaTableData() {
        }

        @Override
        public PlanetBalaRow getRow(int n) {
            return new PlanetBalaRow(Planet.values()[n]);
        }

        @Override
        public int getRowCount() {
            return 9;
        }
    }

    private class PlanetBalaColumnMetaData
    extends DefaultColumnMetaData {
        public PlanetBalaColumnMetaData(EnumSet<Bala> enumSet, AstrosoftTableColumn ... astrosoftTableColumnArray) {
            List<AstrosoftTableColumn> list = Bala.toTableColumn(enumSet);
            list.add(0, AstrosoftTableColumn.Planet);
            for (AstrosoftTableColumn astrosoftTableColumn : astrosoftTableColumnArray) {
                list.add(astrosoftTableColumn);
            }
            super.addColumns(list);
            this.localizeColumns();
        }

        @Override
        public Class getColumnClass(AstrosoftTableColumn astrosoftTableColumn) {
            switch (astrosoftTableColumn) {
                case Planet: {
                    return Planet.class;
                }
                case Rank: {
                    return Roman.class;
                }
            }
            return Number.class;
        }
    }

    public static enum Bala {
        ResidentialStrength,
        SthanaBala,
        OchchaBala,
        SaptavargajaBala,
        OjaYugmarasyamsaBala,
        KendraBala,
        DrekkanaBala,
        DigBala,
        PakshaBala,
        TribhagaBala,
        AbdaBala,
        MasaBala,
        VaraBala,
        HoraBala,
        NatonnataBala,
        AyanaBala,
        YuddhaBala,
        KalaBala,
        DrikBala,
        ChestaBala,
        NaisargikaBala,
        IshtaBala,
        KashtaBala,
        ShadBala,
        BhavaBala,
        BhavaAdhipathiBala,
        BhavaDigBala,
        BhavaDrishtiBala;


        public static EnumSet<Bala> planetBalas() {
            return EnumSet.of(ResidentialStrength, new Bala[]{SthanaBala, KalaBala, DigBala, DrikBala, ChestaBala, NaisargikaBala});
        }

        public static EnumSet<Bala> bhavaBalas() {
            return EnumSet.of(BhavaAdhipathiBala, BhavaDigBala, BhavaDrishtiBala);
        }

        public static EnumSet<Bala> sthanaBalas() {
            return EnumSet.of(OchchaBala, SaptavargajaBala, OjaYugmarasyamsaBala, KendraBala, DrekkanaBala);
        }

        public static EnumSet<Bala> kalaBalas() {
            return EnumSet.of(AbdaBala, new Bala[]{MasaBala, VaraBala, HoraBala, PakshaBala, TribhagaBala, NatonnataBala, AyanaBala, YuddhaBala});
        }

        public static List<AstrosoftTableColumn> toTableColumn(EnumSet<Bala> enumSet) {
            ArrayList<AstrosoftTableColumn> arrayList = new ArrayList<AstrosoftTableColumn>();
            for (Bala bala : enumSet) {
                arrayList.add(AstrosoftTableColumn.valueOf(bala.name()));
            }
            return arrayList;
        }
    }

    private static enum BhavaType {
        Poorva,
        Uttra;

    }
}

