/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.beans.HousePosition;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.Horoscope;
import java.util.EnumMap;

public class VargaCharts {
    private EnumMap<Planet, Double> planetaryPosition;
    private HousePosition housePosition;
    private EnumMap<Varga, EnumMap<Planet, Integer>> divChart;

    public VargaCharts(EnumMap<Planet, Double> enumMap, HousePosition housePosition) {
        this.planetaryPosition = enumMap;
        this.housePosition = housePosition;
    }

    public EnumMap<Planet, Integer> genCharts(Varga varga) {
        EnumMap<Planet, Integer> enumMap = new EnumMap<Planet, Integer>(Planet.class);
        for (Planet planet : Planet.planetsAsc()) {
            enumMap.put(planet, this.findPosition(this.planetaryPosition.get((Object)planet), varga.division()));
        }
        return enumMap;
    }

    public int findPosition(double d, int n) {
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 30.0 / (double)n;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = this.calcBhavaPosition(d);
                break;
            }
            case 1: 
            case 9: {
                d3 = d / d4;
                n2 = (int)(d3 % 12.0) + 1;
                break;
            }
            case 2: {
                d2 = (int)d % 30;
                n2 = (int)(d / 30.0) + 1;
                n3 = VargaCharts.oddEven(n2);
                if (d2 < 15.0 && n3 == 0) {
                    n2 = 4;
                }
                if (d2 < 15.0 && n3 > 0) {
                    n2 = 5;
                }
                if (d2 >= 15.0 && n3 == 0) {
                    n2 = 5;
                }
                if (!(d2 >= 15.0) || n3 <= 0) break;
                n2 = 4;
                break;
            }
            case 3: {
                n2 = (int)(d / 30.0);
                d2 = d % 30.0;
                if (0.0 <= d2 && d2 < 10.0) {
                    ++n2;
                }
                if (10.0 <= d2 && d2 < 20.0) {
                    n2 += 5;
                }
                if (20.0 <= d2 && d2 <= 30.0) {
                    n2 += 9;
                }
                n2 %= 12;
                break;
            }
            case 4: {
                n2 = (int)(d / 30.0);
                d2 = d % 30.0;
                n2 += (int)(d2 / d4) * 3;
                n2 = n2 % 12 + 1;
                break;
            }
            case 7: 
            case 10: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                n2 = VargaCharts.oddEven(n2) == 0 ? (int)((double)n2 + d3) + this.getInc(n) : (int)((double)n2 + d3);
                n2 %= 12;
                break;
            }
            case 20: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                int n4 = VargaCharts.FMD(n2);
                if (n4 == 9) {
                    n4 = 5;
                } else if (n4 == 5) {
                    n4 = 9;
                }
                n2 = (int)((double)n4 + d3) % 12;
                break;
            }
            case 8: 
            case 16: 
            case 45: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                n2 = (int)((double)VargaCharts.FMD(n2) + d3) % 12;
                break;
            }
            case 24: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                n2 = VargaCharts.oddEven(n2) == 0 ? (int)d3 + 4 : (int)d3 + 5;
                n2 %= 12;
                break;
            }
            case 27: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                n2 = (int)((double)this.FEAW(n2) + d3) % 12;
                break;
            }
            case 30: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                if (VargaCharts.oddEven(n2) == 0) {
                    if (d3 < 5.0) {
                        n2 = 2;
                        break;
                    }
                    if (5.0 <= d3 && d3 < 12.0) {
                        n2 = 6;
                        break;
                    }
                    if (12.0 <= d3 && d3 < 20.0) {
                        n2 = 12;
                        break;
                    }
                    if (20.0 <= d3 && d3 < 25.0) {
                        n2 = 10;
                        break;
                    }
                    if (!(25.0 <= d3) || !(d3 < 30.0)) break;
                    n2 = 8;
                    break;
                }
                if (d3 < 5.0) {
                    n2 = 1;
                    break;
                }
                if (5.0 <= d3 && d3 < 10.0) {
                    n2 = 11;
                    break;
                }
                if (10.0 <= d3 && d3 < 18.0) {
                    n2 = 9;
                    break;
                }
                if (18.0 <= d3 && d3 < 25.0) {
                    n2 = 3;
                    break;
                }
                if (!(25.0 <= d3) || !(d3 < 30.0)) break;
                n2 = 7;
                break;
            }
            case 40: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                n2 = VargaCharts.oddEven(n2) == 0 ? (int)d3 + 7 : (int)d3 + 1;
                n2 %= 12;
                break;
            }
            case 12: 
            case 60: {
                n2 = (int)(d / 30.0);
                d2 = d % 30.0;
                n2 += (int)(d2 / d4);
                n2 = n2 % 12 + 1;
                break;
            }
            case 5: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4) + 1;
                if (VargaCharts.oddEven(n2) != 0) {
                    switch ((int)d3) {
                        case 1: {
                            n2 = 1;
                            break;
                        }
                        case 2: {
                            n2 = 11;
                            break;
                        }
                        case 3: {
                            n2 = 9;
                            break;
                        }
                        case 4: {
                            n2 = 3;
                            break;
                        }
                        case 5: {
                            n2 = 7;
                        }
                    }
                    break;
                }
                switch ((int)d3) {
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 6;
                        break;
                    }
                    case 3: {
                        n2 = 12;
                        break;
                    }
                    case 4: {
                        n2 = 10;
                        break;
                    }
                    case 5: {
                        n2 = 8;
                    }
                }
                break;
            }
            case 6: {
                n2 = (int)(d / 30.0) + 1;
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                n2 = VargaCharts.oddEven(n2) == 0 ? (int)d3 + 7 : (int)d3 + 1;
                n2 %= 12;
                break;
            }
            case 11: {
                d2 = d % 30.0;
                d3 = (int)(d2 / d4);
                n2 = (int)(12.0 - d3);
            }
        }
        if (n2 == 0) {
            n2 = 12;
        }
        return n2;
    }

    public EnumMap<Varga, EnumMap<Planet, Integer>> getAllCharts() {
        this.divChart = new EnumMap(Varga.class);
        for (Varga varga : Varga.values()) {
            this.divChart.put(varga, this.genCharts(varga));
        }
        return this.divChart;
    }

    public static int oddEven(int n) {
        return n % 2;
    }

    public static int FMD(int n) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 1;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                n2 = 5;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 9;
            }
        }
        return n2;
    }

    private int FEAW(int n) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 5: 
            case 9: {
                n2 = 1;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                n2 = 4;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                n2 = 7;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                n2 = 10;
            }
        }
        return n2;
    }

    private int getInc(int n) {
        int n2 = 0;
        switch (n) {
            case 10: {
                n2 = 8;
                break;
            }
            case 7: {
                n2 = 6;
            }
        }
        return n2;
    }

    public int calcBhavaPosition(double d) {
        return this.housePosition.locateHouse(d).ordinal() + 1;
    }

    public String toString() {
        return VargaCharts.toString(this.divChart);
    }

    public static String toString(EnumMap<Varga, EnumMap<Planet, Integer>> enumMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Varga varga : Varga.values()) {
            stringBuilder.append((Object)((Object)varga) + " -> ");
            for (Planet planet : Planet.planetsAsc()) {
                stringBuilder.append(enumMap.get((Object)varga).get((Object)planet) + " , ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        Horoscope horoscope = new Horoscope("Raja", 11, 12, 1980, 1, 44, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        System.out.println(VargaCharts.toString(horoscope.getDivChart()));
    }
}

