/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Planet;
import app.astrosoft.core.AbstractDasa;
import app.astrosoft.core.Dasa;
import app.astrosoft.core.Vimshottari;
import app.astrosoft.util.AstroUtil;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;

public class VimDasa
extends AbstractDasa {
    private Planet lord;
    private EnumMap<Planet, Dasa> subDasas;

    public VimDasa() {
    }

    public VimDasa(Planet planet, Dasa dasa, double d, int n) {
        super(dasa, d, n);
        this.lord = planet;
        this.end = d + this.getPeriod();
        this.isRunning = today > d && today < this.end;
    }

    public Map<Planet, Dasa> getSubDasas() {
        this.generateSubDasas();
        return this.subDasas;
    }

    @Override
    public String getStartDate() {
        return Vimshottari.dateFormat.format(AstroUtil.decimalYearToDate(this.start));
    }

    @Override
    public String getEndDate() {
        return Vimshottari.dateFormat.format(AstroUtil.decimalYearToDate(this.end));
    }

    @Override
    public Dasa getCurrent() {
        Dasa dasa = null;
        if (this.isLeaf()) {
            dasa = this;
        } else {
            for (Dasa dasa2 : this.subDasas()) {
                if (!dasa2.isRunning()) continue;
                dasa = dasa2.getCurrent();
            }
        }
        return dasa;
    }

    public String toString() {
        if (this.lord == null) {
            return DisplayStrings.DASA_STR.toString();
        }
        return this.lord.toString();
    }

    public String dasaPeriod() {
        StringBuilder stringBuilder = new StringBuilder(this.fullDasa());
        stringBuilder.append(this.getStartDate() + "\n");
        if (this.isRunning) {
            stringBuilder.insert(0, "*");
        }
        return stringBuilder.toString();
    }

    @Override
    public String fullDasa() {
        StringBuilder stringBuilder = new StringBuilder(this.lord.toString(DisplayFormat.SYMBOL));
        for (VimDasa vimDasa = (VimDasa)this.parent; vimDasa != null; vimDasa = (VimDasa)vimDasa.getParent()) {
            stringBuilder.insert(0, vimDasa.getDasa().toString(DisplayFormat.SYMBOL) + "/");
        }
        return stringBuilder.toString();
    }

    @Override
    public String printTree() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.subDasas == null) {
            stringBuilder.append(this.dasaPeriod());
        } else {
            for (Dasa dasa : this.subDasas()) {
                stringBuilder.append(dasa.printTree());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public DefaultMutableTreeNode createTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this);
        if (this.subDasas == null) {
            return defaultMutableTreeNode;
        }
        for (Dasa dasa : this.subDasas()) {
            defaultMutableTreeNode.add(dasa.createTreeNode());
        }
        return defaultMutableTreeNode;
    }

    public Planet getDasa() {
        return this.lord;
    }

    @Override
    public double getPeriod() {
        if (this.parent == null) {
            return this.lord.dasaPeriod();
        }
        return this.parent.getPeriod() * this.lord.dasaPeriod() / 120.0;
    }

    public void generateSubDasas() {
        if (this.subDasas == null && !this.isLeaf()) {
            this.subDasas = VimDasa.generateSubDasas(this.lord, this, this.start, this.level);
        }
    }

    public static EnumMap<Planet, Dasa> generateSubDasas(Planet planet, Dasa dasa, double d, int n) {
        EnumMap<Planet, Dasa> enumMap = new EnumMap<Planet, Dasa>(Planet.class);
        for (Planet planet2 : Planet.dasaLords(planet)) {
            VimDasa vimDasa = new VimDasa(planet2, dasa, d, n + 1);
            d = vimDasa.getEnd();
            enumMap.put(planet2, vimDasa);
        }
        return enumMap;
    }

    public boolean isLeaf() {
        return this.level > 2;
    }

    @Override
    public Iterable<Dasa> subDasas() {
        this.generateSubDasas();
        return new DasaIterable(this.lord, this.subDasas);
    }

    @Override
    public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
        switch (astrosoftTableColumn) {
            case Dasa: {
                return this.fullDasa();
            }
            case Start: {
                return this.getStartDate();
            }
            case End: {
                return this.getEndDate();
            }
        }
        return null;
    }

    public static class DasaIterator
    implements Iterator<Dasa> {
        Iterator dasaIterator;
        EnumMap<Planet, Dasa> subDasas;

        public DasaIterator(Planet planet, EnumMap<Planet, Dasa> enumMap) {
            this.dasaIterator = Planet.dasaIterator(planet);
            this.subDasas = enumMap;
            if (enumMap == null) {
                this.dasaIterator = Collections.EMPTY_LIST.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.dasaIterator.hasNext();
        }

        @Override
        public Dasa next() {
            return this.subDasas.get(this.dasaIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }

    public static class DasaIterable
    implements Iterable<Dasa> {
        Planet startWith;
        EnumMap<Planet, Dasa> dasas;

        public DasaIterable(Planet planet, EnumMap<Planet, Dasa> enumMap) {
            this.startWith = planet;
            this.dasas = enumMap;
        }

        @Override
        public Iterator<Dasa> iterator() {
            return new DasaIterator(this.startWith, this.dasas);
        }
    }
}

