/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.core;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.DisplayFormat;
import app.astrosoft.consts.Planet;
import app.astrosoft.core.Dasa;
import app.astrosoft.core.VimDasa;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.util.AstroUtil;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Vimshottari
implements Exportable {
    public static final int MAX_LEVEL = 3;
    public static Format dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
    private Planet startLord;
    private double balance;
    private EnumMap<Planet, Dasa> dasa;
    private Dasa currentDasa;
    private DefaultMutableTreeNode root;
    private static DefaultColumnMetaData vimDasaTableColumnMetaData;

    public Vimshottari(double d, Calendar calendar) {
        this.startLord = this.getDasaLord(d);
        this.balance = this.computeBalance(d);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(calendar.getTime());
        double d2 = AstroUtil.dateToDecimalYear(gregorianCalendar);
        double d3 = d2 + this.balance - this.startLord.dasaPeriod();
        this.dasa = VimDasa.generateSubDasas(this.startLord, null, d3, 0);
        this.currentDasa = this.getCurrent();
    }

    private Planet getDasaLord(double d) {
        double d2 = 0.0;
        for (d2 = 0.0; !(!(d2 <= 26.0) || d2 * 13.333333333333334 <= d && d < (d2 + 1.0) * 13.333333333333334); d2 += 1.0) {
        }
        return Planet.ofDasaNo((int)(d2 + 7.0));
    }

    private double computeBalance(double d) {
        double d2 = d % 13.333333333333334;
        d2 = 13.333333333333334 - d2;
        return (d2 *= 60.0) * this.startLord.dasaPeriod() / 800.0;
    }

    public EnumMap<Planet, Dasa> getDasa() {
        return this.dasa;
    }

    public String getBalance() {
        StringBuilder stringBuilder = new StringBuilder("Bal of ");
        stringBuilder.append(this.startLord.toString(DisplayFormat.SYMBOL));
        stringBuilder.append(" Dasa ");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(AstroUtil.decimalYearToDate(this.balance));
        int n = this.balance < 1.0 ? 0 : gregorianCalendar.get(1);
        stringBuilder.append(n + "y ");
        stringBuilder.append(gregorianCalendar.get(2) + "m ");
        stringBuilder.append(gregorianCalendar.get(5) + "d ");
        return stringBuilder.toString();
    }

    public Dasa getCurrent() {
        Dasa dasa = null;
        for (Dasa dasa2 : this.dasas()) {
            if (!dasa2.isRunning()) continue;
            dasa = dasa2.getCurrent();
        }
        return dasa;
    }

    public Iterable<Dasa> dasas() {
        return new VimDasa.DasaIterable(this.startLord, this.dasa);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Dasa dasa : this.dasas()) {
            stringBuffer.append(dasa.printTree());
        }
        return stringBuffer.toString();
    }

    public DefaultMutableTreeNode getRoot() {
        if (this.root == null) {
            this.createTreeNode();
        }
        return this.root;
    }

    public void createTreeNode() {
        this.root = new DefaultMutableTreeNode(new VimDasa());
        for (Dasa dasa : this.dasas()) {
            this.root.add(dasa.createTreeNode());
        }
    }

    public DefaultTreeModel getDasaTreeModel() {
        this.createTreeNode();
        return new DefaultTreeModel(this.root);
    }

    public TreePath getCurrentDasaPath() {
        TreePath treePath = null;
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (this.currentDasa != defaultMutableTreeNode.getUserObject()) continue;
            treePath = new TreePath(defaultMutableTreeNode.getPath());
        }
        return treePath;
    }

    public String printDasaTree() {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append(enumeration.nextElement() + " , ");
        }
        return stringBuilder.toString();
    }

    public TableData<Dasa> getVimDasaTableData(Dasa dasa) {
        return TableDataFactory.getTableData(dasa.subDasas());
    }

    public TableData<Dasa> getVimDasaTableData() {
        return TableDataFactory.getTableData(this.dasas());
    }

    public static DefaultColumnMetaData getVimDasaTableColumnMetaData() {
        if (vimDasaTableColumnMetaData == null) {
            vimDasaTableColumnMetaData = new DefaultColumnMetaData(AstrosoftTableColumn.Dasa, AstrosoftTableColumn.Start, AstrosoftTableColumn.End);
            vimDasaTableColumnMetaData.localizeColumns(AstrosoftTableColumn.Dasa);
        }
        return vimDasaTableColumnMetaData;
    }

    public Planet getStartLord() {
        return this.startLord;
    }

    public static void main(String[] stringArray) {
        Vimshottari vimshottari = new Vimshottari(300.98333333333335, new GregorianCalendar(1980, 11, 11));
        EnumMap<Planet, Dasa> enumMap = vimshottari.getDasa();
        for (Planet planet : Planet.dasaLords(vimshottari.getStartLord())) {
            Dasa dasa = enumMap.get((Object)planet);
            for (Dasa dasa2 : dasa.subDasas()) {
                System.out.println(TableDataFactory.toCSV(vimshottari.getVimDasaTableData(dasa2), Vimshottari.getVimDasaTableColumnMetaData()));
                System.out.println("**********************************************************");
            }
            System.out.println("---------------------------------------------------------");
        }
    }

    @Override
    public void doExport(Exporter exporter) {
        exporter.export(this);
    }
}

