/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.export;

import app.astrosoft.beans.AshtaVargaChartData;
import app.astrosoft.beans.Degree;
import app.astrosoft.beans.HousePosition;
import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.XmlConsts;
import app.astrosoft.core.Ashtavarga;
import app.astrosoft.core.Compactibility;
import app.astrosoft.core.Horoscope;
import app.astrosoft.core.PanchangList;
import app.astrosoft.core.ShadBala;
import app.astrosoft.core.Vimshottari;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.Table;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.AstroUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.Attribute;

public abstract class AbstractExporter
implements Exporter {
    private static final Logger log = Logger.getLogger(AbstractExporter.class.getName());
    protected static final XMLOutputFactory factory = XMLOutputFactory.newInstance();
    protected static final XMLEventFactory xmlef = XMLEventFactory.newInstance();
    protected static final Format formatter = new DecimalFormat("000.00");
    protected XMLEventWriter xmlWriter;

    public AbstractExporter(String string) {
        try {
            this.xmlWriter = factory.createXMLEventWriter(new BufferedWriter(new FileWriter(string)));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in creating xml event writer ", exception);
        }
    }

    @Override
    public void export2Xml(Exportable exportable) {
        AstrosoftPref astrosoftPref = AstroSoft.getPreferences();
        Language language = astrosoftPref.getLanguage();
        astrosoftPref.setLanguage(Language.ENGLISH);
        exportable.doExport(this);
        astrosoftPref.setLanguage(language);
    }

    public <E extends TableRowData> void exportTableData(TableData<E> tableData, QName qName, QName qName2) {
        try {
            this.xmlWriter.add(xmlef.createStartElement(qName, null, null));
            for (int i = 0; i < tableData.getRowCount(); ++i) {
                E e = tableData.getRow(i);
                this.xmlWriter.add(xmlef.createStartElement(qName2, null, null));
                this.xmlWriter.add(xmlef.createAttribute("Name", e.getColumnData(AstrosoftTableColumn.Key).toString()));
                this.xmlWriter.add(xmlef.createCharacters(e.getColumnData(AstrosoftTableColumn.Value).toString()));
                this.xmlWriter.add(xmlef.createEndElement(qName2, null));
            }
            this.xmlWriter.add(xmlef.createEndElement(qName, null));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing horosocope xml document", exception);
        }
    }

    public <E extends TableRowData> void exportTableData(Table table, QName qName, QName qName2) {
        this.exportTableData(table.getTableData(), table.getColumnMetaData(), qName, qName2);
    }

    public <E extends TableRowData> void exportTableData(TableData<E> tableData, ColumnMetaData columnMetaData, QName qName, QName qName2) {
        this.exportTableData(tableData, columnMetaData, qName, null, qName2);
    }

    public <E extends TableRowData> void exportTableData(TableData<E> tableData, ColumnMetaData columnMetaData, QName qName, Attribute attribute, QName qName2) {
        try {
            this.xmlWriter.add(xmlef.createStartElement(qName, null, null));
            if (attribute != null) {
                this.xmlWriter.add(attribute);
            }
            for (int i = 0; i < tableData.getRowCount(); ++i) {
                E e = tableData.getRow(i);
                this.xmlWriter.add(xmlef.createStartElement(qName2, null, null));
                for (AstrosoftTableColumn astrosoftTableColumn : columnMetaData.getVisibleColumns()) {
                    QName qName3 = new QName("http://www.w3.org/2001/XMLSchema-instance", astrosoftTableColumn.name());
                    this.xmlWriter.add(xmlef.createStartElement(qName3, null, null));
                    Object object = e.getColumnData(astrosoftTableColumn);
                    if (object != null) {
                        this.xmlWriter.add(xmlef.createCharacters(AbstractExporter.formatTableValue(columnMetaData.getColumnClass(astrosoftTableColumn), object)));
                    }
                    this.xmlWriter.add(xmlef.createEndElement(qName3, null));
                }
                this.xmlWriter.add(xmlef.createEndElement(qName2, null));
            }
            this.xmlWriter.add(xmlef.createEndElement(qName, null));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing horosocope xml document", exception);
        }
    }

    private static String formatTableValue(Class clazz, Object object) {
        String string = clazz == Degree.class ? AstroUtil.dms(Double.valueOf(object.toString())) : (object instanceof Double ? formatter.format(object) : object.toString());
        return string;
    }

    @Override
    public void export(PlanetChartData planetChartData) {
        try {
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.CHART_TAG, null, null));
            this.xmlWriter.add(xmlef.createAttribute("Name", planetChartData.getChartName()));
            for (Rasi rasi : Rasi.values()) {
                this.xmlWriter.add(xmlef.createStartElement(XmlConsts.HOUSE_TAG, null, null));
                this.xmlWriter.add(xmlef.createAttribute("No", String.valueOf(rasi.ordinal() + 1)));
                EnumMap<Rasi, List<Planet>> enumMap = planetChartData.getPlanetsInRasi();
                if (enumMap.keySet().contains((Object)rasi)) {
                    for (Planet planet : enumMap.get((Object)rasi)) {
                        this.xmlWriter.add(xmlef.createStartElement(XmlConsts.PLANET_TAG, null, null));
                        this.xmlWriter.add(xmlef.createCharacters(planet.sym()));
                        this.xmlWriter.add(xmlef.createEndElement(XmlConsts.PLANET_TAG, null));
                    }
                }
                this.xmlWriter.add(xmlef.createEndElement(XmlConsts.HOUSE_TAG, null));
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.CHART_TAG, null));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing chart xml ", exception);
        }
    }

    @Override
    public void export(Ashtavarga ashtavarga) {
        throw new UnsupportedOperationException("Operation export(ashtavarga) is not supported");
    }

    @Override
    public void export(AshtaVargaChartData ashtaVargaChartData) {
        throw new UnsupportedOperationException("Operation export(ashtavargaChart) is not supported");
    }

    @Override
    public void export(ShadBala shadBala) {
        throw new UnsupportedOperationException("Operation export(shadBala) is not supported");
    }

    @Override
    public void export(PlanetaryInfo planetaryInfo) {
        throw new UnsupportedOperationException("Operation export(planetaryInfo) is not supported");
    }

    @Override
    public void export(HousePosition housePosition) {
        throw new UnsupportedOperationException("Operation export(housePosition) is not supported");
    }

    @Override
    public void export(Vimshottari vimshottari) {
        throw new UnsupportedOperationException("Operation export(vimshottari) is not supported");
    }

    @Override
    public void export(Horoscope horoscope) {
        throw new UnsupportedOperationException("Operation export(horoscope) is not supported");
    }

    @Override
    public void export(Compactibility compactibility) {
        throw new UnsupportedOperationException("Operation export(compactibility) is not supported");
    }

    @Override
    public void export(PanchangList panchangList) {
        throw new UnsupportedOperationException("Operation export(panchangList) is not supported");
    }
}

