/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.export;

import app.astrosoft.export.CompactibilityExporter;
import app.astrosoft.export.Exportable;
import app.astrosoft.export.Exporter;
import app.astrosoft.export.FOPTransformer;
import app.astrosoft.export.HoroscopeExporter;
import app.astrosoft.export.PanchangExporter;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;

public class AstrosoftExporter {
    private static final Logger log = Logger.getLogger(AstrosoftExporter.class.getName());

    public static FutureTask<Object> export2Pdf(final Type type, final Exportable exportable, final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string2 = string.replaceAll(".pdf|.PDF", ".xml");
                AstrosoftExporter.export2Xml(type, exportable, string2);
                log.info("XML File: " + string2);
                log.info("PDF File: " + string);
                FOPTransformer.exportToPDF(string2, type.getTemplate(), string);
            }
        };
        FutureTask<Object> futureTask = new FutureTask<Object>(runnable, null);
        new Thread(futureTask).start();
        return futureTask;
    }

    public static void export2Xml(Type type, Exportable exportable, String string) {
        type.getExporter(string).export2Xml(exportable);
    }

    public static enum Type {
        Horosocope{

            @Override
            public Exporter getExporter(String string) {
                return new HoroscopeExporter(string);
            }

            @Override
            public String getTemplate() {
                return Type.class.getResource("/resources/export/horoscope2pdf.xsl").toString();
            }
        }
        ,
        Compactibility{

            @Override
            public Exporter getExporter(String string) {
                return new CompactibilityExporter(string);
            }

            @Override
            public String getTemplate() {
                return Type.class.getResource("/resources/export/compactibility2pdf.xsl").toString();
            }
        }
        ,
        Panchang{

            @Override
            public Exporter getExporter(String string) {
                return new PanchangExporter(string);
            }

            @Override
            public String getTemplate() {
                return Type.class.getResource("/resources/export/panchang2pdf.xsl").toString();
            }
        };


        public abstract Exporter getExporter(String var1);

        public abstract String getTemplate();
    }
}

