/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.export;

import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Varga;
import app.astrosoft.consts.XmlConsts;
import app.astrosoft.core.Compactibility;
import app.astrosoft.core.Horoscope;
import app.astrosoft.export.AbstractExporter;
import app.astrosoft.export.FOPTransformer;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstroSoft;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompactibilityExporter
extends AbstractExporter {
    private static final Logger log = Logger.getLogger(CompactibilityExporter.class.getName());

    public CompactibilityExporter(String string) {
        super(string);
    }

    @Override
    public void export(Compactibility compactibility) {
        try {
            this.xmlWriter.add(xmlef.createStartDocument());
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.ASTROSOFT_TAG, null, null));
            this.xmlWriter.add(xmlef.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.COMPACTIBILITY_TAG, null, null));
            this.xmlWriter.add(xmlef.createAttribute("Title", compactibility.getTitle()));
            this.xmlWriter.add(xmlef.createAttribute("hasHoroscope", String.valueOf(compactibility.hasHoroscope())));
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.BOY_TAG, null, null));
            this.exportTableData(compactibility.getBoyInfo(), XmlConsts.HOROSCOPE_INFO_TAG, XmlConsts.INFO_TAG);
            if (compactibility.hasHoroscope()) {
                this.export(new PlanetChartData(Varga.Rasi, compactibility.getBoyPlanetaryInfo()));
                this.export(new PlanetChartData(Varga.Navamsa, compactibility.getBoyPlanetaryInfo()));
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.BOY_TAG, null));
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.GIRL_TAG, null, null));
            this.exportTableData(compactibility.getGirlInfo(), XmlConsts.HOROSCOPE_INFO_TAG, XmlConsts.INFO_TAG);
            if (compactibility.hasHoroscope()) {
                this.export(new PlanetChartData(Varga.Rasi, compactibility.getGirlPlanetaryInfo()));
                this.export(new PlanetChartData(Varga.Navamsa, compactibility.getGirlPlanetaryInfo()));
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.GIRL_TAG, null));
            this.exportTableData(compactibility.getKutaTableData(), Compactibility.getKutaTableColumnMetaData(), XmlConsts.KUTA_ANALYSIS_TAG, XmlConsts.KUTA_MATCH_TAG);
            if (compactibility.hasHoroscope()) {
                this.exportTableData(compactibility.getDoshaTableData(), Compactibility.getDoshaTableColumnMetaData(), XmlConsts.DOSHA_ANALYSIS_TAG, XmlConsts.PLANET_DOSHA_TAG);
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.COMPACTIBILITY_TAG, null));
            this.xmlWriter.add(xmlef.createEndDocument());
            this.xmlWriter.close();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing compactibility xml document", exception);
        }
    }

    public static void main(String[] stringArray) {
        AstrosoftPref astrosoftPref = AstroSoft.getPreferences();
        astrosoftPref.setAyanamsa(Ayanamsa.KRISHNAMURTHI);
        Language language = astrosoftPref.getLanguage();
        astrosoftPref.setLanguage(Language.ENGLISH);
        Horoscope horoscope = new Horoscope("Elango", 17, 4, 1957, 7, 10, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        Horoscope horoscope2 = new Horoscope("Mani", 10, 8, 1960, 5, 30, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        Compactibility compactibility = new Compactibility(horoscope, horoscope2);
        String string = "c:/astrosoft/resources/export/compactibility.xml";
        CompactibilityExporter compactibilityExporter = new CompactibilityExporter(string);
        compactibilityExporter.export2Xml(compactibility);
        FOPTransformer.exportToPDF(string, "C:/AstroSoft/resources/export/compactibility2pdf.xsl", "C:/AstroSoft/resources/export/compactibility.pdf");
        astrosoftPref.setLanguage(language);
    }
}

