/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.export;

import app.astrosoft.beans.AshtaVargaChartData;
import app.astrosoft.beans.HousePosition;
import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.AshtavargaName;
import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Varga;
import app.astrosoft.consts.XmlConsts;
import app.astrosoft.core.Ashtavarga;
import app.astrosoft.core.Dasa;
import app.astrosoft.core.Horoscope;
import app.astrosoft.core.ShadBala;
import app.astrosoft.core.Vimshottari;
import app.astrosoft.export.AbstractExporter;
import app.astrosoft.export.FOPTransformer;
import app.astrosoft.ui.AstroSoft;
import app.astrosoft.ui.table.TableDataFactory;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.events.Attribute;

public class HoroscopeExporter
extends AbstractExporter {
    private static final Logger log = Logger.getLogger(HoroscopeExporter.class.getName());

    public HoroscopeExporter(String string) {
        super(string);
    }

    @Override
    public void export(AshtaVargaChartData ashtaVargaChartData) {
        try {
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.ASHTVARGA_CHART_TAG, null, null));
            this.xmlWriter.add(xmlef.createAttribute("Name", ashtaVargaChartData.getChartName()));
            EnumMap<Rasi, Integer> enumMap = ashtaVargaChartData.getVarga();
            for (Rasi rasi : enumMap.keySet()) {
                this.xmlWriter.add(xmlef.createStartElement(XmlConsts.ASHTVARGA_HOUSE_TAG, null, null));
                this.xmlWriter.add(xmlef.createAttribute("No", String.valueOf(rasi.ordinal() + 1)));
                this.xmlWriter.add(xmlef.createCharacters(enumMap.get((Object)rasi).toString()));
                this.xmlWriter.add(xmlef.createEndElement(XmlConsts.ASHTVARGA_HOUSE_TAG, null));
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.ASHTVARGA_CHART_TAG, null));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing chart xml ", exception);
        }
    }

    @Override
    public void export(PlanetaryInfo planetaryInfo) {
        this.exportTableData(planetaryInfo.getPlanateryInfoTableData(), planetaryInfo.getPlanateryInfoColumnMetaData(), XmlConsts.PLANETARY_POS_TAG, XmlConsts.PLANET_POS_TAG);
    }

    @Override
    public void export(HousePosition housePosition) {
        this.exportTableData(housePosition.getBhavaTableData(), housePosition.getBhavaTableColumnData(), XmlConsts.BHAVA_POSITIONS_TAG, XmlConsts.BHAVA_POS_TAG);
    }

    @Override
    public void export(Ashtavarga ashtavarga) {
        try {
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.ASHTAVARGAS_TAG, null, null));
            for (AshtavargaName ashtavargaName : AshtavargaName.ashtavargas()) {
                this.xmlWriter.add(xmlef.createStartElement(XmlConsts.ASHTAVARGA_TAG, null, null));
                this.xmlWriter.add(xmlef.createAttribute("Name", ashtavargaName.name()));
                new AshtaVargaChartData(ashtavargaName, ashtavarga.getAshtavarga(ashtavargaName)).doExport(this);
                new AshtaVargaChartData(AshtavargaName.Trikona, ashtavarga.getTrikona(ashtavargaName)).doExport(this);
                new AshtaVargaChartData(AshtavargaName.Ekathipathya, ashtavarga.getEkathipathiya(ashtavargaName)).doExport(this);
                if (ashtavargaName != AshtavargaName.SarvaAshtavarga) {
                    this.exportTableData(ashtavarga.getGunaTable(ashtavargaName).getTableData(), XmlConsts.GUNAHARAS_TAG, XmlConsts.GUNAHARA_TAG);
                }
                this.xmlWriter.add(xmlef.createEndElement(XmlConsts.ASHTAVARGA_TAG, null));
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.ASHTAVARGAS_TAG, null));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing ashtavarga xml ", exception);
        }
    }

    @Override
    public void export(ShadBala shadBala) {
        try {
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.SHADBALAS_TAG, null, null));
            this.exportTableData(TableDataFactory.getReversedTable(shadBala.getPlanetBalaTableData(), shadBala.getPlanetBalaColumnMetaData(), AstrosoftTableColumn.Planet, AstrosoftTableColumn.Name), XmlConsts.SHADBALA, XmlConsts.BALA_TAG);
            this.exportTableData(TableDataFactory.getReversedTable(shadBala.getPlanetBalaTableData(), shadBala.getSthanaBalaColumnMetaData(), AstrosoftTableColumn.Planet, AstrosoftTableColumn.Name), XmlConsts.STHANABALA_TAG, XmlConsts.BALA_TAG);
            this.exportTableData(TableDataFactory.getReversedTable(shadBala.getPlanetBalaTableData(), shadBala.getKalaBalaColumnMetaData(), AstrosoftTableColumn.Planet, AstrosoftTableColumn.Name), XmlConsts.KALABALA_TAG, XmlConsts.BALA_TAG);
            this.exportTableData(shadBala.getBhavaBalaTableData(), shadBala.getBhavaBalaColumnMetaData(), XmlConsts.BHAVABALA_TAG, XmlConsts.BALA_TAG);
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.SHADBALAS_TAG, null));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing shadbala xml ", exception);
        }
    }

    private void exportVargaCharts(PlanetaryInfo planetaryInfo) {
        try {
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.VARGA_CHART_TAG, null, null));
            for (Varga varga : Varga.values()) {
                new PlanetChartData(varga, planetaryInfo).doExport(this);
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.VARGA_CHART_TAG, null));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing varga charts", exception);
        }
    }

    @Override
    public void export(Vimshottari vimshottari) {
        try {
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.VIM_DASA_TAG, null, null));
            EnumMap<Planet, Dasa> enumMap = vimshottari.getDasa();
            StringBuilder stringBuilder = null;
            for (Planet planet : Planet.dasaLords(vimshottari.getStartLord())) {
                Dasa dasa = enumMap.get((Object)planet);
                this.xmlWriter.add(xmlef.createStartElement(XmlConsts.MAJOR_DASA_TAG, null, null));
                this.xmlWriter.add(xmlef.createAttribute("Dasa", planet.name() + " " + "Dasa"));
                stringBuilder = new StringBuilder(" ( ");
                stringBuilder.append(dasa.getStartDate());
                stringBuilder.append(" ~ ");
                stringBuilder.append(dasa.getEndDate());
                stringBuilder.append(" )");
                this.xmlWriter.add(xmlef.createAttribute("Period", stringBuilder.toString()));
                for (Dasa dasa2 : dasa.subDasas()) {
                    stringBuilder = new StringBuilder(dasa2.fullDasa());
                    stringBuilder.append(" ( ");
                    stringBuilder.append(dasa2.getStartDate());
                    stringBuilder.append(" ~ ");
                    stringBuilder.append(dasa2.getEndDate());
                    stringBuilder.append(" )");
                    Attribute attribute = xmlef.createAttribute("Dasa", stringBuilder.toString());
                    this.exportTableData(vimshottari.getVimDasaTableData(dasa2), Vimshottari.getVimDasaTableColumnMetaData(), XmlConsts.SUB_DASA_TAG, attribute, XmlConsts.ANTHARA_DASA_TAG);
                }
                this.xmlWriter.add(xmlef.createEndElement(XmlConsts.MAJOR_DASA_TAG, null));
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.VIM_DASA_TAG, null));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing vimshottari dasa", exception);
        }
    }

    @Override
    public void export(Horoscope horoscope) {
        try {
            this.xmlWriter.add(xmlef.createStartDocument());
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.ASTROSOFT_TAG, null, null));
            this.xmlWriter.add(xmlef.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
            this.xmlWriter.add(xmlef.createNamespace("av", "Ashtavarga"));
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.HOROSCOPE_TAG, null, null));
            this.xmlWriter.add(xmlef.createAttribute("Title", horoscope.getTitle()));
            this.exportTableData(horoscope.getInfoTableData(), XmlConsts.HOROSCOPE_INFO_TAG, XmlConsts.INFO_TAG);
            horoscope.getPlanetaryInfo().doExport(this);
            horoscope.getHousePosition().doExport(this);
            this.exportVargaCharts(horoscope.getPlanetaryInfo());
            horoscope.getAshtaVarga().doExport(this);
            horoscope.getShadBala().doExport(this);
            horoscope.getVimshottariDasa().doExport(this);
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.HOROSCOPE_TAG, null));
            this.xmlWriter.add(xmlef.createEndDocument());
            this.xmlWriter.close();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing horosocope xml document", exception);
        }
    }

    public static void main(String[] stringArray) {
        AstroSoft.getPreferences().setAyanamsa(Ayanamsa.KRISHNAMURTHI);
        AstroSoft.getPreferences().setLanguage(Language.TAMIL);
        Horoscope horoscope = new Horoscope("Raja", 11, 12, 1980, 1, 44, 77.73333333333333, 11.366666666666667, 5.5, "Erode");
        String string = "c:/astrosoft/resources/export/astrosoft.xml";
        HoroscopeExporter horoscopeExporter = new HoroscopeExporter(string);
        horoscopeExporter.export2Xml(horoscope);
        FOPTransformer.exportToPDF(string, "C:/AstroSoft/resources/export/horoscope2pdf.xsl", "C:/AstroSoft/resources/export/astrosoft.pdf");
    }
}

