/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.export;

import app.astrosoft.consts.XmlConsts;
import app.astrosoft.core.Panchang;
import app.astrosoft.core.PanchangList;
import app.astrosoft.export.AbstractExporter;
import app.astrosoft.export.FOPTransformer;
import app.astrosoft.export.HoroscopeExporter;
import app.astrosoft.ui.AstroSoft;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

public class PanchangExporter
extends AbstractExporter {
    private static final Logger log = Logger.getLogger(HoroscopeExporter.class.getName());
    private static SimpleDateFormat df = new SimpleDateFormat("MMM yyyy");

    public PanchangExporter(String string) {
        super(string);
    }

    @Override
    public void export(PanchangList panchangList) {
        try {
            this.xmlWriter.add(xmlef.createStartDocument());
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.ASTROSOFT_TAG, null, null));
            this.xmlWriter.add(xmlef.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.PANCHANG_TAG, null, null));
            this.xmlWriter.add(xmlef.createAttribute("Location", AstroSoft.getPreferences().getPlace().toString()));
            for (Panchang panchang : panchangList) {
                this.export(panchang);
            }
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.PANCHANG_INFO_TAG, null));
            this.xmlWriter.add(xmlef.createEndDocument());
            this.xmlWriter.close();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in writing panchang xml document", exception);
        }
    }

    private void export(Panchang panchang) throws XMLStreamException {
        Calendar calendar = panchang.getDate();
        if (calendar.get(5) == 1) {
            this.xmlWriter.add(xmlef.createStartElement(XmlConsts.MONTH_TAG, null, null));
            this.xmlWriter.add(xmlef.createAttribute("Title", "Panchang for " + df.format(panchang.getDate().getTime())));
        }
        this.exportTableData(panchang.getPanchangTableData(), XmlConsts.PANCHANG_INFO_TAG, XmlConsts.INFO_TAG);
        if (calendar.get(5) == calendar.getActualMaximum(5)) {
            this.xmlWriter.add(xmlef.createEndElement(XmlConsts.MONTH_TAG, null));
        }
    }

    public static void main(String[] stringArray) {
        PanchangList panchangList = new PanchangList(2007, 8);
        String string = "c:/astrosoft/resources/export/panchang.xml";
        PanchangExporter panchangExporter = new PanchangExporter(string);
        panchangExporter.export2Xml(panchangList);
        FOPTransformer.exportToPDF(string, "C:/AstroSoft/resources/export/panchang2pdf.xsl", "C:/AstroSoft/resources/export/panchang.pdf");
    }
}

