/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.export;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLHelper {
    private static final Logger log = Logger.getLogger(XMLHelper.class.getName());

    public static Document createDOM() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.log(Level.SEVERE, "Exception in creating document ", parserConfigurationException);
            return null;
        }
    }

    public static Element addRootElement(Document document, Object object) {
        Element element = document.createElement(object.toString());
        document.appendChild(element);
        return element;
    }

    public static Element addElement(Document document, Element element, Object object, String string) {
        Element element2 = document.createElement(object.toString());
        element.appendChild(element2);
        if (string != null) {
            element2.appendChild(document.createTextNode(string));
        }
        return element2;
    }

    public static Element addElement(Document document, Element element, Object object) {
        return XMLHelper.addElement(document, element, object, null);
    }

    public static void addAttribute(Element element, Object object, Object object2) {
        if (object2 == null) {
            element.setAttribute(object.toString(), "");
        } else {
            element.setAttribute(object.toString(), object2.toString());
        }
    }

    public static Map<String, String> getChildElements(Node node) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            hashMap.put(node2.getNodeName(), node2.getTextContent());
        }
        return hashMap;
    }

    public static Node getChildNode(Node node, String string) {
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!node3.getNodeName().equals(string)) continue;
            node2 = node3;
            break;
        }
        return node2;
    }

    public static Document parseXML(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new File(string));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.log(Level.SEVERE, "Exception in parsing XML ", parserConfigurationException);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Exception in parsing XML ", iOException);
        }
        catch (SAXException sAXException) {
            log.log(Level.SEVERE, "Exception in parsing XML ", sAXException);
        }
        return document;
    }

    public static void saveXML(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in creating document ", exception);
        }
    }
}

