/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class JPAUtil {
    private static final Logger log = Logger.getLogger(JPAUtil.class.getName());
    public static final String PERSISTENT_UNIT_NAME = "astrosoft";
    private static EntityManagerFactory emf = null;

    public static synchronized EntityManagerFactory getEntityManagerFactory() {
        if (!(emf != null && emf.isOpen() || JPAUtil.checkIfSchemaExists(emf = Persistence.createEntityManagerFactory((String)PERSISTENT_UNIT_NAME)))) {
            log.warning("DB Schema is not found, create new schema");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("hibernate.hbm2ddl.auto", "create");
            emf = Persistence.createEntityManagerFactory((String)PERSISTENT_UNIT_NAME, hashMap);
        }
        return emf;
    }

    public static synchronized void closeEntityManagerFactory() {
        if (emf != null) {
            emf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkIfSchemaExists(EntityManagerFactory entityManagerFactory) {
        boolean bl = true;
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        Query query = entityManager.createNamedQuery("findAllNames");
        query.setFirstResult(0);
        query.setMaxResults(1);
        try {
            List list = query.getResultList();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in querying names, Exception: ", exception);
            if (exception.getCause().getCause().getMessage().indexOf("Table not found") >= 0) {
                bl = false;
            }
        }
        finally {
            entityManager.close();
        }
        return bl;
    }
}

