/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.persistence;

import app.astrosoft.consts.AstrosoftTableColumn;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.DefaultColumnMetaData;
import app.astrosoft.ui.table.TableRowData;
import app.astrosoft.util.AstroUtil;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@NamedQueries(value={@NamedQuery(name="findAllNames", query="select n from NumerologicalName n  order by name ")})
@Entity(name="NumerologicalName")
@Table(name="NUMERO_NAME")
public class NumerologicalName
implements Serializable,
TableRowData {
    private static final long serialVersionUID = 1L;
    public static final String FIND_ALL_NAMES = "findAllNames";
    public static final String SELECT_NAME_SQL = "select n from NumerologicalName n ";
    public static final String ORDER_BY = " order by name ";
    @Id
    @GeneratedValue
    @Column(name="NAME_ID")
    private Long nameId;
    @Column(name="NAME", unique=true)
    private String name;
    @Column(name="NUMERO_VALUE")
    private int numeroVal = -1;
    @Column(name="NUMERO_NUMBER")
    private int numeroNum = -1;
    private static ColumnMetaData columnMetaData = new DefaultColumnMetaData(){
        {
            this.localizeColumns();
        }
    };

    private NumerologicalName() {
    }

    public NumerologicalName(String string) {
        this.setName(string);
        this.setNumeroVal(AstroUtil.computeNumeroVal(string));
    }

    public void setNameId(Long l) {
        this.nameId = l;
    }

    public Long getNameId() {
        return this.nameId;
    }

    public void setName(String string) {
        this.name = string.toUpperCase();
    }

    public String getName() {
        return this.name;
    }

    private void setNumeroVal(int n) {
        this.numeroVal = n;
        this.numeroNum = AstroUtil.toNumeroNum(n);
    }

    public int getNumeroVal() {
        return this.numeroVal;
    }

    public int getNumeroNum() {
        return this.numeroNum;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        stringBuilder.append(" : ");
        stringBuilder.append(this.numeroVal);
        stringBuilder.append(" : ");
        stringBuilder.append(this.numeroNum);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public Object getColumnData(AstrosoftTableColumn astrosoftTableColumn) {
        switch (astrosoftTableColumn) {
            case Name: {
                return this.getName();
            }
            case NumeroValue: {
                return this.getNumeroVal();
            }
            case NumeroNumber: {
                return this.getNumeroNum();
            }
        }
        return null;
    }

    public static ColumnMetaData getColumnMetaData() {
        return columnMetaData;
    }
}

