/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.pref;

import app.astrosoft.beans.Place;
import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.Language;
import app.astrosoft.util.AstroUtil;
import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class AstrosoftPref {
    private static final Logger log = Logger.getLogger(AstrosoftPref.class.getName());
    private static double defaultEphCalcTime = 0.0;
    private static double defaultPanCalcTime = 6.0;
    private static boolean defaultIsInitialized = false;
    public static String defaultAcrobatExecutable = "";
    private static String defaultAstrosoftFilesDir = System.getProperty("user.home") + File.separator;
    Preferences root = Preferences.systemNodeForPackage(AstrosoftPref.class);

    public AstrosoftPref() {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            defaultAstrosoftFilesDir = defaultAstrosoftFilesDir + File.separator + "My Documents" + File.separator;
        }
        if (!this.root.getBoolean(Preference.IsInitialized.name(), defaultIsInitialized)) {
            log.info("Initializing Astrosoft Preferences ");
            this.setDefaults();
        }
    }

    public void setLanguage(Language language) {
        this.root.put(Preference.Language.name(), language.name());
        this.flush();
    }

    public void setIsInitialized(boolean bl) {
        this.root.putBoolean(Preference.IsInitialized.name(), bl);
        this.flush();
    }

    public void setPanCalcTime(double d) {
        this.root.putDouble(Preference.PanCalcTime.name(), d);
        this.flush();
    }

    public void setEphCalcTime(double d) {
        this.root.putDouble(Preference.EphCalcTime.name(), d);
        this.flush();
    }

    public void setAyanamsa(Ayanamsa ayanamsa) {
        this.root.put(Preference.Ayanamsa.name(), ayanamsa.name());
        this.flush();
    }

    public void setPlace(Place place) {
        this.root.node(Preference.Place.name()).put(Preference.City.name(), place.city());
        this.root.node(Preference.Place.name()).put(Preference.State.name(), place.state());
        this.root.node(Preference.Place.name()).put(Preference.Country.name(), place.country());
        this.root.node(Preference.Place.name()).putDouble(Preference.Longitude.name(), place.longitude());
        this.root.node(Preference.Place.name()).putDouble(Preference.Latitude.name(), place.latitude());
        this.root.node(Preference.Place.name()).put(Preference.TimeZone.name(), place.astrosoftTimeZone().id());
        this.flush();
    }

    public void setAcrobatExecutable(String string) {
        this.root.put(Preference.AcrobatExe.name(), string);
        this.flush();
    }

    public void setAstrosoftFilesDir(String string) {
        this.root.put(Preference.AstrosoftFilesDir.name(), string);
        this.flush();
    }

    private void setDefaults() {
        this.setLanguage(Language.getDefault());
        this.setIsInitialized(true);
        this.setPanCalcTime(defaultPanCalcTime);
        this.setEphCalcTime(defaultEphCalcTime);
        this.setAyanamsa(Ayanamsa.getDefault());
        this.setPlace(Place.getDefault());
        this.setAcrobatExecutable(defaultAcrobatExecutable);
        this.setAstrosoftFilesDir(defaultAstrosoftFilesDir);
    }

    public void flush() {
        try {
            this.root.flush();
        }
        catch (BackingStoreException backingStoreException) {
            log.log(Level.SEVERE, "Exception in flusing preferences ", backingStoreException);
        }
    }

    public Ayanamsa getAyanamsa() {
        return Enum.valueOf(Ayanamsa.class, this.root.get(Preference.Ayanamsa.name(), Ayanamsa.getDefault().name()));
    }

    public Language getLanguage() {
        return Enum.valueOf(Language.class, this.root.get(Preference.Language.name(), Language.getDefault().name()));
    }

    public double getEphCalcTime() {
        return this.root.getDouble(Preference.EphCalcTime.name(), defaultEphCalcTime);
    }

    public double getPanCalcTime() {
        return this.root.getDouble(Preference.PanCalcTime.name(), defaultPanCalcTime);
    }

    public Place getPlace() {
        Place place = Place.getDefault();
        Preferences preferences = this.root.node("Place");
        String string = preferences.get(Preference.City.name(), place.city());
        String string2 = preferences.get(Preference.State.name(), place.state());
        String string3 = preferences.get(Preference.Country.name(), place.country());
        double d = preferences.getDouble(Preference.Latitude.name(), place.latitude());
        double d2 = preferences.getDouble(Preference.Longitude.name(), place.longitude());
        String string4 = preferences.get(Preference.TimeZone.name(), place.astrosoftTimeZone().id());
        return new Place(string, string2, string3, d, d2, string4);
    }

    public String getAcrobatExecutable() {
        return this.root.get(Preference.AcrobatExe.name(), defaultAcrobatExecutable);
    }

    public String getAstrosoftFilesDir() {
        return this.root.get(Preference.AstrosoftFilesDir.name(), defaultAstrosoftFilesDir);
    }

    private void clearAll() {
        try {
            this.root.clear();
            for (String string : this.root.childrenNames()) {
                this.root.node(string).removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AstrosoftPref astrosoftPref = new AstrosoftPref();
        astrosoftPref.root.exportSubtree(System.out);
    }

    public void preferenceChanged(Preference preference, Object object) {
        switch (preference) {
            case Language: {
                this.setLanguage((Language)((Object)object));
                break;
            }
            case Ayanamsa: {
                this.setAyanamsa((Ayanamsa)((Object)object));
                break;
            }
            case PanCalcTime: {
                this.setPanCalcTime(AstroUtil.dateToTimeDouble((Date)object));
                break;
            }
            case EphCalcTime: {
                this.setEphCalcTime(AstroUtil.dateToTimeDouble((Date)object));
                break;
            }
            case Place: {
                this.setPlace((Place)object);
            }
        }
        try {
            this.root.flush();
        }
        catch (BackingStoreException backingStoreException) {
            log.log(Level.SEVERE, "Exception in flusing preferences ", backingStoreException);
        }
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.root.addPreferenceChangeListener(preferenceChangeListener);
    }

    public static enum Preference {
        Language,
        PanCalcTime,
        EphCalcTime,
        Ayanamsa,
        Place,
        City,
        State,
        Country,
        Longitude,
        Latitude,
        TimeZone,
        IsInitialized,
        AcrobatExe,
        AstrosoftFilesDir;

    }
}

