/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.service;

import app.astrosoft.consts.Operator;
import app.astrosoft.persistence.JPAUtil;
import app.astrosoft.persistence.NumerologicalName;
import app.astrosoft.ui.comp.NumeroNamePagination;
import app.astrosoft.ui.dlg.OptionDialog;
import app.astrosoft.ui.table.ColumnMetaData;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;

public class NumeroNameService {
    private static final Logger log = Logger.getLogger("app.astrosoft.service");
    private static final int exportPageLen = 25;

    public static void addName(String string) {
        NumeroNameService.addName(new NumerologicalName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addName(NumerologicalName numerologicalName) {
        EntityManagerFactory entityManagerFactory = JPAUtil.getEntityManagerFactory();
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        try {
            entityManager.persist((Object)numerologicalName);
            entityTransaction.commit();
            log.log(Level.INFO, "Added Name " + numerologicalName);
        }
        catch (EntityExistsException entityExistsException) {
            log.warning("Name : " + numerologicalName.getName() + " already exists");
        }
        finally {
            entityManager.close();
        }
    }

    public static void deleteNames(List<NumerologicalName> list) {
        EntityManagerFactory entityManagerFactory = JPAUtil.getEntityManagerFactory();
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        for (NumerologicalName numerologicalName : list) {
            NumerologicalName numerologicalName2 = (NumerologicalName)entityManager.find(NumerologicalName.class, (Object)numerologicalName.getNameId());
            entityManager.remove((Object)numerologicalName2);
            log.log(Level.INFO, "Removed Name " + numerologicalName2);
        }
        entityTransaction.commit();
        entityManager.close();
    }

    public static List queryAllNames(int n, int n2) {
        EntityManager entityManager = JPAUtil.getEntityManagerFactory().createEntityManager();
        Query query = entityManager.createNamedQuery("findAllNames");
        query.setFirstResult(n);
        query.setMaxResults(n2);
        List list = query.getResultList();
        entityManager.close();
        return list;
    }

    public static TableData<NumerologicalName> findAllNames(int n, int n2) {
        return TableDataFactory.getTableData(NumeroNameService.queryAllNames(n, n2));
    }

    public static List queryDynamic(String string, String string2, String string3, Operator operator, Operator operator2, int n, int n2) {
        EntityManager entityManager = JPAUtil.getEntityManagerFactory().createEntityManager();
        Query query = entityManager.createQuery("select n from NumerologicalName n " + NumeroNameService.getSqlWhere(string, string2, string3, operator, operator2) + " order by name ");
        query.setFirstResult(n);
        query.setMaxResults(n2);
        List list = query.getResultList();
        entityManager.close();
        return list;
    }

    public static TableData<NumerologicalName> findDynamic(String string, String string2, String string3, Operator operator, Operator operator2, int n, int n2) {
        return TableDataFactory.getTableData(NumeroNameService.queryDynamic(string, string2, string3, operator, operator2, n, n2));
    }

    private static String getSqlWhere(String string, String string2, String string3, Operator operator, Operator operator2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append("name like '" + string.toUpperCase() + "%' ");
        }
        if (string2 != null && string2.trim().length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append((Object)operator);
            }
            stringBuilder.append(" numeroVal = " + string2 + " ");
        }
        if (string3 != null && string3.trim().length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append((Object)operator2);
            }
            stringBuilder.append(" numeroNum = " + string3 + " ");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.insert(0, "where ");
        }
        log.fine("SQL Where " + stringBuilder);
        return stringBuilder.toString();
    }

    public static void exportNames(String string) {
        if (string == null) {
            return;
        }
        ColumnMetaData columnMetaData = NumerologicalName.getColumnMetaData();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (TableData tableData : new NumeroNamePagination(25)) {
                bufferedWriter.write(TableDataFactory.toCSV(tableData, columnMetaData));
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Exception in exporting name ", iOException);
        }
        OptionDialog.showDialog("Exported Successfully.", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importNames(String string, boolean bl) {
        if (string == null) {
            return;
        }
        BufferedReader bufferedReader = null;
        EntityManager entityManager = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            entityManager = JPAUtil.getEntityManagerFactory().createEntityManager();
            EntityTransaction entityTransaction = entityManager.getTransaction();
            while ((string2 = bufferedReader.readLine()) != null) {
                entityTransaction.begin();
                if (bl) {
                    string2 = string2.split(",")[0];
                }
                try {
                    entityManager.persist((Object)new NumerologicalName(string2));
                    log.fine("Added name " + string2);
                    entityTransaction.commit();
                }
                catch (EntityExistsException entityExistsException) {
                    log.warning(string2 + " already exists");
                    entityTransaction.rollback();
                }
            }
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Exception in importing  name ", iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                log.log(Level.SEVERE, "Exception in importing  name ", iOException);
            }
            entityManager.close();
        }
        OptionDialog.showDialog("Imported Successfully.", 1);
    }

    public static void importNamesFromCSV(String string) {
        NumeroNameService.importNames(string, true);
    }

    public static void importNamesFromList(String string) {
        NumeroNameService.importNames(string, false);
    }
}

