/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui;

import app.astrosoft.beans.BirthData;
import app.astrosoft.beans.PlanetChartData;
import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.Command;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.consts.Nakshathra;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.Compactibility;
import app.astrosoft.core.Ephemeris;
import app.astrosoft.core.Horoscope;
import app.astrosoft.core.Muhurtha;
import app.astrosoft.core.Panchang;
import app.astrosoft.export.AstrosoftExporter;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.ui.AstrosoftActionHandler;
import app.astrosoft.ui.AstrosoftActionManager;
import app.astrosoft.ui.comp.AstrosoftMenuBar;
import app.astrosoft.ui.comp.AstrosoftToolBar;
import app.astrosoft.ui.comp.Chart;
import app.astrosoft.ui.comp.DateListener;
import app.astrosoft.ui.dlg.BirthInputDialog;
import app.astrosoft.ui.dlg.CompactibilityInputDialog;
import app.astrosoft.ui.dlg.ComputeNumberDialog;
import app.astrosoft.ui.dlg.ExportDialog;
import app.astrosoft.ui.dlg.MuhurthaInput;
import app.astrosoft.ui.dlg.OptionDialog;
import app.astrosoft.ui.dlg.PlaceOptionDialog;
import app.astrosoft.ui.dlg.PrintDialog;
import app.astrosoft.ui.dlg.TimeInputDialog;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.view.AshtavargaView;
import app.astrosoft.ui.view.BhavaView;
import app.astrosoft.ui.view.CompactibilityView;
import app.astrosoft.ui.view.EphemerisView;
import app.astrosoft.ui.view.FindNameView;
import app.astrosoft.ui.view.InfoView;
import app.astrosoft.ui.view.MuhurthaPanel;
import app.astrosoft.ui.view.PanchangView;
import app.astrosoft.ui.view.PlanetView;
import app.astrosoft.ui.view.ShadBalaView;
import app.astrosoft.ui.view.VargaChartView;
import app.astrosoft.ui.view.ViewContainer;
import app.astrosoft.ui.view.ViewManager;
import app.astrosoft.ui.view.VimDasaView;
import app.astrosoft.ui.view.YogaCombinationsView;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.AstrosoftFileFilter;
import app.astrosoft.util.FileOps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class AstroSoft
extends JFrame
implements AstrosoftActionHandler {
    private Horoscope h;
    private Ephemeris eph;
    private Panchang pan;
    private AstrosoftMenuBar mbar;
    private AstrosoftToolBar toolbar;
    private JPanel home;
    private AstrosoftActionManager actionMgr;
    private ViewManager viewManager;
    private Compactibility compactibility;
    private Muhurtha muhurtha;
    private static AstrosoftPref preferences = new AstrosoftPref();
    public static Calendar today = new GregorianCalendar(AstroSoft.getPreferences().getPlace().astrosoftTimeZone().getTimeZone());
    private static Rectangle bounds = new Rectangle(0, 0, AstroSoft.getScreenSize().width, AstroSoft.getScreenSize().height);

    private AstroSoft() {
        this.initComponents();
        System.out.println(AstroSoft.getScreenSize());
        this.setPreferredSize(AstroSoft.getScreenSize());
        this.getContentPane().setLayout(new BorderLayout());
        this.formMenuAndToolBar();
        this.home = new JPanel();
        this.home.setLayout(null);
        this.home.setBounds(bounds);
        this.enableActions(false);
        this.setVisible(true);
        this.pack();
        this.viewManager = new ViewManager(new AstrosoftViewContainer());
    }

    private AstroSoft(String[] stringArray) {
        this();
        System.out.println("Logging properties: " + System.getProperty("java.util.logging.config.file"));
        if (stringArray.length > 0 && stringArray[0] != null && !stringArray[0].trim().isEmpty()) {
            this.openHoroscope(stringArray[0]);
        }
    }

    public void formMenuAndToolBar() {
        this.actionMgr = new AstrosoftActionManager(this);
        this.mbar = new AstrosoftMenuBar(this.actionMgr);
        this.setJMenuBar(this.mbar);
        this.toolbar = new AstrosoftToolBar(this.actionMgr);
        this.add((Component)this.toolbar, "First");
    }

    private void initComponents() {
        this.setTitle("AstroSoft");
        this.setName("AstroSoft");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AstroSoft.this.exitForm(windowEvent);
            }
        });
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        AstroSoft.setUIDefaults();
        AstroSoft astroSoft = new AstroSoft(stringArray);
    }

    private static void setUIDefaults() {
        try {
            UIManager.setLookAndFeel(UIConsts.getLookAndFeel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Map map = UIConsts.getUIDefaults();
        for (Object k : map.keySet()) {
            UIManager.put(k, map.get(k));
        }
    }

    public void computeHoroscope(BirthData birthData) {
        this.h = new Horoscope(birthData);
        this.viewManager.showView(ViewManager.View.CHART_VIEW);
    }

    public JPanel createChartView() {
        InfoView infoView = new InfoView(this.h.getHoroscopeInfo(), new Point(20, 20));
        Chart chart = new Chart(new PlanetChartData(Varga.Rasi, this.h.getPlanetaryInfo()), new Dimension(360, 320));
        Chart chart2 = new Chart(new PlanetChartData(Varga.Navamsa, this.h.getPlanetaryInfo()), new Dimension(360, 320));
        JPanel jPanel = new JPanel();
        jPanel.add(infoView);
        jPanel.add(chart);
        jPanel.add(chart2);
        jPanel.setBounds(bounds);
        return jPanel;
    }

    @Override
    public void printHoroscope() {
        new PrintDialog(this);
    }

    public JPanel createShadbalaView() {
        if (this.h.getShadBala() != null) {
            return new ShadBalaView(this.h.getTitle(), this.h.getShadBala(), new Point(30, 20));
        }
        OptionDialog.showDialog("No ShadBala for Birth Year < 1900", 0);
        return this.createChartView();
    }

    @Override
    public void showPanchang(Calendar calendar) {
        this.pan = new Panchang(calendar);
        this.viewManager.showView(ViewManager.View.PANCHANG_VIEW);
    }

    public void displayCompactibility(Horoscope horoscope, Horoscope horoscope2) {
        this.compactibility = new Compactibility(horoscope, horoscope2);
        this.actionMgr.enableAction(Command.PRINT, true);
        this.viewManager.showView(ViewManager.View.COMPACTIBILITY_VIEW);
    }

    public void displayCompactibility(String string, String string2, Rasi rasi, Rasi rasi2, Nakshathra nakshathra, Nakshathra nakshathra2) {
        this.compactibility = new Compactibility(string, string2, nakshathra, nakshathra2, rasi, rasi2);
        this.actionMgr.enableAction(Command.PRINT, true);
        this.viewManager.showView(ViewManager.View.COMPACTIBILITY_VIEW);
    }

    public void displayMuhurtha(Muhurtha muhurtha) {
        this.muhurtha = muhurtha;
        this.viewManager.showView(ViewManager.View.MUHURTHA_VIEW);
    }

    @Override
    public void newHoroscope() {
        new BirthInputDialog(this);
        this.enableActions(true);
    }

    @Override
    public void openHoroscope() {
        String string = FileOps.openFileDialog(this, FileOps.FileDialogMode.OPEN, AstrosoftFileFilter.HOROSCOPE_EXTN);
        if (string != null) {
            this.openHoroscope(string);
        }
    }

    public void openHoroscope(String string) {
        this.h = Horoscope.createFromFile(string);
        if (this.h == null) {
            OptionDialog.showDialog(" Invalid File ", 0);
            this.repaint();
            this.setVisible(true);
            return;
        }
        this.enableActions(true);
        this.viewManager.showView(ViewManager.View.CHART_VIEW);
    }

    @Override
    public void saveHoroscope() {
        String string;
        if (this.h != null && (string = FileOps.openFileDialog(this, FileOps.FileDialogMode.SAVE, AstrosoftFileFilter.HOROSCOPE_EXTN)) != null) {
            this.h.saveToFile(string);
        }
    }

    @Override
    public void openCompactibility() {
        String string = FileOps.openFileDialog(this, FileOps.FileDialogMode.OPEN, AstrosoftFileFilter.COMPACTIBILITY_EXTN);
        if (string != null) {
            this.compactibility = Compactibility.createFromXML(string);
            if (this.compactibility != null) {
                this.actionMgr.enableAction(Command.PRINT, true);
                this.viewManager.showView(ViewManager.View.COMPACTIBILITY_VIEW);
            }
        }
    }

    @Override
    public void editCompactibility() {
        if (this.compactibility != null) {
            if (this.compactibility.hasHoroscope()) {
                new CompactibilityInputDialog(this, this.compactibility.getBoyBirthData(), this.compactibility.getGirlBirthData());
            } else {
                new CompactibilityInputDialog(this, this.compactibility.getBoyName(), this.compactibility.getGirlName(), this.compactibility.getBoyRasi(), this.compactibility.getGirlRasi(), this.compactibility.getBoyNak(), this.compactibility.getGirlNak());
            }
        }
    }

    @Override
    public void saveCompactibility() {
        String string;
        if (this.compactibility != null && (string = FileOps.openFileDialog(this, FileOps.FileDialogMode.SAVE, AstrosoftFileFilter.COMPACTIBILITY_EXTN)) != null) {
            this.compactibility.saveToXML(string);
        }
    }

    @Override
    public void editHoroscope() {
        new BirthInputDialog(this, this.h.getBirthData());
    }

    @Override
    public void exportHoroscope2Pdf() {
        if (this.h != null) {
            String string = FileOps.openFileDialog(this, FileOps.FileDialogMode.SAVE, AstrosoftFileFilter.PDF_EXTN);
            FutureTask<Object> futureTask = AstrosoftExporter.export2Pdf(AstrosoftExporter.Type.Horosocope, this.h, string);
            ExportDialog exportDialog = new ExportDialog(this, "Export Horosocope ", futureTask, string);
        }
    }

    @Override
    public void exportCompactibility2Pdf() {
        if (this.compactibility != null) {
            String string = FileOps.openFileDialog(this, FileOps.FileDialogMode.SAVE, AstrosoftFileFilter.PDF_EXTN);
            AstrosoftExporter.export2Pdf(AstrosoftExporter.Type.Compactibility, this.compactibility, string);
        }
    }

    @Override
    public void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void setDefaultCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void computeNumeroNumber() {
        new ComputeNumberDialog(this);
    }

    private void optionAyanamsaChanged(Ayanamsa ayanamsa) {
        if (this.eph != null) {
            this.eph.setAyanamsa(ayanamsa);
            this.viewManager.showView(ViewManager.View.EPHEMERIS_VIEW);
        }
        if (this.pan != null) {
            this.viewManager.showView(ViewManager.View.PANCHANG_VIEW);
        }
        if (this.h != null) {
            this.h.setAyanamsa(ayanamsa);
            this.viewManager.showView(ViewManager.View.CHART_VIEW);
        }
    }

    private void optionLangChanged(String string) {
        if (this.eph != null) {
            this.viewManager.showView(ViewManager.View.EPHEMERIS_VIEW);
        }
        if (this.pan != null) {
            this.viewManager.showView(ViewManager.View.PANCHANG_VIEW);
        }
        if (this.h != null) {
            this.h.languageChanged();
            this.viewManager.showView(ViewManager.View.CHART_VIEW);
        }
    }

    @Override
    public void optionChanged(final AstrosoftPref.Preference preference) {
        DateListener dateListener = new DateListener(){

            @Override
            public void dateChanged(Date date) {
                preferences.preferenceChanged(preference, date);
            }
        };
        switch (preference) {
            case Place: {
                new PlaceOptionDialog(this);
                break;
            }
            case EphCalcTime: {
                new TimeInputDialog(DisplayStrings.EPH_TIME_STR, this, AstroUtil.doubleTimeToDate(preferences.getEphCalcTime()), dateListener);
                break;
            }
            case PanCalcTime: {
                new TimeInputDialog(DisplayStrings.PAN_TIME_STR, this, AstroUtil.doubleTimeToDate(preferences.getPanCalcTime()), dateListener);
            }
        }
    }

    public void enableActions(boolean bl) {
        EnumSet<Command[]> enumSet = EnumSet.of(Command.SAVE, new Command[]{Command.SAVE_COMPACTIBILITY, Command.EDIT_COMPACTIBILITY, Command.EDIT_CHART, Command.CHART_VIEW, Command.PLANET_POS_VIEW, Command.BHAVA_POS_VIEW, Command.DIV_CHART_VIEW, Command.ASHTAVARGA_VIEW, Command.SHADBALA_VIEW, Command.YOGA_COMBINATIONS_VIEW, Command.DASAS_VIEW});
        this.actionMgr.enableActions(enumSet, bl);
    }

    @Override
    public void viewChanged(ViewManager.View view) {
        switch (view) {
            case EPHEMERIS_VIEW: {
                this.eph = new Ephemeris(AstroUtil.getCalendar(), Ephemeris.Mode.Daily);
                this.viewManager.showView(view);
                break;
            }
            case PANCHANG_VIEW: {
                this.pan = new Panchang(today);
                this.viewManager.showView(view);
                break;
            }
            case COMPACTIBILITY_VIEW: {
                new CompactibilityInputDialog(this);
                break;
            }
            case MUHURTHA_VIEW: {
                new MuhurthaInput(this);
                break;
            }
            default: {
                this.viewManager.showView(view);
            }
        }
    }

    public void refreshUI() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.toolbar, "First");
        this.getContentPane().add((Component)this.home, "Center");
        this.repaint();
        this.setVisible(true);
    }

    @Override
    public void optionChanged(AstrosoftPref.Preference preference, Object object) {
        preferences.preferenceChanged(preference, object);
        switch (preference) {
            case Ayanamsa: {
                this.optionAyanamsaChanged((Ayanamsa)((Object)object));
                break;
            }
            case Language: {
                this.optionLangChanged(((Language)((Object)object)).name());
            }
        }
    }

    public static AstrosoftPref getPreferences() {
        return preferences;
    }

    public Horoscope getHoroscope() {
        return this.h;
    }

    public Compactibility getCompactibility() {
        return this.compactibility;
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    private class AstrosoftViewContainer
    implements ViewContainer {
        private AstrosoftViewContainer() {
        }

        @Override
        public void addView(JPanel jPanel) {
            AstroSoft.this.home.removeAll();
            AstroSoft.this.home.add(jPanel);
            AstroSoft.this.refreshUI();
        }

        @Override
        public JPanel createView(ViewManager.View view) {
            switch (view) {
                case CHART_VIEW: {
                    return AstroSoft.this.createChartView();
                }
                case DASAS_VIEW: {
                    return new VimDasaView(AstroSoft.this.h.getTitle(), AstroSoft.this.h.getVimshottariDasa());
                }
                case BHAVA_POS_VIEW: {
                    return new BhavaView(AstroSoft.this.h.getTitle(), AstroSoft.this.h.getHousePosition());
                }
                case PLANET_POS_VIEW: {
                    return new PlanetView(AstroSoft.this.h.getTitle(), AstroSoft.this.h.getPlanetaryInfo());
                }
                case SHADBALA_VIEW: {
                    return AstroSoft.this.createShadbalaView();
                }
                case DIV_CHART_VIEW: {
                    return new VargaChartView(AstroSoft.this.h.getTitle(), AstroSoft.this.h.getPlanetaryInfo());
                }
                case ASHTAVARGA_VIEW: {
                    return new AshtavargaView(AstroSoft.this.h.getTitle(), AstroSoft.this.h.getAshtaVarga(), new Point(30, 20));
                }
                case PANCHANG_VIEW: {
                    return new PanchangView(AstroSoft.this.pan, new Point(30, 20));
                }
                case EPHEMERIS_VIEW: {
                    return new EphemerisView(AstroSoft.this.eph, new Point(10, 2));
                }
                case COMPACTIBILITY_VIEW: {
                    AstroSoft.this.actionMgr.enableActions(EnumSet.of(Command.SAVE_COMPACTIBILITY), true);
                    return new CompactibilityView(DisplayStrings.MRAG_COMP_STR.toString(Language.ENGLISH), AstroSoft.this.compactibility, new Point(30, 20));
                }
                case MUHURTHA_VIEW: {
                    return new MuhurthaPanel(AstroSoft.this.muhurtha, AstroSoft.this);
                }
                case FIND_NAME_VIEW: {
                    return new FindNameView();
                }
                case YOGA_COMBINATIONS_VIEW: {
                    return new YogaCombinationsView(AstroSoft.this.h.getTitle(), AstroSoft.this.h.getYogaCombinations(), AstroSoft.this.h.getPlanetaryInfo());
                }
            }
            return null;
        }
    }
}

