/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui;

import app.astrosoft.consts.Ayanamsa;
import app.astrosoft.consts.Command;
import app.astrosoft.consts.Language;
import app.astrosoft.pref.AstrosoftPref;
import app.astrosoft.service.NumeroNameService;
import app.astrosoft.ui.AstrosoftActionHandler;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.ui.view.ViewManager;
import app.astrosoft.util.AstrosoftFileFilter;
import app.astrosoft.util.FileOps;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class AstrosoftAction
extends AbstractAction {
    private static final Logger log = Logger.getLogger(AstrosoftAction.class.getName());
    AstrosoftActionHandler handler;

    public AstrosoftAction(Command command, AstrosoftActionHandler astrosoftActionHandler) {
        super(command.action(), UIUtil.createImageIcon(command.action()));
        this.handler = astrosoftActionHandler;
        this.putValue("ShortDescription", command.action());
        this.putValue("ActionCommandKey", command.name());
        if (command.mnemonic() != -1) {
            this.putValue("MnemonicKey", command.mnemonic());
        }
        if (command.key() != null) {
            this.putValue("AcceleratorKey", command.key());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Command command = Command.valueOf(actionEvent.getActionCommand());
        if (command.equals((Object)Command.NEW)) {
            this.handler.newHoroscope();
        } else if (command.equals((Object)Command.OPEN)) {
            this.handler.openHoroscope();
        } else if (command.equals((Object)Command.OPEN_COMPACTIBILITY)) {
            this.handler.openCompactibility();
        } else if (command.equals((Object)Command.SAVE)) {
            this.handler.saveHoroscope();
        } else if (command.equals((Object)Command.SAVE_COMPACTIBILITY)) {
            this.handler.saveCompactibility();
        } else if (command.equals((Object)Command.PRINT)) {
            this.handler.printHoroscope();
        } else if (command.equals((Object)Command.EXIT)) {
            System.exit(0);
        } else if (command.equals((Object)Command.EDIT_CHART)) {
            this.handler.editHoroscope();
        } else if (command.equals((Object)Command.EDIT_COMPACTIBILITY)) {
            this.handler.editCompactibility();
        } else if (ViewManager.View.commands().contains((Object)command)) {
            this.handler.viewChanged(ViewManager.View.valueOf(command.name()));
        } else if (command.equals((Object)Command.AY_KM)) {
            this.handler.optionChanged(AstrosoftPref.Preference.Ayanamsa, (Object)Ayanamsa.KRISHNAMURTHI);
        } else if (command.equals((Object)Command.AY_LAH)) {
            this.handler.optionChanged(AstrosoftPref.Preference.Ayanamsa, (Object)Ayanamsa.LAHARI);
        } else if (command.equals((Object)Command.AY_RAM)) {
            this.handler.optionChanged(AstrosoftPref.Preference.Ayanamsa, (Object)Ayanamsa.RAMAN);
        } else if (command.equals((Object)Command.LANG_EN)) {
            this.handler.optionChanged(AstrosoftPref.Preference.Language, (Object)Language.ENGLISH);
        } else if (command.equals((Object)Command.LANG_TA)) {
            this.handler.optionChanged(AstrosoftPref.Preference.Language, (Object)Language.TAMIL);
        } else if (Command.optionMenuItems().contains((Object)command)) {
            this.handler.optionChanged(AstrosoftPref.Preference.valueOf(command.name()));
        } else if (command.equals((Object)Command.COMPUTE_NUMBER)) {
            log.fine("COMPUTE_NUMBER menu clicked");
            this.handler.computeNumeroNumber();
        } else if (command.equals((Object)Command.EXPORT_NAME_DB)) {
            log.fine("EXPORT_NAME_DB");
            String string = FileOps.openFileDialog(null, FileOps.FileDialogMode.SAVE, AstrosoftFileFilter.ALL_FILES);
            if (string != null) {
                this.handler.setWaitCursor();
                NumeroNameService.exportNames(string);
                this.handler.setDefaultCursor();
            } else {
                log.warning("No file selected");
            }
        } else if (command.equals((Object)Command.IMPORT_NAME_DB)) {
            log.fine("IMPORT_NAME_DB");
            String string = FileOps.openFileDialog(null, FileOps.FileDialogMode.OPEN, AstrosoftFileFilter.ALL_FILES);
            if (string != null) {
                this.handler.setWaitCursor();
                NumeroNameService.importNamesFromCSV(string);
                this.handler.setDefaultCursor();
            } else {
                log.warning("No file selected");
            }
        } else if (command.equals((Object)Command.IMPORT_NAME)) {
            log.fine("IMPORT_NAME");
            String string = FileOps.openFileDialog(null, FileOps.FileDialogMode.OPEN, AstrosoftFileFilter.ALL_FILES);
            if (string != null) {
                this.handler.setWaitCursor();
                NumeroNameService.importNamesFromList(string);
                this.handler.setDefaultCursor();
            } else {
                log.warning("No file selected");
            }
        } else if (command.equals((Object)Command.EXPORT_HOROSCOPE_TO_PDF)) {
            log.fine("EXPORT_HOROSCOPE_TO_PDF menu clicked");
            this.handler.exportHoroscope2Pdf();
        } else if (command.equals((Object)Command.EXPORT_COMPACTIBILITY_TO_PDF)) {
            log.fine("EXPORT_COMPACTIBILITY_TO_PDF menu clicked");
            this.handler.exportCompactibility2Pdf();
        }
    }
}

