/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.cal;

import app.astrosoft.ui.cal.ButtonItemListener;
import app.astrosoft.ui.cal.ComboBoxItemListener;
import app.astrosoft.ui.cal.JDayButton;
import app.astrosoft.ui.cal.JDayLabel;
import app.astrosoft.ui.util.UIConsts;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class JCalendar
extends JPanel {
    private int[][] days = new int[7][6];
    private JPanel daysPanel;
    private JPanel datePanel;
    private JPanel currentDatePanel;
    private String daySelected;
    private String monthSelected;
    private String yearSelected;
    private JPanel centrePanel;
    public JComboBox yearCombo;
    public JComboBox monthCombo;
    private Calendar calendar;
    protected ButtonItemListener buttonItemListener;
    private int showForYear;
    private int showForMonth;
    private ComboBoxItemListener comboBoxListener;
    private boolean showCalendarForDateSelected;
    private boolean showCurrentDate;
    private int firstDay;
    private JLabel currentDateLabel;
    private int startYear;
    private int endYear;

    protected JCalendar() {
        this.startYear = 1901;
        this.endYear = 2099;
        this.firstDay = 0;
        this.showCurrentDate = false;
        this.initializeVariables();
        this.setBackground(new Color(255, 255, 255));
    }

    protected JCalendar(int n, boolean bl) {
        this.startYear = 1901;
        this.endYear = 2099;
        this.firstDay = n;
        this.showCurrentDate = bl;
        this.initializeVariables();
    }

    protected JCalendar(int n, boolean bl, int n2, int n3) {
        this.startYear = n2;
        this.endYear = n3;
        this.firstDay = n;
        this.showCurrentDate = bl;
        this.initializeVariables();
    }

    private void initializeVariables() {
        this.buttonItemListener = new ButtonItemListener(this);
        this.comboBoxListener = new ComboBoxItemListener(this);
        this.calendar = Calendar.getInstance();
        this.showForYear = this.calendar.get(1);
        this.showForMonth = this.calendar.get(2);
        this.daySelected = new Integer(this.calendar.get(5)).toString();
        this.monthSelected = new Integer(this.calendar.get(2) + 1).toString();
        this.yearSelected = new Integer(this.calendar.get(1)).toString();
        this.datePanel = new JPanel();
        this.datePanel.setLayout(new BorderLayout());
        this.yearCombo = this.createYearCombo();
        this.yearCombo.setFont(this.yearCombo.getFont().deriveFont(1, 11.0f));
        this.monthCombo = this.createMonthCombo();
        this.monthCombo.setFont(this.monthCombo.getFont().deriveFont(1, 11.0f));
        this.datePanel.add((Component)this.yearCombo, "East");
        this.datePanel.add((Component)this.monthCombo, "Center");
        this.centrePanel = new JPanel();
        this.centrePanel.setBackground(new Color(255, 255, 255));
        this.centrePanel.setLayout(new BorderLayout(5, 5));
        this.centrePanel.add((Component)this.datePanel, "North");
        if (this.showCurrentDate) {
            this.currentDateLabel = new JLabel("Today's Date : " + this.daySelected + "/" + this.monthSelected + "/" + this.yearSelected);
            this.currentDateLabel.setFont(this.currentDateLabel.getFont().deriveFont(1, 11.0f));
            this.currentDatePanel = new JPanel();
            this.currentDatePanel.setLayout(new FlowLayout(1));
            this.currentDatePanel.setBorder(BorderFactory.createEtchedBorder());
            this.currentDatePanel.add(this.currentDateLabel);
            this.centrePanel.add((Component)this.currentDatePanel, "South");
        }
        this.add(this.centrePanel);
        this.yearCombo.addItemListener(this.comboBoxListener);
        this.monthCombo.addItemListener(this.comboBoxListener);
    }

    protected final void initializeCalendar() {
        this.monthCombo.removeItemListener(this.comboBoxListener);
        this.yearCombo.removeItemListener(this.comboBoxListener);
        if (this.showCalendarForDateSelected) {
            this.monthCombo.setSelectedIndex(this.showForMonth - 1);
        } else {
            this.monthCombo.setSelectedIndex(this.showForMonth);
        }
        this.yearCombo.setSelectedItem(new Integer(this.showForYear));
        this.days = this.showCalendarForDateSelected ? this.createCalendar(this.showForYear, this.showForMonth - 1) : this.createCalendar(this.showForYear, this.showForMonth);
        if (this.daysPanel != null) {
            this.centrePanel.remove(this.daysPanel);
        }
        this.createDaysPanel();
        this.centrePanel.add((Component)this.daysPanel, "Center");
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.monthCombo.addItemListener(this.comboBoxListener);
        this.yearCombo.addItemListener(this.comboBoxListener);
    }

    private final int[][] createCalendar(int n, int n2) {
        boolean bl = false;
        this.days = new int[7][6];
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, 1);
        int n3 = calendar.get(7);
        int n4 = 1;
        for (int i = 0; i < 6; ++i) {
            int n5 = 0;
            if (i == 0) {
                if (this.firstDay == 0) {
                    n5 = n3 - 1;
                } else {
                    n5 = n3 - 2;
                    if (n5 < 0) {
                        n5 = 6;
                    }
                }
            }
            while (n5 < 7) {
                this.days[n5][i] = n4;
                if (n2 <= 6) {
                    if (n2 % 2 == 0) {
                        if (n4 == 31) {
                            bl = true;
                            break;
                        }
                    } else if (n2 == 1) {
                        if (n % 4 == 0) {
                            if (n4 == 29) {
                                bl = true;
                                break;
                            }
                        } else if (n4 == 28) {
                            bl = true;
                            break;
                        }
                    } else if (n4 == 30) {
                        bl = true;
                        break;
                    }
                } else if (n2 % 2 == 0) {
                    if (n4 == 30) {
                        bl = true;
                        break;
                    }
                } else if (n4 == 31) {
                    bl = true;
                    break;
                }
                ++n4;
                ++n5;
            }
            if (bl) break;
        }
        return this.days;
    }

    private final JComboBox createYearCombo() {
        JComboBox<Integer> jComboBox = new JComboBox<Integer>();
        for (int i = this.startYear; i <= this.endYear; ++i) {
            jComboBox.addItem(new Integer(i));
        }
        jComboBox.setBackground(new Color(255, 255, 255));
        return jComboBox;
    }

    private final JComboBox createMonthCombo() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("January");
        jComboBox.addItem("February");
        jComboBox.addItem("March");
        jComboBox.addItem("April");
        jComboBox.addItem("May");
        jComboBox.addItem("June");
        jComboBox.addItem("July");
        jComboBox.addItem("August");
        jComboBox.addItem("September");
        jComboBox.addItem("October");
        jComboBox.addItem("November");
        jComboBox.addItem("December");
        jComboBox.setBackground(new Color(255, 255, 255));
        return jComboBox;
    }

    private final void createDaysPanel() {
        this.daysPanel = new JPanel();
        this.daysPanel.setBackground(UIConsts.CAL_COMBO_BACKGROUND);
        this.daysPanel.setBorder(BorderFactory.createEtchedBorder());
        this.daysPanel.setLayout(new GridLayout(7, 7));
        JDayLabel jDayLabel = new JDayLabel(" Sun ");
        JDayLabel jDayLabel2 = new JDayLabel(" Mon ");
        JDayLabel jDayLabel3 = new JDayLabel(" Tue ");
        JDayLabel jDayLabel4 = new JDayLabel(" Wed ");
        JDayLabel jDayLabel5 = new JDayLabel(" Thu ");
        JDayLabel jDayLabel6 = new JDayLabel(" Fri ");
        JDayLabel jDayLabel7 = new JDayLabel(" Sat ");
        jDayLabel.setForeground(Color.RED);
        if (this.firstDay == 0) {
            this.daysPanel.add(jDayLabel);
            this.daysPanel.add(jDayLabel2);
            this.daysPanel.add(jDayLabel3);
            this.daysPanel.add(jDayLabel4);
            this.daysPanel.add(jDayLabel5);
            this.daysPanel.add(jDayLabel6);
            this.daysPanel.add(jDayLabel7);
        } else {
            this.daysPanel.add(jDayLabel2);
            this.daysPanel.add(jDayLabel3);
            this.daysPanel.add(jDayLabel4);
            this.daysPanel.add(jDayLabel5);
            this.daysPanel.add(jDayLabel6);
            this.daysPanel.add(jDayLabel7);
            this.daysPanel.add(jDayLabel);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                JDayButton jDayButton;
                if (this.days[j][i] == 0) {
                    jDayButton = new JDayButton();
                    this.daysPanel.add(jDayButton);
                    continue;
                }
                jDayButton = new JDayButton(new Integer(this.days[j][i]).toString());
                Integer n = (Integer)this.yearCombo.getSelectedItem();
                if (this.days[j][i] == new Integer(this.daySelected) && this.monthCombo.getSelectedIndex() == new Integer(this.monthSelected) - 1 && n.intValue() == new Integer(this.yearSelected).intValue()) {
                    jDayButton.setForeground(Color.RED);
                    jDayButton.setSelected(true);
                }
                jDayButton.addItemListener(this.buttonItemListener);
                buttonGroup.add(jDayButton);
                this.daysPanel.add(jDayButton);
            }
        }
    }

    protected void showCalendarForDate(int n, int n2) {
        this.showForMonth = n2;
        this.showForYear = n;
        this.showCalendarForDateSelected = true;
    }

    protected void setDay(String string) {
        this.daySelected = string;
    }

    protected void setMonth(String string) {
        this.monthSelected = string;
    }

    protected void setYear(String string) {
        this.yearSelected = string;
    }

    protected String getDay() {
        return this.daySelected;
    }

    protected String getMonth() {
        return this.monthSelected;
    }

    protected String getYear() {
        return this.yearSelected;
    }
}

