/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.cal;

import app.astrosoft.ui.cal.JCalendar;
import app.astrosoft.ui.util.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicArrowButton;

public class JCalendarCombo
extends JPanel
implements Observer {
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    private boolean condition = false;
    private JWindow window;
    private JCalendar calendar;
    private JTextField textField;
    private int startYear;
    private int endYear;

    public JCalendarCombo() {
        this.startYear = 1801;
        this.endYear = 2099;
        this.calendar = new JCalendar();
        this.initializeJCalendarCombo();
    }

    public JCalendarCombo(int n, boolean bl) {
        this.startYear = 1801;
        this.endYear = 2099;
        this.calendar = new JCalendar(n, bl);
        this.initializeJCalendarCombo();
    }

    public JCalendarCombo(int n, boolean bl, int n2, int n3) {
        this.startYear = n2;
        this.endYear = n3;
        this.calendar = new JCalendar(n, bl, n2, n3);
        this.initializeJCalendarCombo();
    }

    private final void initializeJCalendarCombo() {
        this.textField = new JTextField(10);
        this.textField.setEditable(false);
        this.textField.setBackground(new Color(255, 255, 255));
        BasicArrowButton basicArrowButton = new BasicArrowButton(5, new Color(255, 255, 255), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)basicArrowButton, "East");
        this.setSelectedDate();
        basicArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!JCalendarCombo.this.condition) {
                    JCalendarCombo.this.condition = true;
                    JCalendarCombo.this.window = new JWindow((Window)JCalendarCombo.this.textField.getTopLevelAncestor());
                    JCalendarCombo.this.window.getContentPane().setLayout(new BorderLayout());
                    JCalendarCombo.this.calendar.initializeCalendar();
                    JCalendarCombo.this.window.getContentPane().add((Component)JCalendarCombo.this.calendar, "Center");
                    JCalendarCombo.this.window.pack();
                    UIUtil.setWindowLocation(JCalendarCombo.this.window, JCalendarCombo.this.textField);
                    JCalendarCombo.this.window.setVisible(true);
                } else {
                    JCalendarCombo.this.window.dispose();
                    JCalendarCombo.this.setSelectedDate();
                    JCalendarCombo.this.condition = false;
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (JCalendarCombo.this.condition) {
                    JCalendarCombo.this.condition = false;
                    JCalendarCombo.this.setSelectedDate();
                    JCalendarCombo.this.window.dispose();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (JCalendarCombo.this.condition) {
                    JCalendarCombo.this.condition = false;
                    JCalendarCombo.this.setSelectedDate();
                    JCalendarCombo.this.window.dispose();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (JCalendarCombo.this.condition) {
                    JCalendarCombo.this.condition = false;
                    JCalendarCombo.this.setSelectedDate();
                    JCalendarCombo.this.window.dispose();
                }
            }
        });
        this.calendar.buttonItemListener.addObserver(this);
    }

    private final void setSelectedDate() {
        this.textField.setText(this.calendar.getDay() + "/" + this.calendar.getMonth() + "/" + this.calendar.getYear());
        this.condition = false;
    }

    public final void setSelectedDate(int n, int n2, int n3) {
        this.calendar.setDay(new Integer(n3).toString());
        this.calendar.setMonth(new Integer(n2).toString());
        this.calendar.setYear(new Integer(n).toString());
        this.calendar.showCalendarForDate(n, n2);
        this.textField.setText(this.calendar.getDay() + "/" + this.calendar.getMonth() + "/" + this.calendar.getYear());
        this.condition = false;
    }

    public final String getSelectedDate() {
        return this.textField.getText();
    }

    public final String getSelectedDay() {
        return this.calendar.getDay();
    }

    public final String getSelectedMonth() {
        return this.calendar.getMonth();
    }

    public final String getSelectedYear() {
        return this.calendar.getYear();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.window.dispose();
        this.setSelectedDate();
    }
}

