/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.ui.comp.Pagination;
import app.astrosoft.ui.table.TableData;
import app.astrosoft.ui.table.TableDataFactory;
import app.astrosoft.ui.table.TableRowData;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class AbstractPagination<E extends TableRowData>
implements Pagination<E> {
    private static final Logger log = Logger.getLogger(AbstractPagination.class.getName());
    protected int currentPage;
    protected int pageLength;
    protected int totalPages;
    protected boolean isFirstPage;
    protected boolean isLastPage;
    protected Iterator<TableData<E>> pageIterator;

    public AbstractPagination(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid Page Length " + n);
        }
        this.pageLength = n;
        this.initialize();
    }

    private void initialize() {
        this.isFirstPage = true;
        this.isLastPage = false;
        this.currentPage = 0;
        this.totalPages = 0;
        this.pageIterator = null;
    }

    public AbstractPagination() {
        this(10);
    }

    @Override
    public TableData<E> getNextPage() {
        if (this.isLastPage) {
            this.currentPage = this.totalPages + 1;
            log.fine("You are in last page ");
            return TableDataFactory.emptyTableData();
        }
        ++this.currentPage;
        this.totalPages = this.currentPage;
        return this.getPage();
    }

    @Override
    public TableData<E> getPreviousPage() {
        if (this.isFirstPage) {
            this.currentPage = 0;
            log.fine("You are in first page ");
            return TableDataFactory.emptyTableData();
        }
        --this.currentPage;
        return this.getPage();
    }

    @Override
    public TableData<E> getPage(int n) {
        this.currentPage = n;
        return this.getPage();
    }

    private TableData<E> getPage() {
        log.info("Showing Page ( " + this.currentPage + " )");
        TableData<E> tableData = this.getData((this.currentPage - 1) * this.pageLength, this.pageLength);
        this.isFirstPage = this.currentPage == 1;
        this.isLastPage = tableData.getRowCount() < this.pageLength;
        return tableData;
    }

    protected abstract TableData<E> getData(int var1, int var2);

    @Override
    public void setPageLength(int n) {
        this.pageLength = n;
        this.initialize();
    }

    @Override
    public Iterator<TableData<E>> iterator() {
        if (this.pageIterator == null) {
            this.pageIterator = new Iterator<TableData<E>>(){

                @Override
                public boolean hasNext() {
                    return !AbstractPagination.this.isLastPage;
                }

                @Override
                public TableData<E> next() {
                    return AbstractPagination.this.getNextPage();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported for pagination");
                }
            };
        }
        return this.pageIterator;
    }

    @Override
    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    @Override
    public boolean isLastPage() {
        return this.isLastPage;
    }

    @Override
    public int getTotalPages() {
        return this.totalPages;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public int getPageLength() {
        return this.pageLength;
    }
}

