/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.beans.BirthData;
import app.astrosoft.beans.Place;
import app.astrosoft.consts.Command;
import app.astrosoft.consts.DisplayStrings;
import app.astrosoft.consts.Language;
import app.astrosoft.export.XMLHelper;
import app.astrosoft.ui.cal.JCalendarCombo;
import app.astrosoft.ui.comp.CalendarChooser;
import app.astrosoft.ui.comp.PlaceChooser;
import app.astrosoft.ui.util.SpringUtilities;
import app.astrosoft.ui.util.UIConsts;
import app.astrosoft.ui.util.UIUtil;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.AstrosoftFileFilter;
import app.astrosoft.util.FileOps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingWorker;

public class BirthDataPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(BirthDataPanel.class.getName());
    private JLabel l_name = new JLabel(DisplayStrings.NAME_STR.toString(Language.ENGLISH));
    private JLabel l_date = new JLabel(DisplayStrings.DATE_STR.toString(Language.ENGLISH));
    private JTextField name = new JTextField();
    private JButton openButton = new JButton(UIUtil.createImageIcon(Command.OPEN.name()));
    private CalendarChooser timeChooser;
    private JCalendarCombo jCalendarCombo;
    private PlaceChooser placeChooser;
    private Dimension panelSize;
    private String title;
    private Worker w = new Worker();

    public BirthDataPanel(Dimension dimension, String string) {
        this.panelSize = dimension;
        this.title = string;
        this.w.execute();
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BirthDataPanel.this.browseHoroscope();
            }
        });
        this.addComponents();
        this.setPreferredSize(this.panelSize);
    }

    private void addComponents() {
        this.setLayout(new SpringLayout());
        this.timeChooser = CalendarChooser.getTimeChooser();
        this.jCalendarCombo = new JCalendarCombo(0, false, 1801, 2099);
        JPanel jPanel = this.timeChooser.getChooser(DisplayStrings.BIRTH_TIME_STR.toString());
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.add(this.name);
        jPanel2.add(this.openButton);
        this.openButton.setPreferredSize(UIConsts.BUTTON_ICON_SIZE);
        SpringUtilities.makeCompactGrid(jPanel2, 1, 2, 0, 0, 1, 1);
        jPanel.add((Component)this.l_name, 0);
        jPanel.add((Component)jPanel2, 1);
        jPanel.add((Component)this.l_date, 2);
        jPanel.add((Component)this.jCalendarCombo, 3);
        SpringUtilities.makeCompactGrid(jPanel, 3, 2, 5, 5, 10, 15);
        this.add(jPanel);
        try {
            this.placeChooser = (PlaceChooser)this.w.get();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in constructing BirthDataPanel ", exception);
        }
        this.add(this.placeChooser);
        SpringUtilities.makeCompactGrid(this, 2, 1, 5, 5, 0, 0);
        this.setBorder(UIConsts.getTitleBorder(this.title));
    }

    public String getPersonName() {
        return this.name.getText();
    }

    public Place getBirthPlace() {
        return this.placeChooser.getSelectedPlace();
    }

    public Calendar getBirthTime() {
        Calendar calendar = AstroUtil.getCalendar(this.timeChooser.getSelectedDate());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(this.jCalendarCombo.getSelectedYear()), Integer.parseInt(this.jCalendarCombo.getSelectedMonth()) - 1, Integer.parseInt(this.jCalendarCombo.getSelectedDay()), calendar.get(11), calendar.get(12), calendar.get(13));
        return gregorianCalendar;
    }

    public BirthData getBirthData() {
        return new BirthData(this.getPersonName(), this.getBirthTime(), this.getBirthPlace());
    }

    public void setPersonName(String string) {
        this.name.setText(string);
    }

    public void setBirthPlace(Place place) {
        this.placeChooser.setSelectedPlace(place);
    }

    public void setBirthTime(Calendar calendar) {
        this.timeChooser.setSelectedDate(calendar.getTime());
        this.jCalendarCombo.setSelectedDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public void setBirthData(BirthData birthData) {
        this.setPersonName(birthData.name());
        this.setBirthTime(birthData.birthDay());
        this.setBirthPlace(birthData.getBirthPlace());
    }

    private void browseHoroscope() {
        String string = FileOps.openFileDialog(this, FileOps.FileDialogMode.OPEN, AstrosoftFileFilter.HOROSCOPE_EXTN);
        if (string != null) {
            this.setBirthData(BirthData.valueOfXMLNode(XMLHelper.parseXML(string).getChildNodes().item(0)));
        }
    }

    private class Worker
    extends SwingWorker<PlaceChooser, Void> {
        private Worker() {
        }

        @Override
        public PlaceChooser doInBackground() {
            try {
                PlaceChooser placeChooser = new PlaceChooser(new Dimension(((BirthDataPanel)BirthDataPanel.this).panelSize.width - 60, ((BirthDataPanel)BirthDataPanel.this).panelSize.height - (int)((double)((BirthDataPanel)BirthDataPanel.this).panelSize.height * 0.5)), false);
                return placeChooser;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Exception in constructing BirthDataPanel ", exception);
                return null;
            }
        }

        @Override
        protected void done() {
        }
    }
}

