/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.ui.comp.CalendarSpinner;
import app.astrosoft.ui.comp.DateListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;

public abstract class CalendarChooser {
    private List<DateListener> listeners = new ArrayList<DateListener>();

    public static CalendarSpinner getMonthChooser() {
        return new CalendarSpinner("MMM yyyy");
    }

    public static CalendarSpinner getTimeChooser() {
        return new CalendarSpinner("hh : mm : ss a");
    }

    public static CalendarSpinner getDateChooser() {
        return new CalendarSpinner("dd MMM yyyy");
    }

    protected CalendarChooser() {
    }

    public void addDateListener(DateListener dateListener) {
        this.listeners.add(dateListener);
    }

    public void removeDateListener(DateListener dateListener) {
        this.listeners.remove(dateListener);
    }

    protected void selectionChanged(ChangeEvent changeEvent) {
        JSpinner jSpinner = (JSpinner)changeEvent.getSource();
        this.notifyListeners((Date)jSpinner.getValue());
    }

    private void notifyListeners(Date date) {
        for (DateListener dateListener : this.listeners) {
            dateListener.dateChanged(date);
        }
    }

    public abstract Date getSelectedDate();

    public abstract void setSelectedDate(Date var1);

    public abstract JPanel getChooser();

    public abstract JPanel getChooser(String var1);

    public abstract void setForeground(Color var1);

    public abstract void setBackground(Color var1);
}

