/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.ui.comp;

import app.astrosoft.ui.comp.CalendarChooser;
import app.astrosoft.ui.util.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalendarSpinner
extends CalendarChooser {
    public static final String FMT_MONTH_YEAR = "MMM yyyy";
    public static final String FMT_DATE = "dd MMM yyyy";
    public static final String FMT_YEAR = "yyyy";
    public static final String FMT_MONTH = "MMM";
    public static final String FMT_TIME = "hh : mm : ss a";
    private static final Dimension spinnerSize = new Dimension(80, 20);
    private JSpinner spinner;
    private JSpinner.DateEditor editor;
    private String dateFormat;
    private JPanel chooserPanel;

    public CalendarSpinner(String string) {
        this.dateFormat = string;
    }

    @Override
    public JPanel getChooser() {
        this.createSpinner();
        this.chooserPanel = new JPanel(new BorderLayout());
        this.chooserPanel.add((Component)this.spinner, "Center");
        return this.chooserPanel;
    }

    @Override
    public JPanel getChooser(String string) {
        this.createSpinner();
        this.chooserPanel = new JPanel(new SpringLayout());
        JLabel jLabel = new JLabel(string);
        this.chooserPanel.add(jLabel);
        this.chooserPanel.add(this.spinner);
        SpringUtilities.makeCompactGrid(this.chooserPanel, 1, 2, 5, 5, 10, 10);
        return this.chooserPanel;
    }

    private void createSpinner() {
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        this.spinner = new JSpinner(spinnerDateModel);
        this.spinner.setPreferredSize(spinnerSize);
        this.editor = new JSpinner.DateEditor(this.spinner, this.dateFormat);
        this.spinner.setEditor(this.editor);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CalendarSpinner.this.selectionChanged(changeEvent);
            }
        });
    }

    @Override
    public void setSelectedDate(Date date) {
        this.spinner.setValue(date);
    }

    @Override
    public void setForeground(Color color) {
        this.editor.getTextField().setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        this.editor.getTextField().setBackground(color);
        this.chooserPanel.setBackground(color);
    }

    public void setDateFormat(String string) {
        Color color = this.editor.getTextField().getBackground();
        Color color2 = this.editor.getTextField().getForeground();
        this.dateFormat = string;
        this.editor = new JSpinner.DateEditor(this.spinner, this.dateFormat);
        this.editor.getTextField().setForeground(color2);
        this.editor.getTextField().setBackground(color);
        this.spinner.setEditor(this.editor);
    }

    @Override
    public Date getSelectedDate() {
        return (Date)this.spinner.getValue();
    }
}

